/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jee.ui.navigator.internal;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.jee.ui.navigator.internal.EMFModelManager;
import com.ibm.etools.jee.ui.navigator.internal.EMFModelManagerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;

public class EMFRootObjectProvider
implements IResourceChangeListener,
IResourceDeltaVisitor,
IElementChangedListener {
    private final HashMap emfModelCache = new HashMap();
    private final List listeners = new ArrayList();

    public EMFRootObjectProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object[] getModels(IProject project) {
        try {
            EMFModelManager modelManager = (EMFModelManager)this.emfModelCache.get(project);
            if (modelManager == null) {
                HashMap hashMap = this.emfModelCache;
                synchronized (hashMap) {
                    modelManager = EMFModelManagerFactory.createEMFModelManager(project, this);
                    this.emfModelCache.put(project, modelManager);
                }
            }
            return modelManager.getModels();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized boolean hasLoadedModels(IProject project) {
        return this.emfModelCache.get(project) != null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                J2EEUIPlugin.logError(e);
            }
            catch (SWTException swte) {
                J2EEUIPlugin.logError(swte);
            }
            catch (SWTError swte) {
                J2EEUIPlugin.logError(swte);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource != null) {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    boolean projectBeingClosed;
                    IProject project = (IProject)resource;
                    boolean bl = projectBeingClosed = (delta.getFlags() & 0x4000) != 0 && !project.isOpen();
                    if (delta.getKind() == 2 || projectBeingClosed) {
                        this.dispose(project);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private void dispose(IProject project) {
        if (project == null) {
            return;
        }
        EMFModelManager modelManager = (EMFModelManager)this.emfModelCache.remove(project);
        if (modelManager != null) {
            modelManager.dispose();
            modelManager = null;
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        EMFModelManager modelManager = null;
        Object[] keys = this.emfModelCache.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            modelManager = (EMFModelManager)this.emfModelCache.remove(keys[i]);
            if (modelManager != null) {
                modelManager.dispose();
            }
            ++i;
        }
    }

    public void notifyListeners(IProject aProject) {
        int x = 0;
        while (x < this.listeners.size()) {
            IRefreshHandlerListener refreshHandler = (IRefreshHandlerListener)this.listeners.get(x);
            refreshHandler.onRefresh(aProject);
            ++x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshHandlerListener(IRefreshHandlerListener aListener) {
        List list = this.getListeners();
        synchronized (list) {
            if (aListener != null && !this.getListeners().contains(aListener)) {
                this.getListeners().add(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefreshHandlerListener(IRefreshHandlerListener aListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(aListener);
        }
    }

    protected List getListeners() {
        return this.listeners;
    }

    public void elementChanged(ElementChangedEvent event) {
        this.processDelta(event.getDelta());
    }

    private void processDelta(IJavaElementDelta delta) {
        IJavaElement jElement = delta.getElement();
        int type = jElement.getElementType();
        if (type == 1) {
            IJavaElementDelta[] deltas = delta.getChangedChildren();
            int i = 0;
            while (i < deltas.length) {
                IJavaElementDelta javaElementDelta = deltas[i];
                this.processDelta(javaElementDelta);
                ++i;
            }
        } else if (type == 2) {
            IJavaProject jproj = (IJavaProject)jElement;
            int kind = delta.getKind();
            if (kind == 4 && this.hasLoadedModels(jproj.getProject())) {
                this.notifyListeners(jproj.getProject());
            }
        }
    }

    public static interface IRefreshHandlerListener {
        public void onRefresh(Object var1);
    }
}

