/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ui.workingsets;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public abstract class JEEWorkingSetUpdater
implements IWorkingSetUpdater {
    private IWorkingSet fWorkingSet;
    private String facetType = null;
    private IResourceChangeListener fResourceChangeListener;

    protected void processRemoves(IResourceDelta[] affectedChildren) {
        WorkingSetDelta workingSetDelta = new WorkingSetDelta(this.fWorkingSet);
        if (affectedChildren != null) {
            int r = 0;
            while (r < affectedChildren.length) {
                IResource resource = affectedChildren[r].getResource();
                int kind = affectedChildren[r].getKind();
                int index = workingSetDelta.indexOf(resource);
                if (index != -1 && kind == 2) {
                    workingSetDelta.remove(index);
                }
                ++r;
            }
        }
        workingSetDelta.process();
    }

    public JEEWorkingSetUpdater(String aDefaultWorkingSetName, String aFacetType) {
        this.facetType = aFacetType;
        this.init();
    }

    public void init() {
        this.fResourceChangeListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceChangeListener, 1);
    }

    public void add(IWorkingSet workingSet) {
        this.fWorkingSet = workingSet;
        this.updateElements(this.fWorkingSet);
    }

    public boolean remove(IWorkingSet workingSet) {
        return true;
    }

    public boolean contains(IWorkingSet workingSet) {
        return workingSet.equals(this.fWorkingSet);
    }

    public static IProject[] getAllProjectsInWorkspaceWithFacet(String facetName) {
        if (!ProjectFacetsManager.isProjectFacetDefined((String)facetName)) {
            return new IProject[0];
        }
        IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)facetName);
        Set projects = new HashSet();
        try {
            projects = ProjectFacetsManager.getFacetedProjects();
        }
        catch (CoreException e) {
            J2EEUIPlugin.logError(e);
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IFacetedProject fp : projects) {
            if (!fp.hasProjectFacet(projectFacet)) continue;
            result.add(fp.getProject());
        }
        return result.toArray(new IProject[result.size()]);
    }

    public void dispose() {
        if (this.fResourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceChangeListener);
            this.fResourceChangeListener = null;
        }
        this.fWorkingSet = null;
    }

    public void updateElements(IWorkingSet workingSet) {
        IProject[] projects = JavaEEProjectUtilities.getAllProjectsInWorkspaceOfType((String)this.facetType);
        final List<IProject> list = Arrays.asList(projects);
        final IWorkingSet fWorkingSet = workingSet;
        J2EEUIPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                fWorkingSet.setElements(list.toArray(new IAdaptable[list.size()]));
            }
        });
    }

    protected void processChanges(IResourceDelta[] affectedChildren) {
        if (affectedChildren != null) {
            int r = 0;
            while (r < affectedChildren.length) {
                IResource resource = affectedChildren[r].getResource();
                int kind = resource.getType();
                if (kind == 4) {
                    IProject project = (IProject)resource;
                    if (!project.isOpen()) {
                        return;
                    }
                    if (JavaEEProjectUtilities.isProjectOfType((IProject)project, (String)this.facetType)) {
                        final HashSet<IAdaptable> elements = new HashSet<IAdaptable>(Arrays.asList(this.fWorkingSet.getElements()));
                        elements.add((IAdaptable)project);
                        J2EEUIPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                JEEWorkingSetUpdater.this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
                            }
                        });
                    } else {
                        final ArrayList<IAdaptable> projects = new ArrayList<IAdaptable>(Arrays.asList(this.fWorkingSet.getElements()));
                        if (projects.contains(project)) {
                            projects.remove(project);
                            J2EEUIPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    JEEWorkingSetUpdater.this.fWorkingSet.setElements(projects.toArray(new IAdaptable[projects.size()]));
                                }
                            });
                        }
                    }
                }
                ++r;
            }
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] addedorChangedChildren;
            if (JEEWorkingSetUpdater.this.fWorkingSet == null) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            if (delta.getFlags() == 131072) {
                return;
            }
            IResourceDelta[] affectedChildren = delta.getAffectedChildren(2, 4);
            if (affectedChildren.length > 0) {
                JEEWorkingSetUpdater.this.processRemoves(affectedChildren);
            }
            if ((addedorChangedChildren = delta.getAffectedChildren(5, 4)).length > 0) {
                JEEWorkingSetUpdater.this.processChanges(addedorChangedChildren);
            }
        }
    }

    private class WorkingSetDelta {
        private IWorkingSet fWorkingSet;
        private List fElements;
        private boolean fChanged;

        public WorkingSetDelta(IWorkingSet workingSet) {
            this.fWorkingSet = workingSet;
            this.fElements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        }

        public int indexOf(Object element) {
            return this.fElements.indexOf(element);
        }

        public void set(int index, Object element) {
            this.fElements.set(index, element);
            this.fChanged = true;
        }

        public void remove(int index) {
            if (this.fElements.remove(index) != null) {
                this.fChanged = true;
            }
        }

        public void process() {
            if (this.fChanged) {
                J2EEUIPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkingSetDelta.this.fWorkingSet.setElements(WorkingSetDelta.this.fElements.toArray(new IAdaptable[WorkingSetDelta.this.fElements.size()]));
                    }
                });
            }
        }
    }
}

