/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ui;

import com.ibm.etools.ejb.ui.wizards.ClassesImportWizard;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.internal.ejb.provider.GroupedEJBItemProvider;
import org.eclipse.jst.j2ee.internal.ejb.provider.GroupedEntityItemProvider;
import org.eclipse.jst.j2ee.internal.ejb.provider.GroupedMessageItemProvider;
import org.eclipse.jst.j2ee.internal.ejb.provider.GroupedSessionItemProvider;
import org.eclipse.jst.j2ee.internal.provider.J2EEItemProvider;
import org.eclipse.jst.j2ee.internal.wizard.ImportUtil;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.widgets.TreeItem;

public class AssemblyEditingDomainViewerDropAdapter
extends EditingDomainViewerDropAdapter {
    public static final boolean IS_WINDOWS = SWT.getPlatform().toLowerCase().startsWith("win");
    public DropTargetEvent savedEvent = null;
    public TreeItem sourceItemParent = null;
    public static LocalTransfer localTransfer = LocalTransfer.getInstance();
    public static FileTransfer fileTransfer = FileTransfer.getInstance();
    public Object[] objectsBeingDragged = null;
    public int[] fileTypes = null;
    public boolean sourceIsValidated = false;
    public boolean previousSourceValidation;

    public AssemblyEditingDomainViewerDropAdapter(EditingDomain domain, Viewer viewer) {
        super(domain, viewer);
    }

    protected boolean draggingComplexFileObjects(DropTargetEvent event) {
        return fileTransfer.isSupportedType(event.currentDataType) && this.objectsBeingDragged != null;
    }

    protected boolean draggingComplexLocalObjects(DropTargetEvent event) {
        if (localTransfer.isSupportedType(event.currentDataType)) {
            int i = 0;
            while (i < this.objectsBeingDragged.length) {
                if (this.objectsBeingDragged[i] instanceof EnterpriseBean) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean draggingComplexObjects(DropTargetEvent event) {
        return this.draggingComplexFileObjects(event) || this.draggingComplexLocalObjects(event);
    }

    public boolean isTreeItemParent(TreeItem parent, Object child) {
        TreeItem[] children = parent.getItems();
        int i = 0;
        while (i < children.length) {
            Object parentsChild = children[i].getData();
            if (parentsChild.equals(child)) {
                return true;
            }
            if (parentsChild instanceof J2EEItemProvider) {
                TreeItem[] grandchildren = children[i].getItems();
                int j = 0;
                while (j < grandchildren.length) {
                    Object data = grandchildren[j].getData();
                    if (data != null && data.equals(child)) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean compatibleSourceObjects(DropTargetEvent event) {
        if (!this.sourceIsValidated) {
            this.sourceIsValidated = true;
            this.previousSourceValidation = true;
            if (fileTransfer.isSupportedType(event.currentDataType) && this.objectsBeingDragged != null && this.objectsBeingDragged instanceof String[]) {
                int i = 0;
                while (i < ((String[])this.objectsBeingDragged).length) {
                    String fileName = ((String[])this.objectsBeingDragged)[i];
                    int fileType = ImportUtil.getVersionedFileType((String)fileName);
                    switch (fileType & 0xFFFFFE3F) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            this.fileTypes[i] = fileType;
                            break;
                        }
                        default: {
                            this.previousSourceValidation = false;
                            return false;
                        }
                    }
                    ++i;
                }
                return true;
            }
            if (this.sourceItemParent == null) {
                this.previousSourceValidation = false;
                return false;
            }
            if (localTransfer.isSupportedType(event.currentDataType) && this.objectsBeingDragged != null) {
                int i = 0;
                while (i < this.objectsBeingDragged.length) {
                    if (!this.isTreeItemParent(this.sourceItemParent, this.objectsBeingDragged[i])) {
                        this.previousSourceValidation = false;
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return true;
        }
        return this.previousSourceValidation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean validDestinationObject(DropTargetEvent event) {
        Object dropTarget = null;
        if (event.item != null) {
            dropTarget = event.item.getData();
        }
        if (fileTransfer.isSupportedType(event.currentDataType)) {
            if (this.fileTypes == null) return false;
            if (dropTarget instanceof Application) {
                if (((Application)dropTarget).getVersionID() == 12) {
                    int i = 0;
                    while (i < this.fileTypes.length) {
                        if ((this.fileTypes[i] & 0x80) != 0) {
                            return false;
                        }
                        if (this.fileTypes[i] == 6) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                } else {
                    int i = 0;
                    while (i < this.fileTypes.length) {
                        if (this.fileTypes[i] == 6) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            } else if (dropTarget instanceof EJBJar) {
                if (((EJBJar)dropTarget).getVersionID() != 11) return true;
                int i = 0;
                while (i < this.fileTypes.length) {
                    if (this.fileTypes[i] == 130) {
                        return false;
                    }
                    ++i;
                }
                return true;
            } else if (dropTarget instanceof ApplicationClient) {
                if (((ApplicationClient)dropTarget).getVersionID() != 12) return true;
                int i = 0;
                while (i < this.fileTypes.length) {
                    if (this.fileTypes[i] == 132) {
                        return false;
                    }
                    ++i;
                }
                return true;
            } else if (dropTarget instanceof WebApp) {
                if (((WebApp)dropTarget).getVersionID() != 22) return true;
                int i = 0;
                while (i < this.fileTypes.length) {
                    if (this.fileTypes[i] == 131) {
                        return false;
                    }
                    ++i;
                }
                return true;
            } else {
                int i = 0;
                while (i < this.fileTypes.length) {
                    if (this.fileTypes[i] == 6) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        if (!localTransfer.isSupportedType(event.currentDataType) || this.sourceItemParent == null || dropTarget == null || this.objectsBeingDragged == null) return false;
        if (this.objectsBeingDragged[0] instanceof EnterpriseBean && !(dropTarget instanceof EJBJar)) {
            if (dropTarget instanceof GroupedEJBItemProvider && ((GroupedEJBItemProvider)dropTarget).getParent().equals(this.sourceItemParent.getData())) {
                return false;
            }
            boolean entity = false;
            boolean session = false;
            boolean messageDriven = false;
            int i = 0;
            while (i < this.objectsBeingDragged.length) {
                if (this.objectsBeingDragged[i] instanceof Entity) {
                    entity = true;
                } else if (this.objectsBeingDragged[i] instanceof Session) {
                    session = true;
                } else if (this.objectsBeingDragged[i] instanceof MessageDriven) {
                    messageDriven = true;
                }
                ++i;
            }
            if (dropTarget instanceof GroupedEntityItemProvider) {
                return entity;
            }
            if (dropTarget instanceof GroupedSessionItemProvider) {
                return session;
            }
            if (!(dropTarget instanceof GroupedMessageItemProvider)) return false;
            return messageDriven;
        }
        if (!dropTarget.getClass().equals(this.sourceItemParent.getData().getClass()) || dropTarget.equals(this.sourceItemParent.getData())) return false;
        if (dropTarget instanceof Application) {
            if (((Application)dropTarget).getVersionID() != 12) return true;
            int i = 0;
            while (i < this.objectsBeingDragged.length) {
                if (this.objectsBeingDragged[i] instanceof EJBJar) {
                    if (((EJBJar)this.objectsBeingDragged[i]).getVersionID() >= 20) {
                        return false;
                    }
                } else if (this.objectsBeingDragged[i] instanceof WebApp) {
                    if (((WebApp)this.objectsBeingDragged[i]).getVersionID() >= 23) {
                        return false;
                    }
                } else {
                    if (!(this.objectsBeingDragged[i] instanceof ApplicationClient)) return false;
                    if (((ApplicationClient)this.objectsBeingDragged[i]).getVersionID() >= 13) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        } else if (dropTarget instanceof EJBJar) {
            if (((EJBJar)dropTarget).getVersionID() != 11) return true;
            int i = 0;
            while (i < this.objectsBeingDragged.length) {
                if (!(this.objectsBeingDragged[i] instanceof EnterpriseBean)) return false;
                if (((EnterpriseBean)this.objectsBeingDragged[i]).getVersionID() >= 20) {
                    return false;
                }
                if (((EnterpriseBean)this.objectsBeingDragged[i]).isMessageDriven()) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if (dropTarget instanceof WebApp) {
                return false;
            }
            if (dropTarget instanceof ApplicationClient) {
                return false;
            }
            if (!(dropTarget instanceof Connector)) return true;
            return false;
        }
    }

    protected List objectsBeingDropped(DropTargetEvent event) {
        if (fileTransfer.isSupportedType(event.currentDataType)) {
            if (this.objectsBeingDragged != null) {
                ArrayList<Object> list = new ArrayList<Object>(this.objectsBeingDragged.length);
                list.addAll(Arrays.asList(this.objectsBeingDragged));
                return list;
            }
            return null;
        }
        if (localTransfer.isSupportedType(event.currentDataType)) {
            if (this.objectsBeingDragged != null) {
                ArrayList<Object> list = new ArrayList<Object>(this.objectsBeingDragged.length);
                list.addAll(Arrays.asList(this.objectsBeingDragged));
                return list;
            }
            return null;
        }
        return null;
    }

    public String getNewProjectName(String projectName) {
        String newProjectName = projectName;
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (projectHandle.exists()) {
            int i = 0;
            while (++i < 10) {
                projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(projectName) + i);
                if (projectHandle.exists()) continue;
                newProjectName = String.valueOf(projectName) + i;
                return newProjectName;
            }
        }
        return newProjectName;
    }

    public void showImportWizard(List remainingObjects, DropTargetEvent event) {
        Object dropTarget = event.item != null ? event.item.getData() : null;
        if (dropTarget instanceof GroupedEJBItemProvider) {
            dropTarget = ((GroupedEJBItemProvider)dropTarget).getParent();
        }
        IProject destProject = J2EEUIPlugin.getProjectFromObject(dropTarget);
        J2EEUIPlugin plugin = J2EEUIPlugin.getDefault();
        String destProjectName = null;
        if (destProject != null && (dropTarget instanceof Application || dropTarget instanceof ApplicationClient || dropTarget instanceof Connector || dropTarget instanceof EJBJar || dropTarget instanceof WebApp)) {
            destProjectName = destProject.getName();
        }
        while (remainingObjects.size() > 0) {
            WizardDialog dialog = null;
            Object nextObject = remainingObjects.remove(0);
            if (!(nextObject instanceof EnterpriseBean) && nextObject instanceof String) {
                String fileName = (String)nextObject;
                int fileType = ImportUtil.getFileType((String)fileName);
                switch (fileType) {
                    case 1: {
                        break;
                    }
                    case 4: {
                        if (destProjectName == null) break;
                        boolean cfr_ignored_0 = dropTarget instanceof ApplicationClient;
                        break;
                    }
                    case 5: {
                        if (destProjectName == null) break;
                        boolean cfr_ignored_1 = dropTarget instanceof Connector;
                        break;
                    }
                    case 3: {
                        if (destProjectName == null) break;
                        boolean cfr_ignored_2 = dropTarget instanceof WebApp;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 6: {
                        ClassesImportWizard wizard = new ClassesImportWizard(destProject, fileName, remainingObjects);
                        wizard.init(plugin.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                        wizard.setDialogSettings(plugin.getDialogSettings());
                        dialog = new WizardDialog(plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    }
                }
            }
            if (dialog == null) continue;
            try {
                dialog.create();
                dialog.open();
            }
            catch (Exception e) {
                J2EEUIPlugin.logError(e);
            }
        }
    }

    public static void complexDropAllowed(DropTargetEvent event, boolean allowed) {
        event.detail = allowed ? 1 : 0;
        event.feedback = 1;
    }

    public void forceCopyOverMove(DropTargetEvent event) {
        if (event.detail == 2) {
            event.detail = 1;
        }
    }

    public void dragEnter(DropTargetEvent event) {
        this.objectsBeingDragged = null;
        this.fileTypes = null;
        this.sourceIsValidated = false;
        this.savedEvent = null;
        if (event.item != null) {
            if (event.item instanceof TreeItem) {
                this.sourceItemParent = ((TreeItem)event.item).getParentItem();
                if (this.sourceItemParent != null && this.sourceItemParent.getData() instanceof J2EEItemProvider) {
                    this.sourceItemParent = this.sourceItemParent.getParentItem();
                }
            } else {
                this.sourceItemParent = null;
            }
        } else {
            this.sourceItemParent = null;
        }
        this.forceCopyOverMove(event);
        super.dragEnter(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (IS_WINDOWS && this.draggingComplexObjects(event)) {
            AssemblyEditingDomainViewerDropAdapter.complexDropAllowed(event, this.compatibleSourceObjects(event) && this.validDestinationObject(event));
        }
        this.forceCopyOverMove(event);
        super.dragOperationChanged(event);
    }

    public void dragOver(DropTargetEvent event) {
        if (IS_WINDOWS) {
            this.extractData(event);
        }
        if (event.currentDataType != null && event.item != null) {
            this.savedEvent = event;
        }
        this.forceCopyOverMove(event);
        super.dragOver(event);
        if (IS_WINDOWS) {
            AssemblyEditingDomainViewerDropAdapter.complexDropAllowed(event, this.compatibleSourceObjects(event) && this.validDestinationObject(event));
        }
    }

    protected void extractData(DropTargetEvent event) {
        if (this.objectsBeingDragged == null) {
            if (fileTransfer.isSupportedType(event.currentDataType)) {
                Object object = fileTransfer.nativeToJava(event.currentDataType);
                if (object instanceof String[]) {
                    this.objectsBeingDragged = (String[])object;
                    this.fileTypes = new int[((String[])this.objectsBeingDragged).length];
                }
            } else if (localTransfer.isSupportedType(event.currentDataType)) {
                if (IS_WINDOWS) {
                    Object object = localTransfer.nativeToJava(event.currentDataType);
                    if (object instanceof StructuredSelection) {
                        this.objectsBeingDragged = ((StructuredSelection)object).toArray();
                    }
                } else {
                    this.objectsBeingDragged = super.extractDragSource(event.data).toArray();
                }
            }
        }
    }

    public void dropAccept(DropTargetEvent event) {
        this.forceCopyOverMove(event);
        super.dropAccept(event);
    }

    public void drop(DropTargetEvent event) {
        this.extractData(event);
        AssemblyEditingDomainViewerDropAdapter.complexDropAllowed(event, this.compatibleSourceObjects(event) && this.validDestinationObject(event));
        if (this.savedEvent != null) {
            event = this.savedEvent;
            this.savedEvent = null;
        }
        this.forceCopyOverMove(event);
        if (this.draggingComplexObjects(event)) {
            if (this.compatibleSourceObjects(event) && this.validDestinationObject(event)) {
                List objects = this.objectsBeingDropped(event);
                this.showImportWizard(objects, event);
            }
        } else {
            super.drop(event);
        }
    }
}

