/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.manifest.ui;

import com.ibm.etools.common.ui.nls.CommonAppEJBResourceHandler;
import com.ibm.etools.emf.workbench.ui.custom.widgets.CommonFormSection;
import com.ibm.etools.emf.workbench.ui.custom.widgets.SectionControlInitializer;
import com.ibm.etools.emf.workbench.ui.nls.EMFWorkbenchUIResourceHandler;
import com.ibm.etools.j2ee.ui.nls.UIResourceHandler;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.ClasspathModel;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SectionUsage
extends CommonFormSection
implements Listener {
    protected CCombo availableAppsCombo;
    protected Button refreshButton;
    protected Text uriText;
    protected ClasspathModel model;
    protected Label errorLabel;

    public SectionUsage(Composite parent, int style, SectionControlInitializer initializer) {
        super(parent, style, UIResourceHandler.USAGE_HEADING_UI_, UIResourceHandler.USAGE_DESCRIPTION_UI_, initializer);
    }

    protected Composite createCollapsableClient(Composite parent) {
        Composite composite = this.getWf().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 10;
        layout.marginWidth = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(512);
        composite.setLayoutData((Object)data);
        this.createChildControls(composite);
        return composite;
    }

    protected void createChildControls(Composite parent) {
        this.createAvailableAppsControls(parent);
        this.createUriControls(parent);
        this.createErrorLabelGroup(parent);
        this.getWf().paintBordersFor(parent);
    }

    protected void createErrorLabelGroup(Composite parent) {
        this.errorLabel = this.getWf().createLabel(parent, "");
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.errorLabel.setLayoutData((Object)data);
        this.errorLabel.setForeground(this.errorLabel.getDisplay().getSystemColor(3));
    }

    protected void setErrorMessage(String message) {
        this.errorLabel.setText(message);
    }

    protected void checkForEar() {
        if (this.availableAppsCombo.getItemCount() == 0) {
            this.setErrorMessage(ClasspathModel.NO_EAR_MESSAGE);
        } else {
            this.setErrorMessage("");
        }
    }

    public void addControlListener(ControlListener listener) {
        super.addControlListener(listener);
    }

    protected void createAvailableAppsControls(Composite parent) {
        this.getWf().createLabel(parent, UIResourceHandler.ENTERPRISE_APPLICATION_LABEL_UI_);
        this.availableAppsCombo = this.getWf().createCCombo(parent);
        GridData gd = new GridData(1796);
        this.availableAppsCombo.setLayoutData((Object)gd);
        this.availableAppsCombo.addListener(13, (Listener)this);
        this.refreshButton = this.getWf().createButton(parent, CommonAppEJBResourceHandler.Refresh_UI_, 8);
        gd = new GridData(256);
        this.refreshButton.setLayoutData((Object)gd);
        this.refreshButton.addListener(13, (Listener)this);
    }

    protected void createSpacer(Composite parent) {
        this.getWf().createLabel(parent, "");
    }

    protected void createUriControls(Composite parent) {
        this.getWf().createLabel(parent, UIResourceHandler.URI_LABEL_UI_);
        this.uriText = this.getWf().createText(parent, "", 8);
        this.uriText.setLayoutData((Object)new GridData(768));
        this.uriText.setForeground(this.getWf().getForegroundColor());
        Button spacer = this.getWf().createButton(parent, EMFWorkbenchUIResourceHandler.Deselect_All_4, 8);
        spacer.setVisible(false);
        spacer.setLayoutData((Object)new GridData(256));
    }

    protected void setDefaults() {
        this.populateApps();
        this.setUriText();
        this.checkForEar();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.availableAppsCombo) {
            this.availableAppsSelected(event);
        } else if (event.widget == this.refreshButton) {
            this.refreshAvailableApps();
        }
    }

    protected void availableAppsSelected(Event event) {
        int index = this.availableAppsCombo.getSelectionIndex();
        this.model.selectEAR(index);
    }

    protected void refreshAvailableApps() {
        this.model.refresh();
        this.setDefaults();
        this.checkForEar();
    }

    protected void populateApps() {
        IVirtualComponent[] earCompas = this.getModel().getAvailableEARComponents();
        if (earCompas == null || earCompas.length == 0) {
            return;
        }
        IProject[] projects = ProjectUtilities.getAllProjects();
        ArrayList<String> earNames = new ArrayList<String>();
        List<IVirtualComponent> earComponentsList = Arrays.asList(this.getModel().getAvailableEARComponents());
        int i = 0;
        while (i < projects.length) {
            try {
                IVirtualComponent earComp;
                if (J2EEProjectUtilities.getJ2EEProjectType((IProject)projects[i]).equals("jst.ear") && earComponentsList.contains(earComp = ComponentCore.createComponent((IProject)projects[i]))) {
                    earNames.add(projects[i].getName());
                }
            }
            catch (Exception ex) {
                J2EEUIPlugin.logError(ex);
            }
            ++i;
        }
        String[] values = new String[earNames.size()];
        int i2 = 0;
        while (i2 < earNames.size()) {
            values[i2] = (String)earNames.get(i2);
            ++i2;
        }
        this.availableAppsCombo.setItems(values);
        this.availableAppsCombo.select(0);
    }

    protected void setUriText() {
        String uri = this.model.getArchiveURI();
        if (uri != null) {
            this.uriText.setText(uri);
        } else {
            this.uriText.setText("");
        }
    }

    protected SectionControlInitializer createDefaultControlInitializer() {
        SectionControlInitializer init = super.createDefaultControlInitializer();
        init.setMessageAreaWidth(400);
        init.setCollapsable(true);
        return init;
    }

    public ClasspathModel getModel() {
        return this.model;
    }

    public void setModel(ClasspathModel model) {
        this.model = model;
        this.setDefaults();
    }
}

