/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.manifest.ui;

import com.ibm.etools.common.ui.nls.CommonAppEJBResourceHandler;
import com.ibm.etools.common.ui.wizards.NewJavaClassWizard;
import com.ibm.etools.ejb.creation.wizard.PageHelper;
import com.ibm.etools.emf.workbench.ui.custom.widgets.CommonFormSection;
import com.ibm.etools.emf.workbench.ui.custom.widgets.SectionControlInitializer;
import com.ibm.etools.emf.workbench.ui.listeners.FocusListenerModifier;
import com.ibm.etools.j2ee.common.operations.NewJavaClassDataModel;
import com.ibm.etools.j2ee.manifest.ui.JARDependencyEditor;
import com.ibm.etools.j2ee.ui.nls.UIResourceHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.internal.common.ClasspathModel;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelEvent;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelListener;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.internal.emf.utilities.StringUtil;
import org.eclipse.wst.common.internal.emfworkbench.integration.OwnerProvider;

public class SectionMainClass
extends CommonFormSection
implements ClasspathModelListener {
    protected Text mainClassText;
    protected Button browseButton;
    protected Button createButton;
    protected Button removeButton;
    protected Label messageLabel;
    protected IProject mainClassProject;
    protected ClasspathModel model;

    public SectionMainClass(Composite parent, int style, String aTitle, String formInfo, SectionControlInitializer initializer) {
        super(parent, style, aTitle, formInfo, initializer);
    }

    protected Composite createCollapsableClient(Composite parent) {
        Composite composite = this.getWf().createComposite(parent, 0);
        GridLayout gl = this.commonGridLayout();
        gl.numColumns = 5;
        gl.marginWidth = 10;
        gl.marginHeight = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        this.createControlsMainClass(composite);
        this.createControlsMessage(composite);
        this.getWf().paintBordersFor(composite);
        return composite;
    }

    protected void createControlsMainClass(Composite parent) {
        Label label = this.getWf().createLabel(parent, CommonAppEJBResourceHandler.MAIN_CLASS_LABEL_UI_);
        label.setLayoutData((Object)new GridData(256));
        this.mainClassText = this.getWf().createText(parent, "");
        this.mainClassText.setLayoutData((Object)new GridData(768));
        this.browseButton = this.getWf().createButton(parent, CommonAppEJBResourceHandler.button_browse_UI_, 8);
        this.browseButton.setLayoutData((Object)new GridData(256));
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SectionMainClass.this.handleBrowseButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton = this.getWf().createButton(parent, UIResourceHandler.CREATE_BUTTON_LABEL_UI_, 8);
        this.createButton.setLayoutData((Object)new GridData(256));
        this.createButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SectionMainClass.this.handleCreateButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton = this.getWf().createButton(parent, CommonAppEJBResourceHandler.Remove_UI_, 8);
        this.removeButton.setLayoutData((Object)new GridData(256));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SectionMainClass.this.handleRemoveButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void setupTextListeners() {
        this.createFocusListenerModifier((Control)this.mainClassText, null, false);
    }

    protected FocusListenerModifier primCreateFocusListenerModifier(EStructuralFeature sf, OwnerProvider provider) {
        FocusListenerModifier modifier = new FocusListenerModifier(null, provider, sf){

            public synchronized void handleWidgetDataChange(Widget widget) {
                if (this.isValidatingState) {
                    return;
                }
                SectionMainClass.this.handleMainClassTextModified(widget);
            }
        };
        modifier.setValidateEditListener(this.getSectionControlInitializer().getValidateEditListener());
        return modifier;
    }

    protected void createControlsMessage(Composite parent) {
        this.messageLabel = this.getWf().createLabel(parent, "");
        GridData gd = new GridData(256);
        gd.horizontalSpan = 4;
        gd.verticalSpan = 5;
        this.messageLabel.setLayoutData((Object)gd);
        this.messageLabel.setForeground(this.messageLabel.getDisplay().getSystemColor(3));
    }

    protected void handleMainClassTextModified(Widget widget) {
        String mfClassName;
        boolean classNameEmpty;
        this.messageLabel.setText("");
        this.getParent().layout();
        this.redraw();
        ArchiveManifest manifest = this.getManifest();
        if (manifest == null) {
            return;
        }
        String className = this.mainClassText.getText().trim();
        boolean bl = classNameEmpty = className.length() == 0;
        if (!(widget == null || className.equals(mfClassName = manifest.getMainClass()) || mfClassName == null && className.length() <= 0)) {
            if (classNameEmpty) {
                this.model.updateMainClass(null);
            } else {
                this.model.updateMainClass(className);
            }
        }
        if (!this.validateClassName(className)) {
            return;
        }
        IType mainClassType = null;
        boolean typeExistsInClient = false;
        if (!classNameEmpty) {
            mainClassType = this.findTypeInClientProject(className);
            boolean bl2 = typeExistsInClient = mainClassType != null;
        }
        if (mainClassType == null && !classNameEmpty) {
            this.makeMessageTextVisible();
            this.messageLabel.setText(UIResourceHandler.CLASS_DOES_NOT_EXIST_IN_CLIENT_WARNING_UI_);
        } else {
            this.messageLabel.setText("");
        }
        this.createButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        if (typeExistsInClient) {
            this.createButton.setEnabled(false);
            this.removeButton.setEnabled(true);
        }
    }

    protected IType findTypeInClientProject(String className) {
        IType type = PageHelper.findType(className, this.mainClassProject);
        return type;
    }

    protected IType findTypeInWorskpace(String className) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IType type = null;
        int i = 0;
        int n = projects.length;
        while (i < n) {
            type = PageHelper.findType(className, projects[i]);
            if (type != null) {
                this.mainClassProject = projects[i];
                break;
            }
            ++i;
        }
        return type;
    }

    protected boolean validateClassName(String className) {
        if (className.length() == 0) {
            return true;
        }
        boolean classNameOK = true;
        int index = className.lastIndexOf(".");
        if (index == -1) {
            IStatus status = JavaConventions.validateJavaTypeName((String)className);
            if (status.getMessage().equals(Messages.convention_type_lowercaseName) && !status.isOK()) {
                this.makeMessageTextVisible();
                this.messageLabel.setText(status.getMessage());
                classNameOK = false;
            }
        } else {
            IStatus status = JavaConventions.validatePackageName((String)className);
            if (status.getMessage().equals(Messages.convention_package_uppercaseName) && !status.isOK()) {
                this.makeMessageTextVisible();
                this.messageLabel.setText(status.getMessage());
                classNameOK = false;
            }
        }
        return classNameOK;
    }

    protected void handleBrowseButtonSelected(SelectionEvent e) {
        if (!this.validateState()) {
            return;
        }
        int style = 256;
        IJavaProject javaProj = JemProjectUtilities.getJavaProject((IProject)this.mainClassProject);
        String typeName = PageHelper.selectTypes(this.getShell(), style, null, javaProj, true);
        if (typeName != null) {
            this.mainClassText.setText(typeName);
            this.model.updateMainClass(typeName);
            this.handleMainClassTextModified((Widget)this.mainClassText);
        }
    }

    protected void handleCreateButtonSelected(SelectionEvent e) {
        String oldClassName;
        if (!this.validateState()) {
            return;
        }
        IProject project = this.model.getProject();
        this.getControl().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        NewJavaClassDataModel dataModel = new NewJavaClassDataModel();
        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)project.getName());
        NewJavaClassWizard wizard = new NewJavaClassWizard(dataModel);
        this.launchGenericWizardWithValidate((IWizard)wizard);
        this.getControl().setCursor(null);
        String newClassName = dataModel.getQualifiedClassName();
        if (newClassName == null) {
            newClassName = "";
        }
        if ((oldClassName = this.getMainClassName()) == null) {
            oldClassName = "";
        }
        if (!StringUtil.stringsEqual((String)oldClassName, (String)newClassName)) {
            this.model.updateMainClass(newClassName);
            this.refreshTextField();
        }
    }

    protected void handleRemoveButtonSelected(SelectionEvent e) {
        if (!this.validateState()) {
            return;
        }
        String mainClassName = this.mainClassText.getText().trim();
        if (mainClassName.length() == 0) {
            return;
        }
        this.model.updateMainClass(null);
        this.refreshTextField();
    }

    protected void refreshTextField() {
        String mainClassName = this.getMainClassName();
        if (mainClassName == null) {
            mainClassName = "";
        }
        if (!this.mainClassText.getText().equals(mainClassName)) {
            this.mainClassText.setText(mainClassName);
            this.handleMainClassTextModified((Widget)this.mainClassText);
        }
    }

    public void setModel(ClasspathModel model) {
        this.model = model;
        this.mainClassProject = model.getProject();
        model.addListener((ClasspathModelListener)this);
        this.refreshTextField();
        this.setupTextListeners();
        try {
            if (!this.mainClassProject.hasNature("org.eclipse.jdt.core.javanature")) {
                this.enableChildren(this.getChildren(), false);
            }
        }
        catch (Exception exception) {
            this.enableChildren(this.getChildren(), false);
        }
        if (J2EEProjectUtilities.getReferencingEARProjects((IProject)model.getProject()).length == 0) {
            this.browseButton.setEnabled(false);
            this.createButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.mainClassText.setEnabled(false);
            this.messageLabel.setText(ClasspathModel.NO_EAR_MESSAGE);
        }
    }

    public void modelChanged(ClasspathModelEvent evt) {
        if (evt.getEventType() == 3) {
            this.refreshTextField();
        } else if (evt.getEventType() == 6) {
            this.handleMainClassTextModified(null);
        }
    }

    protected ArchiveManifest getManifest() {
        if (this.model == null) {
            return null;
        }
        return ((JARDependencyEditor.ExtendedClasspathModel)this.model).getManifest();
    }

    protected String getMainClassName() {
        ArchiveManifest mf = this.getManifest();
        if (mf == null) {
            return null;
        }
        return mf.getMainClass();
    }

    public void setFocusToMainClassTextField() {
        this.mainClassText.setFocus();
        this.makeMessageTextVisible();
    }

    protected void makeMessageTextVisible() {
        if (this.getSectionControlInitializer().isFirstTimeLoad()) {
            this.updateScrollPostion();
        }
        this.updateScrollPostion();
    }
}

