/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.presentation.temp;

import com.ibm.etools.j2ee.common.nls.CommonEditResourceHandler;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPreferences;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class J2EEProjectStructurePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int INDENT = 10;
    private static final String PROD_PROP_SOURCE_FOLDER = "defaultJavaSourceFolder";
    private Group earMembershipDescGroup;
    private Button addProjectToEarButton;
    private Text earContentText;
    private Text ejbContentText;
    private Text dynWebContentText;
    private Text connectorText;
    private Text appClientText;
    private Text utilitySourceText;
    private Group generateDeploymentDescGroup;
    private Button generateDDForEarButton;
    private Button generateDDForWebButton;
    private Button generateDDForEJBButton;
    private Button generateDDForAppClientButton;
    private Text dynWebSourceText;
    private Text dynWebOutputText;
    private Text ejbOutputText;
    private Text appClientOutputText;
    private Text jcaOutputText;
    private Text utilityOutputText;
    private ControlDecoration webSrcDecoration;
    private ControlDecoration webContentDecoration;
    private ControlDecoration webOuputDecoration;
    private ControlDecoration ejbSrcDecoration;
    private ControlDecoration ejbOuputDecoration;
    private ControlDecoration appClientSrcDecoration;
    private ControlDecoration appClientOuputDecoration;
    private ControlDecoration jcaSrcDecoration;
    private ControlDecoration jcaOuputDecoration;
    private ControlDecoration utilitySrcDecoration;
    private ControlDecoration utilityOuputDecoration;
    private ControlDecoration earContentDecoration;
    public Color DESC_COLOR = new Color(null, 0, 0, 0);
    boolean initializing = false;
    private FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
    private Map<ControlDecoration, Boolean> validMap = new HashMap<ControlDecoration, Boolean>();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.j2ee.ui.J2EE_PREFERENCE_PAGE");
        this.createEarMembershipGroup(composite);
        this.createSpacer(composite);
        this.createEARPreferenceSection(composite);
        this.createDynWebPreferenceSection(composite);
        this.createEJBPreferenceSection(composite);
        this.createAppClientPreferenceSection(composite);
        this.createJCAPreferenceSection(composite);
        this.createUtilityPreferenceSection(composite);
        this.createSpacer(composite);
        this.createGenerateDeploymentDescriptorGroup(composite);
        this.initializeValues(false);
        return composite;
    }

    private void createEarMembershipGroup(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.setEarMembershipDescGroup(new Group(parent, 0));
        this.getEarMembershipDescGroup().setForeground(this.DESC_COLOR);
        this.getEarMembershipDescGroup().setLayout((Layout)new GridLayout());
        this.getEarMembershipDescGroup().setLayoutData((Object)gd);
        this.getEarMembershipDescGroup().setText(CommonEditResourceHandler.ADD_TO_EAR_DESC_LABEL);
        this.addProjectToEarButton = new Button((Composite)this.getEarMembershipDescGroup(), 32);
        GridData data1 = new GridData();
        data1.horizontalIndent = 10;
        this.addProjectToEarButton.setLayoutData((Object)data1);
        this.addProjectToEarButton.setText(CommonEditResourceHandler.EAR_MEMBERSHIP_LABEL);
    }

    private void createGenerateDeploymentDescriptorGroup(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.setGenerateDeploymentDescGroup(new Group(parent, 0));
        this.getGenerateDeploymentDescGroup().setForeground(this.DESC_COLOR);
        this.getGenerateDeploymentDescGroup().setLayout((Layout)new GridLayout());
        this.getGenerateDeploymentDescGroup().setLayoutData((Object)gd);
        this.getGenerateDeploymentDescGroup().setText(CommonEditResourceHandler.GENERATE_DEPLOYMENT_DESC_LABEL);
        this.generateDDForEarButton = new Button((Composite)this.getGenerateDeploymentDescGroup(), 32);
        GridData data1 = new GridData();
        data1.horizontalIndent = 10;
        this.generateDDForEarButton.setLayoutData((Object)data1);
        this.generateDDForEarButton.setText(CommonEditResourceHandler.GENERATE_DEPLOYMENT_EAR_LABEL);
        this.generateDDForEJBButton = new Button((Composite)this.getGenerateDeploymentDescGroup(), 32);
        GridData data2 = new GridData();
        data2.horizontalIndent = 10;
        this.generateDDForEJBButton.setLayoutData((Object)data2);
        this.generateDDForEJBButton.setText(CommonEditResourceHandler.GENERATE_DEPLOYMENT_EJB_LABEL);
        this.generateDDForWebButton = new Button((Composite)this.getGenerateDeploymentDescGroup(), 32);
        GridData data3 = new GridData();
        data3.horizontalIndent = 10;
        this.generateDDForWebButton.setLayoutData((Object)data3);
        this.generateDDForWebButton.setText(CommonEditResourceHandler.GENERATE_DEPLOYMENT_WEB_LABEL);
        this.generateDDForAppClientButton = new Button((Composite)this.getGenerateDeploymentDescGroup(), 32);
        GridData data4 = new GridData();
        data4.horizontalIndent = 10;
        this.generateDDForAppClientButton.setLayoutData((Object)data4);
        this.generateDDForAppClientButton.setText(CommonEditResourceHandler.GENERATE_DEPLOYMENT_APP_CLIENT_LABEL);
    }

    public void setGenerateDeploymentDescGroup(Group generateDeploymentDescGroup) {
        this.generateDeploymentDescGroup = generateDeploymentDescGroup;
    }

    private void createSpacer(Composite parent) {
        Label space = new Label(parent, 0);
        GridData data = new GridData(768);
        space.setLayoutData((Object)data);
    }

    public boolean performOk() {
        J2EEPreferences preferences = J2EEPlugin.getDefault().getJ2EEPreferences();
        preferences.setValue("addToEarByDefault", this.addProjectToEarButton.getSelection());
        preferences.setValue("earContent", this.earContentText.getText());
        preferences.setValue("webContent", this.dynWebContentText.getText());
        preferences.setValue("ejbContent", this.ejbContentText.getText());
        preferences.setValue("jcaContent", this.connectorText.getText());
        preferences.setValue("appClientContent", this.appClientText.getText());
        preferences.setValue("application_generate_dd", this.generateDDForEarButton.getSelection());
        preferences.setValue("ejb_generate_dd", this.generateDDForEJBButton.getSelection());
        preferences.setValue("dynamic_web_generate_dd", this.generateDDForWebButton.getSelection());
        preferences.setValue("app_client_generate_dd", this.generateDDForAppClientButton.getSelection());
        preferences.setValue("ejbOutput", this.ejbOutputText.getText());
        preferences.setValue("dynWebSource", this.dynWebSourceText.getText());
        preferences.setValue("dynWebOutput", this.dynWebOutputText.getText());
        preferences.setValue("appClientOutput", this.appClientOutputText.getText());
        preferences.setValue("jcaOutput", this.jcaOutputText.getText());
        preferences.setPersistOnChange(true);
        preferences.persist();
        FacetCorePlugin.getDefault().getPluginPreferences().setValue("defaultSource", this.utilitySourceText.getText());
        FacetCorePlugin.getDefault().getPluginPreferences().setValue("outputFolder", this.utilityOutputText.getText());
        FacetCorePlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        this.initializeValues(true);
        super.performDefaults();
    }

    private void initializeValues(boolean isDefault) {
        J2EEPreferences preferences = J2EEPlugin.getDefault().getJ2EEPreferences();
        if (isDefault) {
            this.addProjectToEarButton.setSelection(preferences.getDefaultBoolean("addToEarByDefault"));
            this.earContentText.setText(preferences.getDefaultString("earContent"));
            this.ejbContentText.setText(preferences.getDefaultString("ejbContent"));
            this.dynWebContentText.setText(preferences.getDefaultString("webContent"));
            this.connectorText.setText(preferences.getDefaultString("jcaContent"));
            this.appClientText.setText(preferences.getDefaultString("appClientContent"));
            this.ejbOutputText.setText(preferences.getDefaultString("ejbOutput"));
            this.dynWebSourceText.setText(preferences.getDefaultString("dynWebSource"));
            this.dynWebOutputText.setText(preferences.getDefaultString("dynWebOutput"));
            this.jcaOutputText.setText(preferences.getDefaultString("jcaContent"));
            this.appClientOutputText.setText(preferences.getDefaultString("appClientOutput"));
            this.utilityOutputText.setText(J2EEPlugin.getDefault().getJ2EEPreferences().getDefaultOutputFolderName());
            this.utilitySourceText.setText(this.getDefaultJavaSrcFolder());
            this.generateDDForEarButton.setSelection(preferences.getDefaultBoolean("application_generate_dd"));
            this.generateDDForEJBButton.setSelection(preferences.getDefaultBoolean("ejb_generate_dd"));
            this.generateDDForWebButton.setSelection(preferences.getDefaultBoolean("dynamic_web_generate_dd"));
            this.generateDDForAppClientButton.setSelection(preferences.getDefaultBoolean("app_client_generate_dd"));
        } else {
            this.initializing = true;
            this.addProjectToEarButton.setSelection(preferences.getBoolean("addToEarByDefault"));
            this.earContentText.setText(preferences.getString("earContent"));
            this.ejbContentText.setText(preferences.getString("ejbContent"));
            this.dynWebContentText.setText(preferences.getString("webContent"));
            this.connectorText.setText(preferences.getString("jcaContent"));
            this.appClientText.setText(preferences.getString("appClientContent"));
            this.utilitySourceText.setText(FacetCorePlugin.getJavaSrcFolder());
            this.ejbOutputText.setText(preferences.getString("ejbOutput"));
            this.dynWebSourceText.setText(preferences.getString("dynWebSource"));
            this.dynWebOutputText.setText(preferences.getString("dynWebOutput"));
            this.jcaOutputText.setText(preferences.getString("jcaOutput"));
            this.appClientOutputText.setText(preferences.getString("appClientOutput"));
            this.utilityOutputText.setText(preferences.getUtilityOutputFolderName());
            this.generateDDForEarButton.setSelection(preferences.getBoolean("application_generate_dd"));
            this.generateDDForEJBButton.setSelection(preferences.getBoolean("ejb_generate_dd"));
            this.generateDDForWebButton.setSelection(preferences.getBoolean("dynamic_web_generate_dd"));
            this.generateDDForAppClientButton.setSelection(preferences.getBoolean("app_client_generate_dd"));
            this.initializing = false;
        }
    }

    public String getDefaultJavaSrcFolder() {
        String srcFolder = FacetCorePlugin.getDefault().getPluginPreferences().getDefaultString("defaultSource");
        if (srcFolder == null || srcFolder.equals("")) {
            if (Platform.getProduct() != null && ((srcFolder = Platform.getProduct().getProperty(PROD_PROP_SOURCE_FOLDER)) == null || srcFolder.equals(""))) {
                srcFolder = Platform.getProduct().getProperty("defaultSource");
            }
            if (srcFolder == null || srcFolder.equals("")) {
                srcFolder = "src";
            }
        }
        return srcFolder;
    }

    public Group getGenerateDeploymentDescGroup() {
        return this.generateDeploymentDescGroup;
    }

    public Group getEarMembershipDescGroup() {
        return this.earMembershipDescGroup;
    }

    public void setEarMembershipDescGroup(Group earMembershipDescGroup) {
        this.earMembershipDescGroup = earMembershipDescGroup;
    }

    public void dispose() {
        this.DESC_COLOR.dispose();
        this.validMap.clear();
        this.validMap = null;
    }

    private void createEARPreferenceSection(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        group.setForeground(this.DESC_COLOR);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(CommonEditResourceHandler.EAR_CONTENT_LABEL);
        Label earLabel = new Label((Composite)group, 0);
        this.setUIAttributesToContentLabel(earLabel);
        this.earContentText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.earContentText);
        this.earContentDecoration = new ControlDecoration((Control)this.earContentText, 16512);
        this.earContentText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                if (!folderName.isEmpty()) {
                    MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolderName(folderName);
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.earContentDecoration);
                    if (msg == null) {
                        msg = J2EEProjectStructurePreferencePage.this.validateFolderForCharacters(folderName);
                        J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.earContentDecoration);
                    }
                } else {
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(null, J2EEProjectStructurePreferencePage.this.earContentDecoration);
                }
            }
        });
    }

    private void createDynWebPreferenceSection(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        group.setForeground(this.DESC_COLOR);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(CommonEditResourceHandler.DYNAMIC_WEB_CONTENT_LABEL);
        Label sourceLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaSourceLabel(sourceLabel);
        this.dynWebSourceText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.dynWebSourceText);
        this.dynWebSourceText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webSrcDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateWebContentAndSourceUnique(folderName, J2EEProjectStructurePreferencePage.this.dynWebContentText.getText());
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webSrcDecoration);
                }
            }
        });
        this.webSrcDecoration = new ControlDecoration((Control)this.dynWebSourceText, 16512);
        Label outputLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaOutputLabel(outputLabel);
        this.dynWebOutputText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.dynWebOutputText);
        this.webOuputDecoration = new ControlDecoration((Control)this.dynWebOutputText, 16512);
        this.dynWebOutputText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webOuputDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateWebConfigAndOutputFolder(J2EEProjectStructurePreferencePage.this.dynWebContentText.getText(), folderName);
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webOuputDecoration);
                }
            }
        });
        Label dynWebLabel = new Label((Composite)group, 0);
        this.setUIAttributesToContentLabel(dynWebLabel);
        this.dynWebContentText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.dynWebContentText);
        this.webContentDecoration = new ControlDecoration((Control)this.dynWebContentText, 16512);
        this.dynWebContentText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webContentDecoration);
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateWebContentAndSourceUnique(J2EEProjectStructurePreferencePage.this.dynWebSourceText.getText(), folderName);
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webContentDecoration);
                }
                if (msg == null) {
                    msg = J2EEProjectStructurePreferencePage.this.validateWebConfigAndOutputFolder(folderName, J2EEProjectStructurePreferencePage.this.dynWebOutputText.getText());
                    J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.webOuputDecoration);
                }
            }
        });
    }

    private void createEJBPreferenceSection(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        group.setForeground(this.DESC_COLOR);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(CommonEditResourceHandler.EJB_CONTENT_LABEL);
        Label sourceLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaSourceLabel(sourceLabel);
        this.ejbContentText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.ejbContentText);
        this.ejbSrcDecoration = new ControlDecoration((Control)this.ejbContentText, 16512);
        this.ejbContentText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.ejbSrcDecoration);
            }
        });
        Label outputLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaOutputLabel(outputLabel);
        this.ejbOutputText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.ejbOutputText);
        this.ejbOuputDecoration = new ControlDecoration((Control)this.ejbOutputText, 16512);
        this.ejbOutputText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.ejbOuputDecoration);
            }
        });
    }

    private void createAppClientPreferenceSection(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        group.setForeground(this.DESC_COLOR);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(CommonEditResourceHandler.APPCLIENT_CONTENT_LABEL);
        Label sourceLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaSourceLabel(sourceLabel);
        this.appClientText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.appClientText);
        this.appClientSrcDecoration = new ControlDecoration((Control)this.appClientText, 16512);
        this.appClientText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.appClientSrcDecoration);
            }
        });
        Label outputLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaOutputLabel(outputLabel);
        this.appClientOutputText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.appClientOutputText);
        this.appClientOuputDecoration = new ControlDecoration((Control)this.appClientOutputText, 16512);
        this.appClientOutputText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.appClientOuputDecoration);
            }
        });
    }

    private void createJCAPreferenceSection(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        group.setForeground(this.DESC_COLOR);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(CommonEditResourceHandler.CONNECTOR_CONTENT_LABEL);
        Label sourceLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaSourceLabel(sourceLabel);
        this.connectorText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.connectorText);
        this.jcaSrcDecoration = new ControlDecoration((Control)this.connectorText, 16512);
        this.connectorText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.jcaSrcDecoration);
            }
        });
        Label outputLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaOutputLabel(outputLabel);
        this.jcaOutputText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.jcaOutputText);
        this.jcaOuputDecoration = new ControlDecoration((Control)this.jcaOutputText, 16512);
        this.jcaOutputText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.jcaOuputDecoration);
            }
        });
    }

    private void createUtilityPreferenceSection(Composite parent) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group group = new Group(parent, 0);
        group.setForeground(this.DESC_COLOR);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(CommonEditResourceHandler.UTILITY_CONTENT_LABEL);
        Label sourceLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaSourceLabel(sourceLabel);
        this.utilitySourceText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.utilitySourceText);
        this.utilitySrcDecoration = new ControlDecoration((Control)this.utilitySourceText, 16512);
        this.utilitySourceText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.utilitySrcDecoration);
            }
        });
        Label outputLabel = new Label((Composite)group, 0);
        this.setUIAttributesToJavaOutputLabel(outputLabel);
        this.utilityOutputText = new Text((Composite)group, 2048);
        this.setUIAttributesToText(this.utilityOutputText);
        this.utilityOuputDecoration = new ControlDecoration((Control)this.utilityOutputText, 16512);
        this.utilityOutputText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String folderName = ((Text)event.widget).getText();
                MessageTuple msg = J2EEProjectStructurePreferencePage.this.validateFolder(folderName);
                J2EEProjectStructurePreferencePage.this.updateHoverStatus(msg, J2EEProjectStructurePreferencePage.this.utilityOuputDecoration);
            }
        });
    }

    private void setUIAttributesToJavaSourceLabel(Label sourceLabel) {
        GridData data = new GridData();
        data.horizontalIndent = 10;
        sourceLabel.setLayoutData((Object)data);
        sourceLabel.setText(CommonEditResourceHandler.JAVA_CONTENT_DESC_LABEL);
    }

    private void setUIAttributesToText(Text text) {
        GridData data = new GridData(768);
        data.horizontalIndent = 10;
        text.setLayoutData((Object)data);
    }

    private void setUIAttributesToJavaOutputLabel(Label outputLabel) {
        GridData data = new GridData();
        data.horizontalIndent = 10;
        outputLabel.setLayoutData((Object)data);
        outputLabel.setText(CommonEditResourceHandler.JAVA_CONTENT_OUTPUT_LABEL);
    }

    private void setUIAttributesToContentLabel(Label label) {
        GridData data = new GridData();
        data.horizontalIndent = 10;
        label.setLayoutData((Object)data);
        label.setText(CommonEditResourceHandler.CONTENT_DIRECTORY__DESC_LABEL);
    }

    protected MessageTuple validateFolder(String folderName) {
        MessageTuple msg = this.validateFolderForEmptyValue(folderName);
        if (msg != null) {
            return msg;
        }
        msg = this.validateFolderName(folderName);
        if (msg != null) {
            return msg;
        }
        msg = this.validateFolderForCharacters(folderName);
        return msg;
    }

    protected MessageTuple validateFolderForEmptyValue(String folderName) {
        MessageTuple msg = null;
        if (folderName == null || folderName.trim().length() == 0) {
            return new MessageTuple(CommonEditResourceHandler.CONTENT_DIRECTORY_EMPTY, 3);
        }
        return msg;
    }

    private MessageTuple validateFolderName(String folderName) {
        MessageTuple msg = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path path = new Path(folderName);
        int i = 0;
        int max = path.segmentCount();
        while (i < max) {
            IStatus status = workspace.validateName(path.segment(i), 2);
            if (!status.isOK()) {
                return new MessageTuple(status.getMessage(), status.getSeverity());
            }
            ++i;
        }
        return msg;
    }

    private MessageTuple validateFolderForCharacters(String folderName) {
        MessageTuple msg = null;
        if (folderName.indexOf(35) != -1) {
            String message = NLS.bind((String)Messages.resources_invalidCharInName, (Object)"#", (Object)folderName);
            return new MessageTuple(message, 3);
        }
        return msg;
    }

    private MessageTuple validateWebContentAndSourceUnique(String srcFolderName, String contentFolderName) {
        MessageTuple msg = null;
        if (contentFolderName.equals(srcFolderName)) {
            return new MessageTuple(CommonEditResourceHandler.DYNAMIC_WEBPROJECT_PREFERENCE_VALIDATION, 3);
        }
        return msg;
    }

    private MessageTuple validateWebConfigAndOutputFolder(String contentFolderName, String outputFolderName) {
        String expectedOutFolder = String.valueOf(contentFolderName) + "/" + "WEB-INF/classes";
        if (!expectedOutFolder.equals(outputFolderName)) {
            return new MessageTuple(ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.DYNAMIC_WEB_PERFORMANCE_VALIDATION, (Object[])new Object[]{expectedOutFolder}), 2);
        }
        return null;
    }

    private void updateHoverStatus(MessageTuple msg, ControlDecoration decoration) {
        if (msg != null) {
            switch (msg.getSeverity()) {
                case 1: {
                    Image newImage = this.registry.getFieldDecoration("DEC_INFORMATION").getImage();
                    decoration.setDescriptionText(msg.getMessage());
                    decoration.setImage(newImage);
                    decoration.show();
                    break;
                }
                case 2: {
                    Image newImage = this.registry.getFieldDecoration("DEC_WARNING").getImage();
                    decoration.setDescriptionText(msg.getMessage());
                    decoration.setImage(newImage);
                    decoration.show();
                    break;
                }
                case 3: 
                case 4: {
                    Image newImage = this.registry.getFieldDecoration("DEC_ERROR").getImage();
                    decoration.setDescriptionText(msg.getMessage());
                    decoration.setImage(newImage);
                    decoration.show();
                    this.validMap.put(decoration, Boolean.FALSE);
                    this.setMessage(CommonEditResourceHandler.SEE_ERROR, 3);
                    this.setValid(false);
                    break;
                }
            }
        } else {
            decoration.setDescriptionText(null);
            decoration.hide();
            if (this.validMap.containsKey(decoration)) {
                this.validMap.remove(decoration);
            }
            for (ControlDecoration control : this.validMap.keySet()) {
                if (this.validMap.get(control).booleanValue()) continue;
                this.setValid(false);
                this.setMessage(CommonEditResourceHandler.SEE_ERROR, 3);
                return;
            }
            this.setMessage(null);
            this.setValid(true);
        }
    }

    private class MessageTuple {
        private String message;
        private int severity;

        public MessageTuple(String message, int severity) {
            this.message = message;
            this.severity = severity;
        }

        public String getMessage() {
            return this.message;
        }

        public int getSeverity() {
            return this.severity;
        }
    }
}

