/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards.dialogs;

import com.ibm.etools.application.client.wizards.AppClientReferenceWizardEditModel;
import com.ibm.etools.common.ui.wizards.IWizardConstants;
import com.ibm.etools.common.ui.wizards.dialogs.SimpleDialog;
import com.ibm.etools.common.ui.wizards.helpers.AppClientWizardEditModel;
import com.ibm.etools.common.ui.wizards.helpers.EJBWizardEditModel;
import com.ibm.etools.common.ui.wizards.helpers.WizardEditModel;
import com.ibm.etools.common.ui.wizards.nls.CommonAppEJBWizardsResourceHandler;
import com.ibm.etools.ejb.ui.providers.BeanContentAdapterFactory;
import com.ibm.etools.ejb.ui.wizards.helpers.EJBReferenceWizardEditModel;
import com.ibm.etools.ejb.ui.wizards.helpers.ObjectHolder;
import com.ibm.etools.ejb.ui.wizards.providers.ProjectContentProvider;
import com.ibm.etools.ejb.ui.wizards.providers.ProjectLabelProvider;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.internal.impl.EjbRefImpl;
import org.eclipse.jst.j2ee.common.internal.provider.CommonItemProviderAdapterFactory;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.application.provider.ApplicationItemProviderAdapterFactory;
import org.eclipse.jst.j2ee.internal.ejb.provider.EjbItemProviderAdapterFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class LinkBrowseDialog
extends SimpleDialog
implements IWizardConstants {
    protected WizardEditModel model = null;
    protected EJBJar ejbJar;
    protected IProject myMainProject;
    protected EnterpriseBean selectedBean = null;
    protected String calculatedLink = null;
    protected IProject referencedProject = null;
    protected IProject earProject = null;
    TreeViewer tree;
    Button sameOne;
    Button diffOne;
    TableViewer tableViewer;
    Color defaultSelectionTrue;
    private Composite differentProjectComposite;
    private Composite sameProjectComposite;
    protected Composite stackComposite;

    public LinkBrowseDialog(Shell parentShell, WizardEditModel model) {
        super(parentShell);
        this.model = model;
    }

    @Override
    protected Control createTopLevelComposite(Composite parent) {
        this.setTitle(CommonAppEJBWizardsResourceHandler.Reference_Link_UI_);
        this.getShell().setText(CommonAppEJBWizardsResourceHandler.Link_Selection_UI_);
        this.loadData();
        Composite main = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.verticalSpacing = 10;
        main.setLayout((Layout)mainLayout);
        main.setLayoutData((Object)new GridData(768));
        Composite comp = new Composite(main, 0);
        GridLayout layout = new GridLayout();
        GridData data = new GridData(768);
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)data);
        if (this.isEJBBound()) {
            this.sameOne = new Button(comp, 16);
            this.sameOne.setText(CommonAppEJBWizardsResourceHandler.Enterprise_bean_in_current_EJB_project_UI_);
            this.sameOne.setLayoutData((Object)new GridData(768));
            this.diffOne = new Button(comp, 16);
            this.diffOne.setText(CommonAppEJBWizardsResourceHandler.Enterprise_bean_in_different_EJB_project_UI_);
            this.diffOne.setLayoutData((Object)new GridData(768));
            this.sameOne.setSelection(true);
        }
        this.createView(comp);
        this.addListeners();
        this.controlView();
        return comp;
    }

    protected void createView(Composite comp) {
        StackLayout layout = new StackLayout();
        this.stackComposite = new Composite(comp, 0);
        this.stackComposite.setLayout((Layout)layout);
        this.stackComposite.setLayoutData((Object)new GridData(768));
        if (this.isEJBBound()) {
            this.createComboPart(this.stackComposite);
        }
        this.createTreePart(this.stackComposite);
        if (this.isEJBBound()) {
            layout.topControl = this.sameProjectComposite;
        } else if (this.isApplicationClientBound()) {
            layout.topControl = this.differentProjectComposite;
        }
        this.stackComposite.layout();
    }

    protected Composite createComboPart(Composite parent) {
        this.sameProjectComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        this.sameProjectComposite.setLayout((Layout)layout);
        layout.verticalSpacing = 0;
        GridData data = new GridData(768);
        this.sameProjectComposite.setLayoutData((Object)data);
        Label space = new Label(this.sameProjectComposite, 16384);
        space.setText("  ");
        space.setLayoutData((Object)new GridData());
        data = new GridData(768);
        data.widthHint = 270;
        data.heightHint = 230;
        this.tableViewer = new TableViewer(this.sameProjectComposite, 2060);
        this.tableViewer.getControl().setLayoutData((Object)data);
        this.tableViewer.setContentProvider((IContentProvider)new BeanContentAdapterFactory(((AdapterFactoryEditingDomain)this.model.getEditingDomain()).getAdapterFactory()));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(((AdapterFactoryEditingDomain)this.model.getEditingDomain()).getAdapterFactory()));
        this.tableViewer.setInput((Object)this.ejbJar);
        Label space2 = new Label(this.sameProjectComposite, 16384);
        space2.setText("  ");
        space2.setLayoutData((Object)new GridData());
        return this.sameProjectComposite;
    }

    protected Composite createTreePart(Composite parent) {
        this.differentProjectComposite = new Composite(parent, 0);
        this.differentProjectComposite.setLayout((Layout)new GridLayout());
        ((GridLayout)this.differentProjectComposite.getLayout()).numColumns = 3;
        ((GridLayout)this.differentProjectComposite.getLayout()).marginHeight = 0;
        this.differentProjectComposite.setLayoutData((Object)new GridData(768));
        Label space = new Label(this.differentProjectComposite, 16384);
        space.setText("  ");
        space.setLayoutData((Object)new GridData());
        EjbItemProviderAdapterFactory ejbFactory = new EjbItemProviderAdapterFactory();
        ApplicationItemProviderAdapterFactory appFactory = new ApplicationItemProviderAdapterFactory();
        CommonItemProviderAdapterFactory commonFactory = new CommonItemProviderAdapterFactory();
        ComposedAdapterFactory combinedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{ejbFactory, appFactory, commonFactory});
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)combinedAdapterFactory, this.model.getArtifactEdit().getCommandStack(), this.model.getArtifactEdit().getContentModelRoot().eResource().getResourceSet());
        ProjectContentProvider contentProvider = new ProjectContentProvider(domain.getAdapterFactory());
        this.tree = new TreeViewer(this.differentProjectComposite, 2048);
        this.tree.setContentProvider((IContentProvider)contentProvider);
        this.tree.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider(domain.getAdapterFactory()));
        ObjectHolder objectHolder = new ObjectHolder(this.model.getArtifactEdit());
        this.tree.setInput((Object)objectHolder);
        GridData data = new GridData(768);
        data.widthHint = 270;
        data.heightHint = this.isApplicationClientBound() ? 270 : 230;
        this.tree.getControl().setLayoutData((Object)data);
        this.defaultSelectionTrue = this.tree.getControl().getBackground();
        Label space2 = new Label(this.differentProjectComposite, 16384);
        space2.setText("  ");
        space2.setLayoutData((Object)new GridData());
        return this.differentProjectComposite;
    }

    @Override
    protected void validateControls() {
        this.setOKStatus();
        if (this.diffOne != null && this.sameOne != null) {
            if (this.diffOne.getSelection()) {
                this.validateTreeControls();
            } else if (this.sameOne.getSelection()) {
                this.validateComboControls();
            }
        } else if (this.tree != null) {
            this.validateTreeControls();
        }
    }

    protected void validateComboControls() {
        if (this.sameOne != null && this.tableViewer != null && this.isEJBBound()) {
            String mySelectionType = this.getEJBModel().getReferenceType();
            Object o = ((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
            String beanName = "";
            if (!(o instanceof EnterpriseBean)) {
                this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Select_an_enterprise_bean_from_the_list_UI_);
                this.setPageComplete(false);
                this.selectedBean = null;
                return;
            }
            beanName = ((EnterpriseBean)o).getName().trim();
            if (!beanName.equals("")) {
                EnterpriseBean bean = this.ejbJar.getEnterpriseBeanNamed(beanName);
                if (mySelectionType.equals("Local") && !bean.hasLocalClient()) {
                    this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Selected_bean_does_not_contain_local_client_view_UI_);
                    this.setPageComplete(false);
                    return;
                }
                if (mySelectionType.equals("Remote") && !bean.hasRemoteClient()) {
                    this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Selected_bean_does_not_contain_remote_client_view_UI_);
                    this.setPageComplete(false);
                    return;
                }
                this.calculatedLink = beanName;
                EnterpriseBean myBean = this.getEJBModel().getEnterpriseBean();
                EList list = myBean.getEjbRefs();
                int i = 0;
                while (i < list.size()) {
                    EjbRefImpl ejb = (EjbRefImpl)list.get(i);
                    if (ejb.getLink() != null && ejb.getLink().equals(this.calculatedLink)) {
                        this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Link_already_exist_UI_);
                        this.setPageComplete(false);
                        return;
                    }
                    ++i;
                }
                this.selectedBean = bean;
            }
        }
    }

    protected void validateTreeControls() {
        String mySelectionType = this.isEJBBound() ? this.getEJBModel().getReferenceType() : "Remote";
        TreeItem[] item = this.tree.getTree().getSelection();
        if (item.length != 0) {
            if (item[0].getData() instanceof EnterpriseBean) {
                EnterpriseBean bean = (EnterpriseBean)item[0].getData();
                if (mySelectionType.equals("Local") && !bean.hasLocalClient()) {
                    this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Selected_bean_does_not_contain_local_client_view_UI_);
                    this.setPageComplete(false);
                    return;
                }
                if (mySelectionType.equals("Remote") && !bean.hasRemoteClient()) {
                    this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Selected_bean_does_not_contain_remote_client_view_UI_);
                    this.setPageComplete(false);
                    return;
                }
                Module module = (Module)item[0].getParentItem().getData();
                Project project = (Project)item[0].getParentItem().getParentItem().getData();
                if (((EjbModule)module).getApplication().getFirstModule(this.myMainProject.getName()) == null) {
                    this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Bean_is_not_the_same_EAR_Project_UI_);
                    this.setPageComplete(false);
                    this.selectedBean = null;
                    return;
                }
                this.computeLink(bean, module, (IProject)project);
                EList list = null;
                if (this.isEJBBound()) {
                    list = this.getEJBModel().getReferenceType().equals("Local") ? this.getEJBModel().getEnterpriseBean().getEjbLocalRefs() : this.getEJBModel().getEnterpriseBean().getEjbRefs();
                } else if (this.isApplicationClientBound()) {
                    list = this.getAppClientModel().getApplicationClient().getEjbReferences();
                }
                if (list != null) {
                    int i = 0;
                    while (i < list.size()) {
                        EjbRef ejb = (EjbRef)list.get(i);
                        if (ejb.getLink() != null && ejb.getLink().equals(this.calculatedLink)) {
                            this.setWarnStatus(CommonAppEJBWizardsResourceHandler.Link_already_exist_UI_);
                            this.setPageComplete(true);
                        }
                        ++i;
                    }
                    this.selectedBean = bean;
                }
            } else {
                this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Select_an_enterprise_bean_from_the_list_UI_);
                this.setPageComplete(false);
                this.selectedBean = null;
            }
        } else {
            this.setErrorStatus(CommonAppEJBWizardsResourceHandler.Select_an_enterprise_bean_from_the_list_UI_);
            this.setPageComplete(false);
            this.selectedBean = null;
        }
    }

    protected void computeLink(EnterpriseBean bean, Module module, IProject project) {
        this.earProject = project;
        this.referencedProject = null;
        this.calculatedLink = this.referencedProject.equals((Object)this.myMainProject) ? bean.getName() : (this.isEJBBound() && bean.getEjbJar().getVersionID() == 11 || this.isApplicationClientBound() && this.getAppClientModel().getApplicationClient().getVersionID() == 12 ? bean.getName() : this.computeLinkForEARRelativeBean(bean, module, project));
    }

    protected String computeLinkForEARRelativeBean(EnterpriseBean bean, Module module, IProject project) {
        return null;
    }

    protected void addListeners() {
        if (this.sameOne != null) {
            this.sameOne.addListener(13, (Listener)this);
        }
        if (this.diffOne != null) {
            this.diffOne.addListener(13, (Listener)this);
        }
        if (this.tree != null) {
            this.tree.getTree().addListener(13, (Listener)this);
        }
        if (this.tableViewer != null) {
            this.tableViewer.getControl().addListener(13, (Listener)this);
        }
    }

    private void controlView() {
        if (this.sameOne != null && this.diffOne != null) {
            StackLayout layout = (StackLayout)this.stackComposite.getLayout();
            if (this.sameOne.getSelection()) {
                layout.topControl = this.sameProjectComposite;
            } else if (this.diffOne.getSelection()) {
                layout.topControl = this.differentProjectComposite;
            }
            this.stackComposite.layout();
        }
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.diffOne || event.widget == this.sameOne) {
            this.controlView();
        }
        super.handleEvent(event);
    }

    protected void okPressed() {
        if (this.isEJBBound()) {
            this.getEJBModel().setSelectedEnterpriseBean(this.selectedBean);
            this.getEJBModel().setCalculatedLink(this.calculatedLink);
            this.getEJBModel().setReferencedProject(this.referencedProject);
            this.getEJBModel().setEarProject(this.earProject);
        } else if (this.isApplicationClientBound()) {
            this.getAppClientModel().setSelectedEnterpriseBean(this.selectedBean);
            this.getAppClientModel().setCalculatedLink(this.calculatedLink);
            this.getAppClientModel().setReferencedProject(this.referencedProject);
            this.getAppClientModel().setEarProject(this.earProject);
        }
        super.okPressed();
    }

    public WizardEditModel getModel() {
        return this.model;
    }

    protected void loadData() {
        if (this.isEJBBound()) {
            this.myMainProject = ProjectUtilities.getProject((EObject)this.getEJBModel().getEnterpriseBean());
            this.ejbJar = this.getEJBModel().getEnterpriseBean().getEjbJar();
        } else if (this.isApplicationClientBound()) {
            this.myMainProject = ProjectUtilities.getProject((EObject)this.getAppClientModel().getApplicationClient());
        }
    }

    protected boolean isApplicationClientBound() {
        return this.model instanceof AppClientWizardEditModel;
    }

    protected boolean isEJBBound() {
        return this.model instanceof EJBWizardEditModel;
    }

    protected EJBReferenceWizardEditModel getEJBModel() {
        return (EJBReferenceWizardEditModel)this.model;
    }

    protected AppClientReferenceWizardEditModel getAppClientModel() {
        return (AppClientReferenceWizardEditModel)this.model;
    }
}

