/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards;

import com.ibm.etools.common.ui.wizards.GenericCommandWizard;
import com.ibm.etools.common.ui.wizards.nls.CommonAppEJBWizardsResourceHandler;
import com.ibm.etools.ejb.ui.wizards.helpers.SecurityIdentityWizardEditModel;
import com.ibm.etools.j2ee.common.wizard.J2EEWizardPage;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SecurityIdentityOptionsWizardPage
extends J2EEWizardPage {
    private static final Integer PAGE_OK = new Integer(4);
    Text siDescValue;
    Text roleDescValue;
    Button callerRadio;
    Button serverRadio;
    Button roleRadio;
    Combo roleCombo;
    Composite roleComposite;
    SecurityIdentityWizardEditModel model;

    protected SecurityIdentityOptionsWizardPage(String pageName) {
        super(pageName);
        this.setTitle(CommonAppEJBWizardsResourceHandler.Security_Identity_UI_);
        this.setDescription(CommonAppEJBWizardsResourceHandler.Select_type_of_security_identity_UI_);
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("security_identity_wiz"));
    }

    protected SecurityIdentityOptionsWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    @Override
    protected Composite createTopLevelComposite(Composite parent) {
        this.loadData();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.j2ee.ui.secm1000");
        this.createRunAsMode(composite);
        this.createDescriptionBox(composite);
        return composite;
    }

    protected void createDescriptionBox(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label desc = new Label(composite, 0);
        desc.setText(CommonAppEJBWizardsResourceHandler.Security_identity_description__UI_);
        desc.setLayoutData((Object)new GridData(2));
        this.siDescValue = new Text(composite, 2626);
        GridData data = new GridData(768);
        data.heightHint = 60;
        this.siDescValue.setLayoutData((Object)data);
    }

    protected void createRunAsMode(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Group group = new Group(composite, 0);
        group.setText(CommonAppEJBWizardsResourceHandler.Run_as_mode__UI_);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.callerRadio = new Button((Composite)group, 16);
        this.callerRadio.setLayoutData((Object)this.indentedGridData(10));
        this.callerRadio.setText(CommonAppEJBWizardsResourceHandler.Use_identity_of_caller_UI_);
        if (!this.model.isSecurityIdentity_2_0()) {
            this.serverRadio = new Button((Composite)group, 16);
            this.serverRadio.setLayoutData((Object)this.indentedGridData(10));
            this.serverRadio.setText(CommonAppEJBWizardsResourceHandler.Use_identity_of_EJB_server_UI_);
        }
        this.roleRadio = new Button((Composite)group, 16);
        this.roleRadio.setLayoutData((Object)this.indentedGridData(10));
        this.roleRadio.setText(CommonAppEJBWizardsResourceHandler.Use_identity_assigned_to_specific_role_below_UI_);
        this.createRoleGroup((Composite)group);
    }

    protected void createRoleGroup(Composite parent) {
        this.roleComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.roleComposite.setLayout((Layout)layout);
        this.roleComposite.setLayoutData((Object)this.indentedGridData(25));
        Label role = new Label(this.roleComposite, 0);
        role.setText(CommonAppEJBWizardsResourceHandler.Role_name__UI_);
        this.roleCombo = new Combo(this.roleComposite, 2060);
        this.roleCombo.setLayoutData((Object)this.indentedGridData(0));
        this.roleCombo.setItems(this.getSecurityRoles());
        Label desc = new Label(this.roleComposite, 0);
        desc.setText(CommonAppEJBWizardsResourceHandler.Role_description__UI_);
        desc.setLayoutData((Object)new GridData(2));
        this.roleDescValue = new Text(this.roleComposite, 2626);
        GridData data = new GridData(768);
        data.heightHint = 60;
        this.roleDescValue.setLayoutData((Object)data);
    }

    @Override
    protected void addListeners() {
        this.callerRadio.addListener(13, (Listener)this);
        this.roleRadio.addListener(13, (Listener)this);
        if (!this.model.isSecurityIdentity_2_0()) {
            this.serverRadio.addListener(13, (Listener)this);
        }
        this.roleCombo.addListener(13, (Listener)this);
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.callerRadio) {
            this.roleComposite.setEnabled(false);
            this.roleCombo.setEnabled(false);
            this.roleDescValue.setEnabled(false);
            this.model.setSelectionType(1);
        } else if (event.widget == this.serverRadio) {
            this.roleComposite.setEnabled(false);
            this.roleCombo.setEnabled(false);
            this.roleDescValue.setEnabled(false);
            this.model.setSelectionType(2);
        } else if (event.widget == this.roleRadio) {
            this.roleComposite.setEnabled(true);
            this.roleCombo.setEnabled(true);
            this.roleDescValue.setEnabled(true);
            this.model.setSelectionType(3);
        }
        super.handleEvent(event);
    }

    public IWizardPage getNextPage() {
        this.model.setRoleName(this.roleCombo.getText().trim());
        this.model.setRoleRDescription(this.roleDescValue.getText().trim());
        this.model.setSecurityIdentityDescription(this.siDescValue.getText().trim());
        return super.getNextPage();
    }

    protected GridData indentedGridData(int m) {
        GridData data = new GridData(768);
        data.horizontalIndent = m;
        return data;
    }

    protected String[] getSecurityRoles() {
        AssemblyDescriptor assembly;
        EJBJar jar;
        String[] rolenames = null;
        if (this.model != null && (jar = this.model.getEJBJar()) != null && (assembly = jar.getAssemblyDescriptor()) != null) {
            EList roles = assembly.getSecurityRoles();
            rolenames = new String[roles.size()];
            int i = 0;
            while (i < roles.size()) {
                rolenames[i] = ((SecurityRole)roles.get(i)).getRoleName();
                ++i;
            }
        }
        if (rolenames == null) {
            rolenames = new String[]{};
        }
        return rolenames;
    }

    @Override
    protected void validateControls() {
        this.setOKStatus(PAGE_OK);
        if (this.roleRadio.getSelection() && this.roleCombo.getText().equals("")) {
            this.setErrorStatus(PAGE_OK, CommonAppEJBWizardsResourceHandler.Role_name_cannot_be_empty_UI_);
        }
    }

    protected void loadData() {
        GenericCommandWizard wizard;
        if (this.getWizard() instanceof GenericCommandWizard && (wizard = (GenericCommandWizard)this.getWizard()).getWizardEditModel() instanceof SecurityIdentityWizardEditModel) {
            this.model = (SecurityIdentityWizardEditModel)wizard.getWizardEditModel();
        }
    }
}

