/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards;

import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import com.ibm.etools.ejb.ui.wizards.WizardClassesImportMainPage;
import com.ibm.etools.ejb.ui.wizards.WizardClassesImportPage1;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ClassesImportWizard
extends Wizard
implements IImportWizard {
    public WizardClassesImportMainPage mainPage = null;
    public WizardClassesImportPage1 page1 = null;
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private IPath importedClassesPath;
    private IJavaProject javaProject = null;
    private IProject project = null;
    protected ArrayList fileNames = null;

    public ClassesImportWizard(IProject project) {
        this.project = project;
        this.setWindowTitle(EJBUIResourceHandler.Import_Class_Files_UI);
    }

    public ClassesImportWizard(IProject project, String fileName, List otherFileNames) {
        this(project);
        this.fileNames = new ArrayList();
        this.fileNames.add(fileName);
        int i = fileName.lastIndexOf(File.separatorChar);
        String parentDir = fileName.substring(0, i);
        if (otherFileNames != null) {
            int j = otherFileNames.size() - 1;
            while (j >= 0) {
                int k;
                if (otherFileNames.get(j) != null && (k = ((String)otherFileNames.get(j)).lastIndexOf(File.separatorChar)) == i && parentDir.equals(((String)otherFileNames.get(j)).substring(0, k))) {
                    this.fileNames.add(otherFileNames.remove(j));
                }
                --j;
            }
        }
    }

    public void setFolderPath(IPath path) {
        this.importedClassesPath = path;
    }

    public boolean performFinish() {
        return this.page1.finish();
    }

    public void createImportedClassesFolder(IProject project) {
        IProject container = project;
        IFolder folder = container.getFolder((IPath)new Path("imported_classes"));
        this.javaProject = this.getIJavaProject(project);
        IPath importedFoldersClass = folder.getFullPath();
        CPListElement entry = this.newCPLibraryElement((IResource)folder);
        IClasspathEntry newEntry = entry.getClasspathEntry();
        IResource res = entry.getResource();
        if (res instanceof IFolder && !res.exists()) {
            try {
                CoreUtility.createFolder((IFolder)((IFolder)res), (boolean)true, (boolean)true, null);
            }
            catch (CoreException coreException) {}
        }
        try {
            IClasspathEntry[] classpathEntries = this.javaProject.getRawClasspath();
            IClasspathEntry[] newClasspath = new IClasspathEntry[classpathEntries.length + 1];
            int i = 0;
            while (i < classpathEntries.length) {
                newClasspath[i] = classpathEntries[i];
                ++i;
            }
            newClasspath[classpathEntries.length] = newEntry;
            this.javaProject.setRawClasspath(newClasspath, null);
        }
        catch (JavaModelException javaModelException) {}
        this.setFolderPath(importedFoldersClass);
    }

    private IJavaProject getIJavaProject(IProject projectHandle) {
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        return javaModel.getJavaProject(projectHandle.getName());
    }

    private CPListElement newCPLibraryElement(IResource res) {
        return new CPListElement(this.javaProject, 1, res.getFullPath(), res);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        if (this.project == null && !selection.isEmpty() && selection.getFirstElement() instanceof IProject) {
            this.project = (IProject)selection.getFirstElement();
        }
        if (this.project != null) {
            this.createImportedClassesFolder(this.project);
        }
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardClassesImportMainPage("id", this.fileNames);
        this.page1 = new WizardClassesImportPage1(this.workbench, this.selection, this.importedClassesPath, this.fileNames);
        this.page1.setWizard((IWizard)this);
        if (this.fileNames == null || this.fileNames.size() == 0) {
            this.addPage((IWizardPage)this.mainPage);
        }
        this.addPage((IWizardPage)this.page1);
    }
}

