/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.jst.j2ee.ejb.internal.util.MethodElementHelper;

public class MethodPermissionTableRowObject {
    protected EnterpriseBean enterpriseBean;
    public List methodElements;

    public MethodPermissionTableRowObject(EnterpriseBean anEJB) {
        this.setEnterpriseBean(anEJB);
    }

    public MethodPermissionTableRowObject(List someMethodElements) {
        this.setMethodElements(someMethodElements);
    }

    public void addMethodElement(MethodElement anElement) {
        if (anElement != null) {
            this.getMethodElements().add(anElement);
        }
    }

    public AssemblyDescriptor getAssemblyDescriptor() {
        MethodElement me = this.getFirstMethodElement();
        if (me == null) {
            return null;
        }
        MethodPermission mp = MethodElementHelper.getMethodPermission((MethodElement)me);
        if (mp == null) {
            return null;
        }
        return mp.getAssemblyDescriptor();
    }

    public String[] getAvailableMethodElementSignatures() {
        MethodElement element = this.getFirstMethodElement();
        if (element == null) {
            return new String[0];
        }
        List resultList = null;
        List homeSigs = this.getEnterpriseBean().getHomeInterface().getMethodElementSignatures();
        List remoteSigs = this.getEnterpriseBean().getRemoteInterface().getMethodElementSignatures();
        switch (element.getType().getValue()) {
            case 0: {
                resultList = homeSigs;
            }
            case 1: {
                resultList = remoteSigs;
            }
            case 2: {
                remoteSigs.remove(0);
                resultList = homeSigs;
                resultList.addAll(remoteSigs);
            }
        }
        if (resultList != null) {
            return this.toStringArray(resultList);
        }
        return new String[0];
    }

    protected EEnumLiteral getDefaultType() {
        return EjbFactoryImpl.getPackage().getMethodElementKind().getEEnumLiteral(2);
    }

    protected int getDefaultTypeIndex() {
        return this.getDefaultType().getValue();
    }

    protected String getDefaultTypeString() {
        return this.getDefaultType().toString();
    }

    public EnterpriseBean getEnterpriseBean() {
        if (this.enterpriseBean == null && this.getFirstMethodElement() != null) {
            this.enterpriseBean = this.getFirstMethodElement().getEnterpriseBean();
        }
        return this.enterpriseBean;
    }

    public MethodElement getFirstMethodElement() {
        if (this.getMethodElements().isEmpty()) {
            return null;
        }
        return (MethodElement)this.getMethodElements().get(0);
    }

    public MethodElement getMethodElementFromRoleName(String roleName) {
        List elements = this.getMethodElements();
        int size = elements.size();
        int i = 0;
        while (i < size) {
            MethodElement me = (MethodElement)elements.get(i);
            MethodPermission mp = MethodElementHelper.getMethodPermission((MethodElement)me);
            if (mp != null && mp.hasSecurityRole(roleName)) {
                return me;
            }
            ++i;
        }
        return null;
    }

    public List getMethodElements() {
        if (this.methodElements == null) {
            this.methodElements = new ArrayList();
        }
        return this.methodElements;
    }

    public String getMethodElementSignature() {
        MethodElement element = this.getFirstMethodElement();
        if (element == null) {
            return "";
        }
        return element.getSignature();
    }

    public String getMethodElementType() {
        MethodElement element = this.getFirstMethodElement();
        if (element == null) {
            return this.getDefaultTypeString();
        }
        return element.getType().getName();
    }

    public Integer getMethodElementTypeIndex() {
        MethodElement element = this.getFirstMethodElement();
        if (element == null) {
            return new Integer(this.getDefaultTypeIndex());
        }
        return new Integer(element.getType().getValue());
    }

    public boolean hasSecurityRole(String roleName) {
        if (this.getFirstMethodElement() == null || roleName == null) {
            return false;
        }
        return this.primHasSecurityRole(roleName);
    }

    protected boolean primHasSecurityRole(String roleName) {
        List elements = this.getMethodElements();
        int size = elements.size();
        int i = 0;
        while (i < size) {
            MethodElement me = (MethodElement)elements.get(i);
            MethodPermission mp = MethodElementHelper.getMethodPermission((MethodElement)me);
            if (mp != null && mp.hasSecurityRole(roleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeMethodElement(MethodElement anElement) {
        return this.getMethodElements().remove(anElement);
    }

    public void setEnterpriseBean(EnterpriseBean newEnterpriseBean) {
        this.enterpriseBean = newEnterpriseBean;
    }

    void setMethodElements(List newMethodElements) {
        this.methodElements = newMethodElements;
    }

    private String[] toStringArray(List aList) {
        String[] result = new String[aList.size()];
        aList.toArray(result);
        return result;
    }
}

