/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.operations;

import com.ibm.etools.ejb.ui.operations.AbstractEjbCombineOperation;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;

public class EjbCombineContainerTransactionOperation
extends AbstractEjbCombineOperation {
    static final int SUPPORTED = 0;
    static final int NOT_SUPPORTED = 1;
    static final int REQUIRED = 2;
    static final int NOT_REQUIRED = 3;
    static final int MANDATORY = 4;

    public EjbCombineContainerTransactionOperation(EJBArtifactEdit artifactEdit) {
        super(artifactEdit);
    }

    @Override
    protected void extendedExecution() {
        AssemblyDescriptor descript = this.getJar().getAssemblyDescriptor();
        this.seperateMethodTransactions(descript.getMethodTransactions());
    }

    private void seperateMethodTransactions(EList transactionList) {
        ArrayList<MethodTransaction> notSupportedList = new ArrayList<MethodTransaction>();
        ArrayList<MethodTransaction> supportedList = new ArrayList<MethodTransaction>();
        ArrayList<MethodTransaction> requiresList = new ArrayList<MethodTransaction>();
        ArrayList<MethodTransaction> notRequiresList = new ArrayList<MethodTransaction>();
        ArrayList<MethodTransaction> mandatoryList = new ArrayList<MethodTransaction>();
        int x = 0;
        while (x < transactionList.size()) {
            MethodTransaction transaction = (MethodTransaction)transactionList.get(x);
            int tranNum = transaction.getTransactionAttribute().getValue();
            switch (tranNum) {
                case 1: {
                    notSupportedList.add(transaction);
                    break;
                }
                case 0: {
                    supportedList.add(transaction);
                    break;
                }
                case 2: {
                    requiresList.add(transaction);
                    break;
                }
                case 3: {
                    notRequiresList.add(transaction);
                    break;
                }
                case 4: {
                    mandatoryList.add(transaction);
                }
            }
            ++x;
        }
        if (!notSupportedList.isEmpty()) {
            this.combineTransActionIntoOne(notSupportedList);
        }
        if (!supportedList.isEmpty()) {
            this.combineTransActionIntoOne(supportedList);
        }
        if (!requiresList.isEmpty()) {
            this.combineTransActionIntoOne(requiresList);
        }
        if (!notRequiresList.isEmpty()) {
            this.combineTransActionIntoOne(notRequiresList);
        }
        if (!mandatoryList.isEmpty()) {
            this.combineTransActionIntoOne(mandatoryList);
        }
    }

    private void combineTransActionIntoOne(ArrayList transList) {
        this.meList = new ArrayList();
        this.throwAwayList = new ArrayList();
        MethodTransaction transaction = null;
        MethodTransaction target_tran = null;
        if (transList.isEmpty()) {
            return;
        }
        target_tran = (MethodTransaction)transList.get(0);
        transList.remove(0);
        int i = 0;
        while (i < transList.size()) {
            transaction = (MethodTransaction)transList.get(i);
            this.meList.addAll(transaction.getMethodElements());
            this.throwAwayList.add(transaction);
            ++i;
        }
        target_tran.getMethodElements().addAll((Collection)this.meList);
        this.getJar().getAssemblyDescriptor().getMethodTransactions().removeAll((Collection)this.throwAwayList);
    }
}

