/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.ejb.codegen.EJBGenHelpers;
import com.ibm.etools.ejb.ui.wizards.helpers.CreateFinderMethodCommand;
import com.ibm.etools.ejb.ui.wizards.helpers.EJBFindersWizardEditModel;
import com.ibm.etools.ejb.ui.wizards.helpers.EditFinderSigCommand;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Query;
import org.eclipse.jst.j2ee.ejb.QueryMethod;
import org.eclipse.jst.j2ee.ejb.ReturnTypeMapping;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.jst.j2ee.ejb.internal.util.EjbAdapterFactory;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModelModifier;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class CreateOrUpdateEJBQueryOperation
extends WTPOperation {
    private EJBFindersWizardEditModel model;
    private EJBArtifactEdit artifactEdit;
    private Object validateContext;
    private EditingDomain domain;
    private boolean isEditing = false;
    private String statement;
    private String description;

    public CreateOrUpdateEJBQueryOperation(EJBFindersWizardEditModel aModel, IProject anEJBProject, Object aShell) {
        this.model = aModel;
        this.validateContext = aShell;
    }

    protected void preExecute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.artifactEdit = (EJBArtifactEdit)this.model.getArtifactEdit();
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (this.artifactEdit == null) {
            return;
        }
        try {
            if (this.validateEditCheck()) {
                this.createFinder();
            }
            this.artifactEdit.saveIfNecessary(monitor);
        }
        finally {
            this.artifactEdit.dispose();
        }
    }

    private void createFinder() {
        List helpers = null;
        helpers = this.createQueryModifierHelpers();
        if (helpers.isEmpty()) {
            return;
        }
        ModelModifier modelModifier = new ModelModifier(this.getDomain());
        int i = 0;
        while (i < helpers.size()) {
            modelModifier.addHelper((ModifierHelper)helpers.get(i));
            ++i;
        }
        AbstractCommand codeGen = null;
        if (this.model.shouldCodeGen()) {
            codeGen = this.isEditing ? new EditFinderSigCommand(this.model) : new CreateFinderMethodCommand(this.model);
        }
        if (codeGen != null) {
            if (this.model.getArtifactEdit() == null) {
                this.model.setArtifactEdit((ArtifactEdit)this.artifactEdit);
            }
            modelModifier.addAdditionalCommand((Command)codeGen);
        }
        modelModifier.execute();
    }

    private List createQueryModifierHelpers() {
        ArrayList<ModifierHelper> helpers = new ArrayList<ModifierHelper>();
        ModifierHelper helper = null;
        if (this.model.getQuery() != null) {
            helper = this.createStatementHelper();
            if (helper != null) {
                helpers.add(helper);
            }
            if ((helper = this.createDescriptionHelper()) != null) {
                helpers.add(helper);
            }
            if ((helper = this.createMethodElementNameHelper()) != null) {
                helpers.add(helper);
            }
            if ((helper = this.createMethodElementParmsHelper()) != null) {
                helpers.add(helper);
            }
        } else if (!this.model.isEditing() && (helper = this.createQueryHelper()) != null) {
            helpers.add(helper);
        }
        return helpers;
    }

    private ModifierHelper createQueryHelper() {
        ModifierHelper helper = new ModifierHelper();
        helper.setOwner((EObject)this.model.getEnterpriseBean());
        helper.setFeature((EStructuralFeature)EjbFactoryImpl.getPackage().getContainerManagedEntity_Queries());
        Query query = EjbFactoryImpl.getActiveFactory().createQuery();
        query.setEjbQL(this.statement);
        query.setDescription(this.description);
        if (this.model.isEjbSelectMethod() && this.model.isReturnTypeRemote()) {
            query.setReturnTypeMapping(ReturnTypeMapping.REMOTE_LITERAL);
        }
        if (this.model.getMethodElement() instanceof QueryMethod) {
            query.setQueryMethod((QueryMethod)this.model.getMethodElement());
        }
        helper.setValue((Object)query);
        return helper;
    }

    private ModifierHelper createMethodElementParmsHelper() {
        List parameters = this.model.getParameterList();
        if (parameters == null) {
            return null;
        }
        String editedParams = "";
        String holder = "";
        int i = 0;
        while (i < parameters.size()) {
            holder = parameters.get(i).toString();
            int location = holder.indexOf(32);
            editedParams = String.valueOf(editedParams) + holder.substring(0, location);
            editedParams = String.valueOf(editedParams) + " ";
            ++i;
        }
        ModifierHelper methodParmHelper = new ModifierHelper();
        methodParmHelper.setOwner((EObject)this.model.getQuery().getQueryMethod());
        methodParmHelper.setFeature((EStructuralFeature)EjbFactoryImpl.getPackage().getMethodElement_Parms());
        methodParmHelper.setValue((Object)editedParams);
        return methodParmHelper;
    }

    private ModifierHelper createMethodElementNameHelper() {
        ModifierHelper methodNameHelper = new ModifierHelper();
        methodNameHelper.setOwner((EObject)this.model.getQuery().getQueryMethod());
        methodNameHelper.setFeature((EStructuralFeature)EjbFactoryImpl.getPackage().getMethodElement_Name());
        methodNameHelper.setValue((Object)this.model.getMethodName());
        return methodNameHelper;
    }

    private ModifierHelper createDescriptionHelper() {
        ModifierHelper desHelper = new ModifierHelper();
        desHelper.setOwner((EObject)this.model.getQuery());
        desHelper.setFeature((EStructuralFeature)EjbFactoryImpl.getPackage().getQuery_Description());
        String value = this.description == null ? "" : this.description;
        desHelper.setValue((Object)value);
        return desHelper;
    }

    private ModifierHelper createStatementHelper() {
        ModifierHelper helper = new ModifierHelper();
        helper.setOwner((EObject)this.model.getQuery());
        helper.setFeature((EStructuralFeature)EjbFactoryImpl.getPackage().getQuery_EjbQL());
        String value = this.statement == null ? "" : this.statement;
        helper.setValue((Object)value);
        return helper;
    }

    private boolean validateEditCheck() {
        EnterpriseBean myBean = this.model.getEnterpriseBean();
        if (myBean != null) {
            if (this.model.isEjbSelectMethod()) {
                return this.validateEditCheck(new JavaClass[]{myBean.getEjbClass()});
            }
            if (this.model.isFinderMethod()) {
                return this.validateEditCheck(new JavaClass[]{myBean.getHomeInterface()});
            }
            if (this.model.isLocal()) {
                return this.validateEditCheck(new JavaClass[]{myBean.getLocalHomeInterface()});
            }
            if (this.model.isRemote()) {
                return this.validateEditCheck(new JavaClass[]{myBean.getRemoteInterface()});
            }
        }
        return true;
    }

    private boolean validateEditCheck(JavaClass[] javaClasses) {
        IFile[] files = this.getReadOnlyFiles(javaClasses);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(files, this.validateContext);
        return status.isOK();
    }

    private IFile[] getReadOnlyFiles(JavaClass[] javaClasses) {
        ArrayList<IResource> files = new ArrayList<IResource>(javaClasses.length);
        int i = 0;
        while (i < javaClasses.length) {
            IResource res;
            ICompilationUnit cu = EJBGenHelpers.getCompilationUnit((JavaClass)javaClasses[i]);
            if (cu != null && (res = cu.getResource()) != null && res.exists() && res.getType() == 1 && res.isReadOnly()) {
                files.add(res);
            }
            ++i;
        }
        IFile[] result = new IFile[files.size()];
        files.toArray(result);
        return result;
    }

    public void setDescription(String description) {
        this.description = description != null ? description.trim() : description;
    }

    public void setStatement(String statement) {
        this.statement = statement != null ? statement.trim() : statement;
    }

    public EditingDomain getDomain() {
        if (this.domain == null) {
            this.domain = new AdapterFactoryEditingDomain((AdapterFactory)new EjbAdapterFactory(), this.artifactEdit.getCommandStack());
        }
        return this.domain;
    }

    public void setDomain(EditingDomain domain) {
        this.domain = domain;
    }

    public void setIsEditing(boolean isEditing) {
        this.isEditing = isEditing;
    }
}

