/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.java;

import com.ibm.etools.ejb.ui.java.EJBJavaModelManager;
import com.ibm.etools.ejb.ui.java.ImageOverlayIcon;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jem.internal.adapters.jdom.JDOMAdaptor;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class EJBJavaMethodDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    protected static final String PROMOTED_HOME_CREATE_METHOD_NAME = "create";
    protected static final String POSSIBLE_HOME_CREATE_PROMOTE_NAME = "ejbCreate";
    protected static final String POSSIBLE_HOME_PROMOTE_NAME = "ejbHome";
    protected static final String PROMOTED_HOME_FIND_METHOD_NAME = "find";
    protected static final String POSSIBLE_HOME_FIND_PROMOTE_NAME = "ejbFind";
    protected static final String HOME_KEY_EXT = "h";
    protected static final String LOCAL_HOME_KEY_EXT = "lh";
    protected static final String HOME_LOCAL_HOME_KEY_EXT = "hlh";
    protected static final String REMOTE_KEY_EXT = "r";
    protected static final String LOCAL_KEY_EXT = "l";
    protected static final String REMOTE_LOCAL_KEY_EXT = "rl";
    protected static final String HOME_IMAGE_DESC_STRING = "home_interface_positioned_overlay";
    protected static final String REMOTE_IMAGE_DESC_STRING = "remote_interface_positioned_overlay";
    protected static final String LOCAL_HOME_IMAGE_DESC_STRING = "local_home_interface_positioned_overlay";
    protected static final String LOCAL_IMAGE_DESC_STRING = "local_interface_positioned_overlay";
    protected static final String SERVICE_IMAGE_DESC_STRING = "service_interface_positioned_overlay";
    protected Hashtable registry = new Hashtable();
    protected EnterpriseBean currentEjb;
    protected EJBJavaModelManager manager = new EJBJavaModelManager(this);
    protected ICompilationUnit currentCU;
    private static final ImageDescriptor HOME_IMG_DESC = EJBJavaMethodDecorator.getImageDescriptor("home_interface_positioned_overlay");
    private static final ImageDescriptor LOCAL_HOME_IMG_DESC = EJBJavaMethodDecorator.getImageDescriptor("local_home_interface_positioned_overlay");
    private static final ImageDescriptor REMOTE_IMG_DESC = EJBJavaMethodDecorator.getImageDescriptor("remote_interface_positioned_overlay");
    private static final ImageDescriptor LOCAL_IMG_DESC = EJBJavaMethodDecorator.getImageDescriptor("local_interface_positioned_overlay");
    private static final ImageDescriptor SERVICE_IMG_DESC = EJBJavaMethodDecorator.getImageDescriptor("service_interface_positioned_overlay");

    public Image decorateImage(Image image, Object element) {
        return this.decorateImage(image, (IMethod)element);
    }

    public Image decorateImage(Image image, IMethod method) {
        this.initializeEJBIfNecessary(method);
        if (this.currentEjb != null) {
            image = this.findImage(image, method);
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void dispose() {
        this.disposeRegistry();
        this.manager.dispose();
        this.currentEjb = null;
        this.currentCU = null;
        super.dispose();
    }

    protected void disposeRegistry() {
        Enumeration anEnum = this.registry.elements();
        while (anEnum.hasMoreElements()) {
            Image image = (Image)anEnum.nextElement();
            if (image.isDisposed()) continue;
            image.dispose();
        }
        this.registry.clear();
    }

    protected void initializeEJBIfNecessary(IMethod method) {
        if (method != null) {
            ICompilationUnit cu = method.getCompilationUnit();
            if (cu != null && !cu.equals(this.currentCU)) {
                this.setCurrentCU(cu);
                this.setCurrentEjb(this.manager.getEnterperiseBeanForBeanClass(this.currentCU));
            } else if (this.currentEjb == null || this.currentEjb.eIsProxy()) {
                this.setCurrentEjb(this.manager.getEnterperiseBeanForBeanClass(this.currentCU));
            }
        }
    }

    protected String getPromotedMethodName(String aMethodName, JavaClass aJavaClass) {
        if (this.currentEjb.getHomeInterface() == aJavaClass || this.currentEjb.getLocalHomeInterface() == aJavaClass) {
            if (aMethodName.equals(POSSIBLE_HOME_CREATE_PROMOTE_NAME)) {
                return PROMOTED_HOME_CREATE_METHOD_NAME;
            }
            if (this.currentEjb.getVersionID() >= 20 && aMethodName.startsWith(POSSIBLE_HOME_CREATE_PROMOTE_NAME)) {
                return PROMOTED_HOME_CREATE_METHOD_NAME + aMethodName.substring(POSSIBLE_HOME_CREATE_PROMOTE_NAME.length());
            }
            if (aMethodName.startsWith(POSSIBLE_HOME_FIND_PROMOTE_NAME)) {
                return PROMOTED_HOME_FIND_METHOD_NAME + aMethodName.substring(POSSIBLE_HOME_FIND_PROMOTE_NAME.length());
            }
            if (aMethodName.startsWith(POSSIBLE_HOME_PROMOTE_NAME)) {
                return this.setFirstAsLowercase(aMethodName.substring(POSSIBLE_HOME_PROMOTE_NAME.length()));
            }
        }
        return aMethodName;
    }

    protected String setFirstAsLowercase(String aString) {
        if (aString == null || aString.length() == 0) {
            return aString;
        }
        char[] chars = aString.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    protected boolean isAlreadyPromoted(IMethod aMethod, JavaClass anInterface) {
        if (aMethod != null && anInterface != null) {
            Method javaMethod = null;
            String methodName = this.getPromotedMethodName(aMethod.getElementName(), anInterface);
            if (methodName != null) {
                javaMethod = anInterface.getMethodExtended(methodName, this.getParameterTypes(aMethod));
            }
            if (javaMethod != null) {
                return true;
            }
        }
        return false;
    }

    protected Image findImage(Image srcImage, IMethod method) {
        boolean promotedHome = this.isAlreadyPromoted(method, this.currentEjb.getHomeInterface());
        boolean promotedLocalHome = this.isAlreadyPromoted(method, this.currentEjb.getLocalHomeInterface());
        if (promotedHome || promotedLocalHome) {
            return this.findHomeImage(srcImage, promotedHome, promotedLocalHome);
        }
        boolean promotedRemote = this.isAlreadyPromoted(method, this.currentEjb.getRemoteInterface());
        boolean promotedLocal = this.isAlreadyPromoted(method, this.currentEjb.getLocalInterface());
        if (promotedRemote || promotedLocal) {
            return this.findClientImage(srcImage, promotedRemote, promotedLocal);
        }
        return srcImage;
    }

    protected String getImageKey(Image image, String extension) {
        if (extension != null) {
            return String.valueOf(image.hashCode()) + extension;
        }
        return null;
    }

    protected static ImageDescriptor getImageDescriptor(String imageFileName) {
        if (imageFileName != null) {
            return J2EEUIPlugin.getDefault().getImageDescriptor(imageFileName);
        }
        return null;
    }

    protected Image getCachedImage(String key) {
        return (Image)this.registry.get(key);
    }

    protected Image findHomeImage(Image srcImage, boolean isHome, boolean isLocalHome) {
        String keyExt = this.getHomeKeyExtension(isHome, isLocalHome);
        String key = this.getImageKey(srcImage, keyExt);
        Image image = this.getCachedImage(key);
        if (image == null) {
            image = this.createNewOverlay(srcImage, this.getHomeImageDescriptorKey(isHome, isLocalHome), key);
        }
        return image;
    }

    protected Image findClientImage(Image srcImage, boolean isRemote, boolean isLocal) {
        String keyExt = this.getClientKeyExtension(isRemote, isLocal);
        String key = this.getImageKey(srcImage, keyExt);
        Image image = this.getCachedImage(key);
        if (image == null) {
            image = this.createNewOverlay(srcImage, this.getClientImageDescriptorKey(isRemote, isLocal), key);
        }
        return image;
    }

    protected String getHomeKeyExtension(boolean isHome, boolean isLocalHome) {
        String keyExt = LOCAL_HOME_KEY_EXT;
        if (isHome) {
            keyExt = isLocalHome ? HOME_LOCAL_HOME_KEY_EXT : HOME_KEY_EXT;
        }
        return keyExt;
    }

    protected String[] getHomeImageDescriptorKey(boolean isHome, boolean isLocalHome) {
        String[] overlayDesc = new String[2];
        overlayDesc[0] = LOCAL_HOME_IMAGE_DESC_STRING;
        if (isHome) {
            if (isLocalHome) {
                overlayDesc[0] = HOME_IMAGE_DESC_STRING;
                overlayDesc[1] = LOCAL_HOME_IMAGE_DESC_STRING;
            } else {
                overlayDesc[0] = HOME_IMAGE_DESC_STRING;
            }
        }
        return overlayDesc;
    }

    protected String getClientKeyExtension(boolean isRemote, boolean isLocal) {
        String keyExt = LOCAL_KEY_EXT;
        if (isRemote) {
            keyExt = isLocal ? REMOTE_LOCAL_KEY_EXT : REMOTE_KEY_EXT;
        }
        return keyExt;
    }

    protected String[] getClientImageDescriptorKey(boolean isRemote, boolean isLocal) {
        String[] overlayDesc = new String[2];
        overlayDesc[0] = LOCAL_IMAGE_DESC_STRING;
        if (isRemote) {
            if (isLocal) {
                overlayDesc[0] = REMOTE_IMAGE_DESC_STRING;
                overlayDesc[1] = LOCAL_IMAGE_DESC_STRING;
            } else {
                overlayDesc[0] = REMOTE_IMAGE_DESC_STRING;
            }
        }
        return overlayDesc;
    }

    protected Image createNewOverlay(Image srcImage, String[] overlyDescNames, String imageKey) {
        ImageDescriptor desc1 = EJBJavaMethodDecorator.getImageDescriptor(overlyDescNames[0]);
        ImageDescriptor desc2 = EJBJavaMethodDecorator.getImageDescriptor(overlyDescNames[1]);
        ImageDescriptor[] overlays = null;
        if (desc1 != null) {
            overlays = desc2 != null ? new ImageDescriptor[]{desc1, desc2} : new ImageDescriptor[]{desc1};
        } else if (desc2 != null) {
            overlays = new ImageDescriptor[]{desc2};
        }
        ImageOverlayIcon overDesc = new ImageOverlayIcon(srcImage, overlays);
        Image image = overDesc.createImage();
        this.registry.put(imageKey, image);
        return image;
    }

    protected List getParameterTypes(IMethod aMethod) {
        String[] typeNames = aMethod.getParameterTypes();
        IType type = aMethod.getDeclaringType();
        String typeName = null;
        ArrayList<String> types = new ArrayList<String>(typeNames.length);
        int i = 0;
        while (i < typeNames.length) {
            typeName = JDOMAdaptor.convertJDOMtypeName((String)typeNames[i]);
            typeName = JDOMAdaptor.getResolvedTypeName((String)typeName, (IType)type);
            types.add(typeName);
            ++i;
        }
        return types;
    }

    protected void postLabelEvents(final LabelProviderChangedEvent[] events) {
        if (events.length > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < events.length) {
                        EJBJavaMethodDecorator.this.fireLabelProviderChanged(events[i]);
                        ++i;
                    }
                }
            });
        }
    }

    public ICompilationUnit getCurrentCU() {
        return this.currentCU;
    }

    public void setCurrentCU(ICompilationUnit currentCU) {
        this.currentCU = currentCU;
    }

    public EnterpriseBean getCurrentEjb() {
        return this.currentEjb;
    }

    public void setCurrentEjb(EnterpriseBean currentEjb) {
        this.currentEjb = currentEjb;
    }

    public void decorate(Object element, IDecoration decoration) {
        IMethod method = null;
        if (!(element instanceof IMethod)) {
            return;
        }
        method = (IMethod)element;
        this.initializeEJBIfNecessary(method);
        if (this.currentEjb != null) {
            ImageDescriptor[] desc = this.getImageDescriptor(method);
            int i = 0;
            while (i < desc.length) {
                if (desc[i] != null) {
                    decoration.addOverlay(desc[i], i);
                }
                ++i;
            }
        }
    }

    protected ImageDescriptor[] getImageDescriptor(IMethod method) {
        boolean promotedService;
        ImageDescriptor[] result = new ImageDescriptor[4];
        boolean promotedHome = this.isAlreadyPromoted(method, this.currentEjb.getHomeInterface());
        boolean promotedLocalHome = this.isAlreadyPromoted(method, this.currentEjb.getLocalHomeInterface());
        if (promotedHome) {
            result[2] = HOME_IMG_DESC;
        }
        if (promotedLocalHome) {
            result[0] = LOCAL_HOME_IMG_DESC;
        }
        if (promotedHome || promotedLocalHome) {
            return result;
        }
        boolean promotedRemote = this.isAlreadyPromoted(method, this.currentEjb.getRemoteInterface());
        boolean promotedLocal = this.isAlreadyPromoted(method, this.currentEjb.getLocalInterface());
        boolean bl = promotedService = this.currentEjb instanceof Session ? this.isAlreadyPromoted(method, ((Session)this.currentEjb).getServiceEndpoint()) : false;
        if (promotedLocal) {
            result[0] = LOCAL_IMG_DESC;
        }
        if (promotedRemote) {
            result[2] = REMOTE_IMG_DESC;
        }
        if (promotedService) {
            result[3] = SERVICE_IMG_DESC;
        }
        return result;
    }
}

