/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.java;

import com.ibm.etools.ejb.ui.java.EJBJavaMethodDecorator;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class EJBJavaAdapter
extends AdapterImpl
implements IPartListener {
    public static final String TYPE_KEY = "EJBJavaMethods";
    protected EJBJavaMethodDecorator decorator;
    protected ICompilationUnit compilationUnit;
    protected EnterpriseBean ejb;
    protected IWorkbenchPart javaEditorPart;
    protected List interfaceTargets = new ArrayList(4);

    public EJBJavaAdapter(EJBJavaMethodDecorator aDecorator, ICompilationUnit cu, EnterpriseBean anEJB, IWorkbenchPart aJavaEditor) {
        this.decorator = aDecorator;
        this.compilationUnit = cu;
        this.ejb = anEJB;
        this.javaEditorPart = aJavaEditor;
        this.setupInterfaceListeners();
    }

    public boolean isAdapterForType(Object type) {
        return TYPE_KEY.equals(type);
    }

    public void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == JavaReflectionAdaptor.FLUSH_REFLECTION_EVENT || feature == JavaReflectionAdaptor.FLUSH_NEW_REFLECTION_EVENT) {
            if (!this.isValidEjb()) {
                this.dispose();
            } else {
                this.updatePublicMethodLabels();
            }
        }
    }

    protected boolean isValidEjb() {
        if (this.ejb != null) {
            return this.ejb.eContainer() != null && !this.ejb.eIsProxy();
        }
        return false;
    }

    protected void updatePublicMethodLabels() {
        try {
            IType[] types = this.compilationUnit.getTypes();
            ArrayList<LabelProviderChangedEvent> events = new ArrayList<LabelProviderChangedEvent>();
            int i = 0;
            while (i < types.length) {
                IMethod[] methods = types[i].getMethods();
                IMethod method = null;
                int ii = 0;
                while (ii < methods.length) {
                    method = methods[ii];
                    if (Flags.isPublic((int)method.getFlags())) {
                        events.add(new LabelProviderChangedEvent((IBaseLabelProvider)this.decorator, (Object)method));
                    }
                    ++ii;
                }
                ++i;
            }
            this.decorator.postLabelEvents(events.toArray(new LabelProviderChangedEvent[events.size()]));
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void resetInterfaceListeners() {
        if (this.interfaceTargets == null) {
            return;
        }
        int size = this.interfaceTargets.size();
        JavaClass javaClass = null;
        int i = 0;
        while (i < size) {
            javaClass = (JavaClass)this.interfaceTargets.get(i);
            this.removeInterfaceListener(javaClass);
            ++i;
        }
    }

    protected void setupInterfaceListeners() {
        if (this.ejb != null) {
            this.addInterfaceListener(this.ejb.getHomeInterface());
            this.addInterfaceListener(this.ejb.getRemoteInterface());
            this.addInterfaceListener(this.ejb.getLocalHomeInterface());
            this.addInterfaceListener(this.ejb.getLocalInterface());
        }
    }

    protected void removeInterfaceListener(JavaClass javaClass) {
        if (javaClass != null) {
            javaClass.eAdapters().remove((Object)this);
        }
    }

    protected void addInterfaceListener(JavaClass javaClass) {
        if (javaClass != null) {
            this.interfaceTargets.add(javaClass);
            javaClass.eAdapters().add((Object)this);
        }
    }

    public void dispose() {
        this.resetInterfaceListeners();
        this.compilationUnit = null;
        if (this.ejb != null) {
            this.ejb.eAdapters().remove((Object)this);
            this.ejb = null;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = EJBJavaAdapter.this.getActivePage();
                if (page != null) {
                    page.removePartListener((IPartListener)EJBJavaAdapter.this);
                }
                EJBJavaAdapter.this.javaEditorPart = null;
                EJBJavaAdapter.this.interfaceTargets = null;
            }
        });
    }

    protected IWorkbenchPage getActivePage() {
        if (J2EEUIPlugin.getActiveWorkbenchWindow() != null) {
            return J2EEUIPlugin.getActiveWorkbenchWindow().getActivePage();
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        if (!this.isValidEjb()) {
            this.dispose();
        } else if (part == this.javaEditorPart) {
            this.decorator.setCurrentCU(this.compilationUnit);
            this.decorator.setCurrentEjb(this.ejb);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.javaEditorPart) {
            this.dispose();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

