/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.insertions.wizards;

import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import com.ibm.etools.j2ee.reference.snippets.MethodBasedReferenceSnippetDataModel;
import com.ibm.etools.j2ee.reference.snippets.ReferenceSnippetsPlugin;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class EJBReferenceSelectionModel
extends MethodBasedReferenceSnippetDataModel {
    public static final String SHOW_CREATES = "EJBReferenceSelectionModel.showCreates";
    public static final String SHOW_FINDERS = "EJBReferenceSelectionModel.showFinders";
    public static final String USE_HOME = "EJBReferenceSelectionModel.useHome";
    private static final String FIND = "find";
    private static final String CREATE = "create";

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(SHOW_CREATES);
        this.addValidBaseProperty(SHOW_FINDERS);
        this.addValidBaseProperty(USE_HOME);
    }

    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(USE_HOME)) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean notify = super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals(SHOW_CREATES) || propertyName.equals(SHOW_FINDERS)) {
            this.resetFilteredMethods();
        }
        return notify;
    }

    protected String getMissingReferenceMessage() {
        return EJBUIResourceHandler.EJB_REF_REQ;
    }

    protected String getMissingOwnerMessage() {
        return EJBUIResourceHandler.EJBREF_OWNER_REQ;
    }

    protected String getInvalidOwnerMessage() {
        return EJBUIResourceHandler.EJBREF_OWNER_REQ;
    }

    protected List initializeFilteredMethods() {
        JavaClass javaClass = this.getInterface();
        if (javaClass != null) {
            if (this.getBooleanProperty(USE_HOME)) {
                return this.getFilteredHomeMethods(javaClass);
            }
            return javaClass.getMethodsExtended();
        }
        return null;
    }

    public JavaClass getInterfaceOrClass() {
        return this.getInterface();
    }

    public JavaClass getInterface() {
        EjbRef selectedRef = (EjbRef)this.getProperty("J2EEReferenceSnippetDataModel.selectedReference");
        if (selectedRef != null) {
            String className = this.getBooleanProperty(USE_HOME) ? selectedRef.getHome() : selectedRef.getRemote();
            JavaClass result = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(className, this.getResourceSet());
            if (result != null) {
                result.setKind(TypeKind.INTERFACE_LITERAL);
            }
            return result;
        }
        return null;
    }

    private ResourceSet getResourceSet() {
        IProject project = (IProject)this.getProperty("J2EEReferenceSnippetDataModel.project");
        return WorkbenchResourceHelper.getResourceSet((IProject)project);
    }

    protected List getFilteredHomeMethods(JavaClass home) {
        ArrayList<Method> someMethods = null;
        if (home != null) {
            boolean showCreates = this.getBooleanProperty(SHOW_CREATES);
            boolean showFinders = this.getBooleanProperty(SHOW_FINDERS);
            List methods = home.getMethodsExtended();
            if (showCreates && showFinders) {
                return methods;
            }
            someMethods = new ArrayList<Method>(methods.size());
            int i = 0;
            while (i < methods.size()) {
                Method method = (Method)methods.get(i);
                if (showCreates && method.getName().startsWith(CREATE)) {
                    someMethods.add(method);
                } else if (showFinders && method.getName().startsWith(FIND)) {
                    someMethods.add(method);
                }
                ++i;
            }
            return someMethods;
        }
        return null;
    }

    public boolean requiresContextProperties() {
        EjbRef ref = (EjbRef)this.getProperty("J2EEReferenceSnippetDataModel.selectedReference");
        return ref != null && !ref.isLocal() && (ref.getLink() == null || ref.getLink().length() == 0);
    }

    public IStatus validateSelectedReference() {
        IStatus status = super.validateSelectedReference();
        if (status.isOK()) {
            IJobManager manager = Job.getJobManager();
            Job[] jobs = manager.find((Object)"EAR Libraries Update Job");
            if (jobs.length > 0) {
                try {
                    int i = 0;
                    while (i < jobs.length) {
                        if (jobs[i].getName().equals("EAR Libraries Update Job")) {
                            jobs[i].join();
                        }
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    J2EEUIPlugin.logError(e);
                }
            }
            if (this.getAvailableMethods().isEmpty()) {
                if (this.getBooleanProperty(SHOW_CREATES)) {
                    status = new Status(4, "com.ibm.etools.j2ee.reference.snippets", 0, ReferenceSnippetsPlugin.getResourceString((String)"2_UI_"), null);
                } else if (this.getBooleanProperty(SHOW_FINDERS)) {
                    status = new Status(4, "com.ibm.etools.j2ee.reference.snippets", 0, ReferenceSnippetsPlugin.getResourceString((String)"14_UI"), null);
                }
            }
        }
        return status;
    }
}

