/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.insertions;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.ejb.ui.insertions.AddServiceLocatorManagerJAROperation;
import com.ibm.etools.ejb.ui.insertions.wizards.EJBReferenceSelectionModel;
import com.ibm.etools.j2ee.J2EEProjectUtilities;
import com.ibm.etools.j2ee.reference.EJBReferenceCreationOperation;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class UpdateEJBSnippetJARDependenciesOperation
extends WTPOperation {
    private IProject earProject;

    public UpdateEJBSnippetJARDependenciesOperation(EJBReferenceSelectionModel operationDataModel) {
        super((WTPOperationDataModel)operationDataModel);
    }

    public UpdateEJBSnippetJARDependenciesOperation() {
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IProject selectedProject = (IProject)this.operationDataModel.getProperty("J2EEReferenceSnippetDataModel.project");
        if (selectedProject != null) {
            this.addServiceLocatorManagerJAR(selectedProject, monitor);
            this.addEJBProjectDependency(selectedProject, monitor);
        }
    }

    private void addEJBProjectDependency(IProject selectedProject, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        EjbRef ejbRef = (EjbRef)this.operationDataModel.getProperty("J2EEReferenceSnippetDataModel.selectedReference");
        if (ejbRef == null || ejbRef.getLink() == null) {
            return;
        }
        this.doAddEJBProjectDependency(ejbRef, selectedProject, monitor);
    }

    private void doAddEJBProjectDependency(EjbRef ejbRef, IProject selectedProject, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        EnterpriseBean ejb = this.getLinkedEJB(ejbRef, selectedProject);
        if (ejb != null) {
            IProject ejbProject = org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities.getProject((EObject)ejb);
            IVirtualComponent targetEJBComponent = null;
            if (ejbProject != null) {
                targetEJBComponent = ComponentCore.createComponent((IProject)ejbProject);
            } else {
                EJBJar ejbJar = ejb.getEjbJar();
                IProject[] earProjects = org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities.getReferencingEARProjects((IProject)selectedProject);
                if (earProjects.length > 0) {
                    IProject earProject = earProjects[0];
                    IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
                    IVirtualReference[] earRefs = earComponent.getReferences();
                    int i = 0;
                    while (i < earRefs.length && targetEJBComponent == null) {
                        IVirtualComponent comp = earRefs[i].getReferencedComponent();
                        if (comp.isBinary() && J2EEProjectUtilities.isEJBComponent((IVirtualComponent)comp)) {
                            EJBArtifactEdit edit = null;
                            try {
                                edit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)comp);
                                if (ejbJar == edit.getEJBJar()) {
                                    targetEJBComponent = comp;
                                }
                            }
                            finally {
                                if (edit != null) {
                                    edit.dispose();
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
            if (targetEJBComponent != null) {
                EJBReferenceCreationOperation.updateJARDependencyIfNecessary((IProject)selectedProject, (IVirtualComponent)targetEJBComponent);
            }
        }
    }

    private EnterpriseBean getLinkedEJB(EjbRef ejbRef, IProject project) {
        EnterpriseBean ejb;
        block12: {
            ejb = null;
            this.earProject = org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities.getReferencingEARProjects((IProject)project)[0];
            if (this.earProject != null && JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)this.earProject).equals("5.0")) {
                return null;
            }
            if (this.earProject != null) {
                EARFile earFile = null;
                EARArtifactEdit edit = null;
                try {
                    try {
                        edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
                        earFile = (EARFile)edit.asArchive(true);
                        if (earFile == null) break block12;
                        try {
                            String moduleURI = this.earProject.getName();
                            ejb = earFile.getEnterpiseBeanFromRef(ejbRef, moduleURI);
                        }
                        finally {
                            earFile.close();
                            earFile = null;
                        }
                    }
                    catch (OpenFailureException ex) {
                        J2EEUIPlugin.logError(ex);
                        if (edit != null) {
                            edit.dispose();
                        }
                    }
                }
                finally {
                    if (edit != null) {
                        edit.dispose();
                    }
                }
            }
        }
        return ejb;
    }

    private void addServiceLocatorManagerJAR(IProject project, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        AddServiceLocatorManagerJAROperation op = new AddServiceLocatorManagerJAROperation(project);
        op.run(monitor);
    }
}

