/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.insertions;

import com.ibm.etools.ejb.codegen.EJBGenHelpers;
import com.ibm.etools.ejb.ui.insertions.UpdateEJBSnippetJARDependenciesOperation;
import com.ibm.etools.ejb.ui.insertions.wizards.EJBReferenceSelectionModel;
import com.ibm.etools.j2ee.internal.java.insertion.JavaInsertionHelper;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;

public abstract class EJBReferenceJavaHelperInitializer {
    private static final String A_PREFIX = "a";
    private static final String AN_PREFIX = "an";
    protected static String REF_NAME_FIELD_TEMPLATE = "private final static String STATIC_{0}_REF_NAME = \"{1}\";\n";
    protected static String REF_HOME_CLASS_FIELD_TEMPLATE = "private final static Class STATIC_{0}_CLASS = {0}.class;\n";
    protected static String PROV_URL_FIELD_TEMPLATE = "private final static String STATIC_{0}_PROV_URL = \"{1}\";\n";
    protected static String SERV_TYPE_FIELD_TEMPLATE = "private final static String STATIC_{0}_SERV_TYPE = \"{1}\";\n";
    protected static String LOOKUP_LOCAL_TEMPLATE = "{0} {1} = ({0}) ServiceLocatorManager.getLocalHome(STATIC_{0}_REF_NAME, STATIC_{0}_CLASS);\n";
    protected static String LOOKUP_REMOTE_TEMPLATE = "{0} {1} = ({0}) ServiceLocatorManager.getRemoteHome(STATIC_{0}_REF_NAME, STATIC_{0}_CLASS);\n";
    protected static String LOOKUP_REMOTE_WITH_PROPS_TEMPLATE = "{0} {1} = ({0}) ServiceLocatorManager.getRemoteHome(STATIC_{0}_REF_NAME, STATIC_{0}_CLASS, STATIC_{0}_PROV_URL, STATIC_{0}_SERV_TYPE);\n";
    protected static String TRY = "try {\n";
    protected static String CATCH_REMOTE = " catch (RemoteException re) {\n// TODO Auto-generated catch block\nre.printStackTrace();\n}";
    protected EJBReferenceSelectionModel model;
    protected JavaInsertionHelper helper;
    protected static String RETURN_NULL = "return null;\n}";

    public EJBReferenceJavaHelperInitializer(EJBReferenceSelectionModel model, JavaInsertionHelper helper) {
        this.model = model;
        this.helper = helper;
    }

    public JavaInsertionHelper initializeHelper() {
        EjbRef ref;
        if (this.helper == null) {
            this.helper = new JavaInsertionHelper();
        }
        if ((ref = (EjbRef)this.model.getProperty("J2EEReferenceSnippetDataModel.selectedReference")) != null) {
            String home = ref.getHome();
            home = Signature.getSimpleName((String)home);
            this.helper.setInsertionString(this.createInsertionString(home, ref.isLocal()));
            this.initializeHelperMethods(home);
            this.initializeHelperFields(home);
            this.initializeHelperImports(ref.isLocal());
            this.initializeExtendedOperations();
        }
        return this.helper;
    }

    private void initializeExtendedOperations() {
        UpdateEJBSnippetJARDependenciesOperation op = new UpdateEJBSnippetJARDependenciesOperation(this.model);
        this.helper.addExtendedOperation((IHeadlessRunnableWithProgress)op);
    }

    protected void initializeHelperFields(String home) {
        EjbRef ref = (EjbRef)this.model.getProperty("J2EEReferenceSnippetDataModel.selectedReference");
        this.helper.addFieldFromSourceString(this.formatString(REF_NAME_FIELD_TEMPLATE, new String[]{home, ref.getName()}));
        this.helper.addFieldFromSourceString(this.formatString(REF_HOME_CLASS_FIELD_TEMPLATE, new String[]{home}));
        if (this.model.hasContextProperties()) {
            this.helper.addFieldFromSourceString(this.formatString(PROV_URL_FIELD_TEMPLATE, new String[]{home, this.model.getStringProperty("J2EEReferenceSnippetDataModel.providerURL")}));
            this.helper.addFieldFromSourceString(this.formatString(SERV_TYPE_FIELD_TEMPLATE, new String[]{home, this.model.getStringProperty("J2EEReferenceSnippetDataModel.nameServiceType")}));
        }
    }

    protected void initializeHelperMethods(String home) {
    }

    protected void initializeHelperImports(boolean isLocal) {
        EjbRef ref;
        this.helper.addImport("com.ibm.etools.service.locator.ServiceLocatorManager");
        if (!isLocal) {
            this.helper.addImport("java.rmi.RemoteException");
        }
        if ((ref = (EjbRef)this.model.getProperty("J2EEReferenceSnippetDataModel.selectedReference")) != null) {
            this.helper.addImport(ref.getHome());
            this.helper.addImport(ref.getRemote());
        }
    }

    protected abstract String createInsertionString(String var1, boolean var2);

    protected void addServiceLocatorHomeLookup(StringBuffer b, String homeName, boolean isLocal) {
        String insertTemplate = isLocal ? LOOKUP_LOCAL_TEMPLATE : (this.model.hasContextProperties() ? LOOKUP_REMOTE_WITH_PROPS_TEMPLATE : LOOKUP_REMOTE_TEMPLATE);
        b.append(this.formatString(insertTemplate, new String[]{homeName, this.createParameterName(homeName)}));
    }

    protected void appendParameterValues(StringBuffer b) {
        Method method = (Method)this.model.getProperty("MethodBasedReferenceSnippetDataModel.selectedMethod");
        if (method == null) {
            return;
        }
        EList parms = method.getParameters();
        if (!parms.isEmpty()) {
            Iterator it = parms.iterator();
            while (it.hasNext()) {
                JavaParameter parm = (JavaParameter)it.next();
                b.append(this.model.getParamValue(parm));
                if (!it.hasNext()) continue;
                b.append(", ");
            }
        }
    }

    protected String createParameterName(String aClassName) {
        if (aClassName != null && aClassName.length() > 0) {
            if (EJBGenHelpers.isVowel((char)aClassName.charAt(0))) {
                return AN_PREFIX + aClassName;
            }
            return A_PREFIX + aClassName;
        }
        return aClassName;
    }

    protected String formatString(String pattern, String[] arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    protected String getSelectedMethodParametersString() {
        Method method = (Method)this.model.getProperty("MethodBasedReferenceSnippetDataModel.selectedMethod");
        EList parms = method.getParameters();
        if (parms.isEmpty()) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        Iterator it = parms.iterator();
        JavaHelpers type = null;
        while (it.hasNext()) {
            JavaParameter parm = (JavaParameter)it.next();
            type = parm.getJavaType();
            b.append(type.getName()).append(" ");
            if (!type.isPrimitive()) {
                this.helper.addImport(type.getQualifiedName());
            }
            b.append(parm.getName());
            if (!it.hasNext()) continue;
            b.append(", ");
        }
        return b.toString();
    }

    protected void appendParameterNames(StringBuffer b) {
        Method method = (Method)this.model.getProperty("MethodBasedReferenceSnippetDataModel.selectedMethod");
        EList parms = method.getParameters();
        if (parms.isEmpty()) {
            return;
        }
        Iterator it = parms.iterator();
        while (it.hasNext()) {
            JavaParameter parm = (JavaParameter)it.next();
            b.append(parm.getName());
            if (!it.hasNext()) continue;
            b.append(", ");
        }
    }
}

