/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.insertions;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.UpdateManifestOperation;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;

public class AddServiceLocatorManagerJAROperation
extends WTPOperation {
    public static final String SERVICE_LOCATOR_JAR_NAME = "serviceLocatorMgr.jar";
    private static IPath MGR_PATH = new Path("runtime/serviceLocatorMgr.jar");
    private IProject project;

    public AddServiceLocatorManagerJAROperation(IProject aProject) {
        this.project = aProject;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IProject[] ears;
        IJavaProject javaProject;
        IType type;
        if (!(this.project == null || (type = (javaProject = JemProjectUtilities.getJavaProject((IProject)this.project)).findType("com.ibm.etools.service.locator.ServiceLocatorManager")) != null && type.exists() || (ears = this.computeEARComponentHandles()) == null || ears.length <= 0)) {
            int i = 0;
            while (i < ears.length) {
                this.copyServiceLocatorMgrToEar(ears[i]);
                ++i;
            }
            this.addJARDependencyIfNecessary(this.project, monitor);
        }
    }

    private void addJARDependencyIfNecessary(IProject referencing, IProgressMonitor monitor) {
        UpdateManifestOperation operation = new UpdateManifestOperation(this.project.getName(), SERVICE_LOCATOR_JAR_NAME, false);
        try {
            operation.run(monitor);
        }
        catch (InvocationTargetException ex) {
            J2EEUIPlugin.logError(ex);
        }
        catch (InterruptedException e) {
            J2EEUIPlugin.logError(e);
        }
    }

    private IFile copyServiceLocatorMgrToEar(IProject earProject) {
        EARArtifactEdit edit = null;
        IFile file = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForWrite((IProject)earProject);
            IContainer container = edit.getComponent().getRootFolder().getUnderlyingFolder();
            file = container.getFile((IPath)new Path(SERVICE_LOCATOR_JAR_NAME));
            if (!file.exists()) {
                try {
                    InputStream io = J2EEUIPlugin.getDefault().openStream(MGR_PATH);
                    file.create(io, true, null);
                }
                catch (IOException e) {
                    J2EEUIPlugin.logError(e);
                }
                catch (CoreException e) {
                    J2EEUIPlugin.logError(e);
                }
            }
        }
        finally {
            if (edit != null) {
                edit.save(null);
                edit.dispose();
            }
        }
        return file;
    }

    private IProject[] computeEARComponentHandles() {
        return J2EEProjectUtilities.getReferencingEARProjects((IProject)this.project);
    }
}

