/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.gef.widgets;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.ejb.ui.gef.widgets.EJBGefSyncHelper;
import com.ibm.etools.ejb.ui.gef.widgets.RelationshipGEFWidgetFactory;
import com.ibm.etools.ejb.ui.wizards.RelationshipCanvasWTP;
import org.eclipse.gef.internal.ui.palette.editparts.ToolEntryEditPart;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class RelatationshipGEFSyncHelper
extends EJBGefSyncHelper {
    private Composite graphicViewer;

    public RelatationshipGEFSyncHelper(WTPOperationDataModel model) {
        super(model);
    }

    @Override
    protected Object getEntryObjects(SelectionChangedEvent event) {
        ContainerManagedEntity cmp = null;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object viewerPart = selection.getFirstElement();
        if (viewerPart instanceof ToolEntryEditPart) {
            ToolEntryEditPart part = (ToolEntryEditPart)viewerPart;
            if (part.getModel() instanceof SelectionToolEntry) {
                SelectionToolEntry entry = (SelectionToolEntry)part.getModel();
                String beanName = entry.getLabel();
                EJBJar jar = (EJBJar)this.getDataModel().getProperty("EJBRelationshipDataModel.EJB_JAR");
                cmp = (ContainerManagedEntity)jar.getEnterpriseBeanNamed(beanName);
            } else {
                return null;
            }
        }
        return cmp;
    }

    @Override
    protected void handlePaletteSelection(PaletteViewer viewer, Object paletteItem, String propertyName, Composite comp) {
        String cmpName = null;
        if (paletteItem instanceof ContainerManagedEntity) {
            ContainerManagedEntity cmp = (ContainerManagedEntity)paletteItem;
            cmpName = cmp.getName();
            viewer.getControl().setToolTipText(cmp.getEjbClassName());
            this.handleCMPChildren(cmpName, viewer, propertyName);
        } else if (propertyName != "EJBRelationshipDataModel.BEAN_A_NAVIGABILITY" && propertyName != "EJBRelationshipDataModel.BEAN_B_NAVIGABILITY") {
            return;
        }
    }

    protected void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
        if (propertyName == "EJBRelationshipDataModel.BEAN_A_NAVIGABILITY" || propertyName == "EJBRelationshipDataModel.BEAN_B_NAVIGABILITY") {
            this.handleNavigationChildren(this.graphicViewer, propertyName, (Boolean)value);
        }
    }

    protected void setWidgetValue(String propertyName, int flag, Button button) {
        super.setWidgetValue(propertyName, flag, button);
        if (propertyName == "EJBRelationshipDataModel.BEAN_A_NAVIGABILITY" || propertyName == "EJBRelationshipDataModel.BEAN_B_NAVIGABILITY") {
            boolean checked = this.dataModel.getBooleanProperty(propertyName);
            this.handleNavigationChildren(this.graphicViewer, propertyName, checked);
        }
    }

    private void handleNavigationChildren(Composite comp, String propertyName, boolean objValue) {
        int value;
        RelationshipCanvasWTP canvas = (RelationshipCanvasWTP)comp;
        int source = propertyName == "EJBRelationshipDataModel.BEAN_A_NAVIGABILITY" ? 0 : 1;
        if (objValue) {
            value = 1;
            switch (source) {
                case 0: {
                    canvas.getRoleAName().setVisible(true);
                    if (this.getDataModel().getProperty("EJBRelationshipDataModel.BEAN_A") != null) {
                        canvas.getRoleAName().setText(this.getDataModel().getStringProperty("EJBRelationshipDataModel.BEAN_A_ROLE_NAME"));
                    }
                    canvas.getRoleNameLabelA().setVisible(true);
                    break;
                }
                case 1: {
                    canvas.getRoleBName().setVisible(true);
                    if (this.getDataModel().getProperty("EJBRelationshipDataModel.BEAN_B") != null) {
                        canvas.getRoleBName().setText(this.getDataModel().getStringProperty("EJBRelationshipDataModel.BEAN_B_ROLE_NAME"));
                    }
                    canvas.getRoleNameLabelB().setVisible(true);
                    break;
                }
            }
        } else {
            value = 0;
            switch (source) {
                case 0: {
                    canvas.getRoleAName().setVisible(false);
                    canvas.getRoleAName().setText(this.getDataModel().getStringProperty("EJBRelationshipDataModel.BEAN_A_ROLE_NAME"));
                    this.getDataModel().setIgnorePropertyChanges(false);
                    this.setProperty("EJBRelationshipDataModel.BEAN_A_ROLE_NAME", this.getDataModel().getStringProperty("EJBRelationshipDataModel.BEAN_A_ROLE_NAME"));
                    canvas.getRoleNameLabelA().setVisible(false);
                    break;
                }
                case 1: {
                    canvas.getRoleBName().setVisible(false);
                    canvas.getRoleBName().setText(this.getDataModel().getStringProperty("EJBRelationshipDataModel.BEAN_B_ROLE_NAME"));
                    this.getDataModel().setIgnorePropertyChanges(false);
                    this.setProperty("EJBRelationshipDataModel.BEAN_B_ROLE_NAME", this.getDataModel().getStringProperty("EJBRelationshipDataModel.BEAN_B_ROLE_NAME"));
                    canvas.getRoleNameLabelB().setVisible(false);
                    break;
                }
            }
        }
        ((RelationshipCanvasWTP)comp).setRoleNavigable(value, source, false);
    }

    private void handleCMPChildren(String cmpName, PaletteViewer viewer, String propertyName) {
        for (Object obj : viewer.getEditPartRegistry().values()) {
            if (!(obj instanceof ToolEntryEditPart)) continue;
            ToolEntryEditPart toolEntry = (ToolEntryEditPart)obj;
            PaletteEntry entry = (PaletteEntry)toolEntry.getModel();
            String entryLevel = entry.getLabel();
            if (cmpName != null && cmpName.equals(entryLevel)) {
                toolEntry.setToolSelected(true);
                PaletteDrawer drawer = (PaletteDrawer)viewer.getPaletteRoot().getChildren().get(0);
                drawer.setLabel(entryLevel);
                continue;
            }
            toolEntry.setToolSelected(false);
        }
        if (this.getDataModel().getBooleanProperty("EJBRelationshipDataModel.IS_EDITING")) {
            ((RelationshipGEFWidgetFactory)viewer.getEditPartFactory()).getDrawer().setExpanded(false);
            ((RelationshipGEFWidgetFactory)viewer.getEditPartFactory()).getDrawer().button.setVisible(false);
            ((RelationshipGEFWidgetFactory)viewer.getEditPartFactory()).getDrawer().button.setEnabled(false);
            viewer.getControl().setEnabled(true);
        }
        if (this.getDataModel().getBooleanProperty("EJBRelationshipDataModel.BBEAN_END_COMPLETED") && this.getDataModel().getProperty(propertyName) != null) {
            this.getDataModel().setIgnorePropertyChanges(false);
            this.getDataModel().setBooleanProperty("EJBRelationshipDataModel.BBEAN_END_COMPLETED", false);
            ((RelationshipGEFWidgetFactory)viewer.getEditPartFactory()).getDrawer().setExpanded(false);
            this.getDataModel().setIgnorePropertyChanges(true);
            ((RelationshipGEFWidgetFactory)viewer.getEditPartFactory()).getDrawer().button.setVisible(false);
            viewer.getControl().setEnabled(true);
        }
    }

    public Composite getGraphicViewer() {
        return this.graphicViewer;
    }

    public void setGraphicViewer(Composite graphicViewer) {
        this.graphicViewer = graphicViewer;
    }
}

