/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.gef.widgets;

import com.ibm.etools.ejb.ui.gef.widgets.DrawerAnimationController;
import com.ibm.etools.ejb.ui.gef.widgets.RelationshipDrawFigure;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class PaletteToolbarLayout
extends ToolbarLayout {
    private Rectangle[] sourceSizes;
    private Rectangle[] destinationSizes;
    private boolean scaling = false;
    private DrawerAnimationController controller;

    public PaletteToolbarLayout(DrawerAnimationController controller) {
        this.controller = controller;
    }

    private void captureDestinationSizes(IFigure parent) {
        List children = parent.getChildren();
        this.destinationSizes = new Rectangle[children.size()];
        int i = 0;
        while (i < children.size()) {
            this.destinationSizes[i] = ((IFigure)children.get(i)).getBounds().getCopy();
            ++i;
        }
    }

    private void captureSourceSizes(IFigure parent) {
        List children = parent.getChildren();
        this.sourceSizes = new Rectangle[children.size()];
        int i = 0;
        while (i < children.size()) {
            this.sourceSizes[i] = ((IFigure)children.get(i)).getBounds().getCopy();
            ++i;
        }
    }

    protected boolean isChildGrowing(IFigure child) {
        return child instanceof RelationshipDrawFigure && ((RelationshipDrawFigure)child).isExpanded();
    }

    private boolean isScaling() {
        return this.scaling;
    }

    public void layout(IFigure parent) {
        if (this.isScaling()) {
            this.scaledLayout(parent);
            this.setScaling(this.controller.isAnimationInProgress());
        } else if (this.controller != null && this.controller.isAnimationInProgress()) {
            this.captureSourceSizes(parent);
            this.normalLayout(parent);
            this.captureDestinationSizes(parent);
            this.setScaling(true);
        } else {
            this.normalLayout(parent);
        }
    }

    private void normalLayout(IFigure parent) {
        boolean stretching;
        IFigure child;
        List children = parent.getChildren();
        ArrayList<Object> childrenGrabbingVertical = new ArrayList<Object>();
        int numChildren = children.size();
        Rectangle clientArea = this.transposer.t(parent.getClientArea());
        int x = clientArea.x;
        int y = clientArea.y;
        int availableHeight = clientArea.height;
        Dimension[] prefSizes = new Dimension[numChildren];
        Dimension[] minSizes = new Dimension[numChildren];
        int totalHeight = 0;
        int totalMinHeight = 0;
        int heightOfNonGrowingChildren = 0;
        int heightPerChild = 0;
        int excessHeight = 0;
        int wHint = this.isHorizontal() ? -1 : clientArea.width;
        int hHint = this.isHorizontal() ? clientArea.width : -1;
        int i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            prefSizes[i] = this.transposer.t(child.getPreferredSize(wHint, hHint));
            minSizes[i] = this.transposer.t(child.getMinimumSize(wHint, hHint));
            totalHeight += prefSizes[i].height;
            totalMinHeight += minSizes[i].height;
            if (this.isChildGrowing(child)) {
                childrenGrabbingVertical.add(child);
            } else {
                heightOfNonGrowingChildren += prefSizes[i].height;
            }
            ++i;
        }
        boolean bl = stretching = (totalHeight += (numChildren - 1) * this.getSpacing()) - Math.max(availableHeight, totalMinHeight += (numChildren - 1) * this.getSpacing()) < 0;
        if (!childrenGrabbingVertical.isEmpty()) {
            boolean childrenDiscarded;
            if (stretching) {
                i = 0;
                while (i < childrenGrabbingVertical.size() - 1) {
                    int index = children.indexOf(childrenGrabbingVertical.get(i));
                    heightOfNonGrowingChildren += prefSizes[index].height;
                    ++i;
                }
                Object last = childrenGrabbingVertical.get(childrenGrabbingVertical.size() - 1);
                childrenGrabbingVertical.clear();
                childrenGrabbingVertical.add(last);
            }
            int spaceToConsume = availableHeight - heightOfNonGrowingChildren;
            heightPerChild = spaceToConsume / childrenGrabbingVertical.size();
            excessHeight = spaceToConsume - heightPerChild * childrenGrabbingVertical.size();
            block6: do {
                childrenDiscarded = false;
                for (IFigure iFigure : childrenGrabbingVertical) {
                    int i2 = iFigure.getParent().getChildren().indexOf(iFigure);
                    boolean discardChild = false;
                    if (stretching) {
                        discardChild = prefSizes[i2].height > heightPerChild;
                    } else {
                        boolean bl2 = discardChild = prefSizes[i2].height < heightPerChild;
                    }
                    if (!discardChild) continue;
                    heightOfNonGrowingChildren += prefSizes[i2].height;
                    childrenGrabbingVertical.remove(iFigure);
                    childrenDiscarded = true;
                    heightPerChild = (spaceToConsume -= prefSizes[i2].height) / childrenGrabbingVertical.size();
                    excessHeight = spaceToConsume - heightPerChild * childrenGrabbingVertical.size();
                    continue block6;
                }
            } while (childrenDiscarded);
        }
        i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            Rectangle newBounds = new Rectangle(x, y, prefSizes[i].width, prefSizes[i].height);
            if (childrenGrabbingVertical.contains(child)) {
                childrenGrabbingVertical.remove(child);
                newBounds.height = childrenGrabbingVertical.isEmpty() ? heightPerChild + excessHeight : heightPerChild;
            }
            int n = minSizes[i].width;
            int width = Math.min(prefSizes[i].width, child.getMaximumSize().width);
            if (this.getStretchMinorAxis()) {
                width = this.transposer.t((Dimension)child.getMaximumSize()).width;
            }
            newBounds.width = width = Math.max(n, Math.min(clientArea.width, width));
            int adjust = clientArea.width - width;
            switch (this.getMinorAlignment()) {
                case 1: {
                    adjust = 0;
                    break;
                }
                case 0: {
                    adjust /= 2;
                    break;
                }
            }
            newBounds.x += adjust;
            child.setBounds(this.transposer.t(newBounds));
            y += newBounds.height + this.getSpacing();
            ++i;
        }
    }

    private void scaledLayout(IFigure parent) {
        List children = parent.getChildren();
        float progress = this.controller.getAnimationProgress();
        int i = 0;
        while (i < children.size()) {
            Rectangle rect1 = this.sourceSizes[i];
            Rectangle rect2 = this.destinationSizes[i];
            IFigure child = (IFigure)children.get(i);
            child.setBounds(new Rectangle(Math.round(progress * (float)rect2.x + (1.0f - progress) * (float)rect1.x), Math.round(progress * (float)rect2.y + (1.0f - progress) * (float)rect1.y), Math.round(progress * (float)rect2.width + (1.0f - progress) * (float)rect1.width), Math.round(progress * (float)rect2.height + (1.0f - progress) * (float)rect1.height)));
            ++i;
        }
    }

    private void setScaling(boolean newVal) {
        this.scaling = newVal;
        if (!this.scaling) {
            this.sourceSizes = null;
            this.destinationSizes = null;
        }
    }
}

