/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.actions.standalone;

import com.ibm.etools.application.nls.ApplicationEditorResourceHandler;
import com.ibm.etools.ejb.ui.actions.standalone.AbstractEditModelAction;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.common.internal.impl.CommonFactoryImpl;
import org.eclipse.jst.j2ee.common.internal.provider.CommonItemProviderAdapterFactory;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModelModifier;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class RemoveReferenceAction
extends AbstractEditModelAction {
    protected static final EClass EJBREF_CLASS = CommonFactoryImpl.getPackage().getEjbRef();
    protected static final EClass EJBLOCALREF_CLASS = CommonFactoryImpl.getPackage().getEJBLocalRef();
    protected static final EClass RESREF_CLASS = CommonFactoryImpl.getPackage().getResourceRef();
    protected static final EClass RESENVREF_CLASS = CommonFactoryImpl.getPackage().getResourceEnvRef();
    protected static final EClass SECROLEREF_CLASS = CommonFactoryImpl.getPackage().getSecurityRoleRef();
    private static RemoveReferenceAction instance = null;

    public static RemoveReferenceAction getInstance() {
        if (instance == null) {
            instance = new RemoveReferenceAction();
        }
        return instance;
    }

    private RemoveReferenceAction() {
        super(ApplicationEditorResourceHandler.REMOVE_MENU_LABEL_UI_);
    }

    @Override
    protected IHeadlessRunnableWithProgress getHeadlessOperation() {
        return null;
    }

    @Override
    public void doRun() {
        ModelModifier modifier = new ModelModifier((EditingDomain)new AdapterFactoryEditingDomain((AdapterFactory)new CommonItemProviderAdapterFactory(), this.getCommandStack()));
        List selectedReferences = this.getStructuredSelection().toList();
        int i = 0;
        while (i < selectedReferences.size()) {
            EObject ref = (EObject)selectedReferences.get(i);
            if (!(ref instanceof EnterpriseBean)) {
                ModifierHelper helper = new ModifierHelper();
                helper.setOwner(ref.eContainer());
                helper.setFeature((EStructuralFeature)ref.eContainmentFeature());
                helper.setValue((Object)ref);
                helper.doUnsetValue();
                modifier.addHelper(helper);
            }
            ++i;
        }
        modifier.execute();
    }

    protected void createRefBindingRemoveHelper(ModelModifier modifier, List selectedObjectList) {
    }

    public static boolean isReferenceType(Object anObject) {
        if (anObject != null && anObject instanceof EObject) {
            EObject refObject = (EObject)anObject;
            EClass meta = refObject.eClass();
            return meta == EJBREF_CLASS || meta == EJBLOCALREF_CLASS || meta == RESREF_CLASS || meta == RESENVREF_CLASS || meta == SECROLEREF_CLASS;
        }
        return false;
    }

    @Override
    public boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        boolean result = false;
        for (Object obj : selection) {
            if (RemoveReferenceAction.isReferenceType(obj)) {
                result = true;
                continue;
            }
            return false;
        }
        return result;
    }
}

