/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.actions.standalone;

import com.ibm.etools.ejb.codegen.helpers.EnterpriseBeanHelper;
import com.ibm.etools.ejb.creation.CMPField;
import com.ibm.etools.ejb.creation.wizard.CMPFieldDialog;
import com.ibm.etools.ejb.creation.wizard.PageHelper;
import com.ibm.etools.ejb.ui.actions.standalone.EJBAction;
import com.ibm.etools.ejb.ui.dialogs.RequestNewKeyClassDialog;
import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import com.ibm.etools.j2ee.commands.AddPersistentAttributeCommand;
import com.ibm.etools.j2ee.commands.CreatePersistentAttributeCommand;
import com.ibm.etools.j2ee.commands.CreatePrimaryKeyClassCommand;
import com.ibm.etools.j2ee.commands.IPersistentAttributeCommand;
import com.ibm.etools.j2ee.commands.IRootCommand;
import com.ibm.etools.j2ee.commands.UpdateContainerManagedEntityCommand;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.common.jdt.internal.integration.WorkingCopyProvider;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderManager;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;

public class CreatePersistentAttributeAction
extends EJBAction {
    protected CMPField field;
    protected List fields;
    protected boolean enableKey = true;
    protected String packageName = null;
    protected String keyClassName = null;
    protected TreeViewer viewer = null;
    protected IPersistentAttributeCommand attributeCommand = null;
    protected CMPAttribute createdAttribute = null;
    protected boolean dialogCancelled = false;
    private static CreatePersistentAttributeAction instance = null;

    public static CreatePersistentAttributeAction getInstance() {
        if (instance == null) {
            instance = new CreatePersistentAttributeAction();
        }
        return instance;
    }

    private CreatePersistentAttributeAction() {
        super(EJBUIResourceHandler.Create_Attribute___);
        URL gifImageURL = (URL)J2EEPlugin.getDefault().getImage("full" + File.separator + "obj16" + File.separator + "attribute_obj");
        if (gifImageURL != null) {
            this.setImageDescriptor(ImageDescriptor.createFromURL((URL)gifImageURL));
        }
    }

    @Override
    public void actionPerformed(IAction action) {
        if (!this.getStructuredSelection().isEmpty()) {
            this.requestFieldInput();
        }
        super.actionPerformed(action);
    }

    public void createAttributeCommand(IRootCommand rootCommand) {
        if (this.field.isExisting()) {
            this.attributeCommand = new AddPersistentAttributeCommand(rootCommand, this.field.getName());
        } else {
            this.attributeCommand = new CreatePersistentAttributeCommand(rootCommand, this.field.getName());
            this.attributeCommand.setRemote(this.field.isPromoteGS());
            this.attributeCommand.setLocal(this.field.isPromoteLocalGS());
            this.attributeCommand.setGenerateAccessors(this.field.isAccessWithGS());
            if (this.field.isIsArray()) {
                this.attributeCommand.setArrayDimensions(this.field.getArrayDimension());
            }
            this.attributeCommand.setInitializer(this.field.getInitialValue());
        }
        this.attributeCommand.setTypeName(this.field.getType());
        this.attributeCommand.setKey(this.field.isIsKey());
        this.attributeCommand.setIsReadOnly(this.field.isGetterRO());
    }

    public void createNewKeyClassCommandIfNecessary(IRootCommand rootCommand) {
        if (this.packageName == null || this.keyClassName == null) {
            return;
        }
        new CreatePrimaryKeyClassCommand(rootCommand, this.keyClassName, this.packageName);
    }

    protected void createNewKeyClassDialogIfNecessary() {
        if (!this.getField().isIsKey()) {
            return;
        }
        ContainerManagedEntity bean = (ContainerManagedEntity)this.getEjb();
        if (bean.getPrimKeyField() == null) {
            return;
        }
        RequestNewKeyClassDialog dialog = new RequestNewKeyClassDialog(this.getWorkbenchWindow().getShell(), (EnterpriseBean)bean, true);
        dialog.setBlockOnOpen(true);
        dialog.open();
        this.dialogCancelled = dialog.isHasCancelled();
        this.packageName = dialog.getKeyClassPackageName();
        this.keyClassName = dialog.getKeyClassName();
    }

    @Override
    public IRootCommand createRootCommand() {
        if (!this.hasCancelled()) {
            EnterpriseBean ejb = this.getEjb();
            if (ejb == null) {
                return null;
            }
            UpdateContainerManagedEntityCommand root = new UpdateContainerManagedEntityCommand(ejb, this.getEJBArtifactEdit());
            this.createAttributeCommand((IRootCommand)root);
            this.createNewKeyClassCommandIfNecessary((IRootCommand)root);
            return root;
        }
        return null;
    }

    @Override
    public void dispose() {
    }

    public CMPAttribute getCreatedAttribute() {
        return this.createdAttribute;
    }

    public CMPField getField() {
        return this.field;
    }

    public List getFields() {
        return this.fields;
    }

    @Override
    protected IHeadlessRunnableWithProgress getHeadlessOperation() {
        if (this.dialogCancelled) {
            return null;
        }
        return super.getHeadlessOperation();
    }

    public boolean hasCancelled() {
        return this.getField() == null;
    }

    protected void requestFieldInput() {
        PageHelper.setJavaProject(JemProjectUtilities.getJavaProject((IProject)ProjectUtilities.getProject((EObject)this.getEJBArtifactEdit().getContentModelRoot())));
        EnterpriseBean bean = this.getEjb();
        CMPFieldDialog dialog = null;
        dialog = bean.isContainerManagedEntity() ? new CMPFieldDialog(this.getWorkbenchWindow().getShell(), (ContainerManagedEntity)bean, (WorkingCopyProvider)this.getEJBArtifactEdit()) : new CMPFieldDialog(this.getWorkbenchWindow().getShell(), bean.getVersionID() >= 20, bean.hasRemoteClient(), bean.hasLocalClient());
        dialog.setBlockOnOpen(true);
        dialog.setRemainOpen(false);
        if (this.getEjb().isContainerManagedEntity()) {
            ContainerManagedEntity cmp = (ContainerManagedEntity)this.getEjb();
            this.setFields((List)cmp.getPersistentAttributes());
            int binaryMode = 0;
            if (!EnterpriseBeanHelper.canModifySource((JavaClass)cmp.getPrimaryKey())) {
                binaryMode |= 8;
            }
            if (bean.hasRemoteClient()) {
                if (!EnterpriseBeanHelper.canModifySource((JavaClass)bean.getHomeInterface())) {
                    binaryMode |= 8;
                }
                if (!EnterpriseBeanHelper.canModifySource((JavaClass)bean.getRemoteInterface())) {
                    binaryMode |= 4;
                }
            }
            if (!EnterpriseBeanHelper.canModifySource((JavaClass)bean.getEjbClass())) {
                binaryMode |= 1;
            }
            if (bean.hasLocalClient()) {
                if (!EnterpriseBeanHelper.canModifySource((JavaClass)bean.getLocalHomeInterface())) {
                    binaryMode |= 8;
                }
                if (!EnterpriseBeanHelper.canModifySource((JavaClass)bean.getLocalInterface())) {
                    binaryMode |= 0x16;
                }
            }
            dialog.setBinaryMode(binaryMode);
        }
        dialog.setFAttributes(this.fields);
        dialog.setEnableKey(this.enableKey);
        dialog.open();
        this.setField(dialog.getResult());
    }

    @Override
    public void doRun() {
        if (!this.getStructuredSelection().isEmpty()) {
            this.setEjb(this.getEjbFromSelection());
            this.updateKeyEnablement();
            this.requestFieldInput();
            if (this.getField() != null) {
                this.createNewKeyClassDialogIfNecessary();
            }
        }
        super.doRun();
        if (this.attributeCommand != null && this.attributeCommand.getSourceMetaType() != null) {
            this.setCreatedAttribute((CMPAttribute)this.attributeCommand.getSourceMetaType());
            if (this.viewer != null) {
                this.viewer.refresh((Object)this.getCreatedAttribute());
            }
        }
    }

    public void setCreatedAttribute(CMPAttribute newCreatedAttribute) {
        this.createdAttribute = newCreatedAttribute;
    }

    private void setEnableKey(boolean newEnableKey) {
        this.enableKey = newEnableKey;
    }

    public void setField(CMPField newField) {
        this.field = newField;
    }

    public void setFields(List newFields) {
        this.fields = newFields;
    }

    public void updateKeyEnablement() {
        EnterpriseBean ejb = this.getEjbFromSelection();
        if (ejb != null) {
            this.setEnableKey(CreatePersistentAttributeAction.getSupertype(ejb) == null);
        }
    }

    protected static EnterpriseBean getSupertype(EnterpriseBean bean) {
        EjbModuleExtensionHelper modHelper = IEJBModelExtenderManager.INSTANCE.getEJBModuleExtension(null);
        return modHelper == null ? null : modHelper.getSuperType(bean);
    }

    @Override
    public boolean updateSelection(IStructuredSelection selection) {
        Object obj;
        if (!super.updateSelection(selection)) {
            return false;
        }
        return selection.size() == 1 && (obj = selection.getFirstElement()) instanceof ContainerManagedEntity;
    }
}

