/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.actions.standalone;

import com.ibm.etools.ejb.codegen.helpers.EnterpriseBeanHelper;
import com.ibm.etools.ejb.ui.actions.standalone.AbstractFeatureKeyAction;
import com.ibm.etools.ejb.ui.dialogs.RequestNewKeyClassDialog;
import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import com.ibm.etools.j2ee.commands.AddKeyAttributeCommand;
import com.ibm.etools.j2ee.commands.CreatePrimaryKeyClassCommand;
import com.ibm.etools.j2ee.commands.IRootCommand;
import com.ibm.etools.j2ee13.commands.AddKey20RoleCommand;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBRelationshipRole;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.swt.widgets.Shell;

public class AddFeatureToKeyAction
extends AbstractFeatureKeyAction {
    protected String packageName = null;
    protected String keyClassName = null;
    private static String SPACE = " ";
    private static AddFeatureToKeyAction instance = null;
    private static Status FALSE_STATUS = new Status(false);

    public static AddFeatureToKeyAction getInstance() {
        if (instance == null) {
            instance = new AddFeatureToKeyAction();
        }
        return instance;
    }

    private AddFeatureToKeyAction() {
        super(EJBUIResourceHandler.Add_To_Key);
    }

    @Override
    protected void createDependentAttributeCommand(IRootCommand rootCommand, CMPAttribute cmpAttribute) {
        new AddKeyAttributeCommand(rootCommand, cmpAttribute.getName());
    }

    @Override
    protected void createDependentRoleCommand(IRootCommand rootCommand, CommonRelationshipRole aRole) {
        new AddKey20RoleCommand(rootCommand, (EJBRelationshipRole)aRole);
    }

    public void createNewKeyClassCommand(IRootCommand rootCommand2) {
        if (this.packageName == null || this.keyClassName == null) {
            return;
        }
        IRootCommand rootCommand = this.getUpdateCMPCommand((ContainerManagedEntity)this.getEjb());
        new CreatePrimaryKeyClassCommand(rootCommand, this.keyClassName, this.packageName);
        this.keyClassName = null;
        this.packageName = null;
    }

    protected boolean createNewKeyClassDialogIfNecessary() {
        boolean dialogCancelled = false;
        ContainerManagedEntity bean = (ContainerManagedEntity)this.getEjb();
        if (bean == null || bean.getPrimKeyField() == null) {
            return dialogCancelled;
        }
        RequestNewKeyClassDialog dialog = new RequestNewKeyClassDialog(this.getWorkbenchWindow().getShell(), (EnterpriseBean)bean, true);
        dialog.setBlockOnOpen(true);
        dialog.open();
        dialogCancelled = dialog.getReturnCode() == 1;
        this.packageName = dialog.getKeyClassPackageName();
        this.keyClassName = dialog.getKeyClassName();
        return dialogCancelled;
    }

    @Override
    public IRootCommand createRootCommand() {
        Status status = this.findCylicalKeyRefs();
        if (!status.isOK()) {
            if (status.getCycle() == null) {
                return null;
            }
            MessageDialog.openWarning((Shell)this.getWorkbenchWindow().getShell(), (String)EJBUIResourceHandler.AddFeatureToKeyAction_Key_Role_Cycle_Detected, (String)status.getCycle());
            return null;
        }
        if (this.createNewKeyClassDialogIfNecessary()) {
            return null;
        }
        IRootCommand root = super.createRootCommand();
        this.createNewKeyClassCommand(root);
        return root;
    }

    protected void createUpdateCMPCommand(CMPAttribute cmpAttribute, HashMap map) {
        ContainerManagedEntity cmp = (ContainerManagedEntity)cmpAttribute.eContainer();
        IRootCommand root = this.getUpdateCMPCommand(cmp);
        new AddKeyAttributeCommand(root, cmpAttribute.getName());
    }

    private boolean calculateApplicable(IStructuredSelection sel) {
        for (Object next : sel) {
            if (next instanceof CMPAttribute || next instanceof EJBRelationshipRole) continue;
            this.setApplicable(false);
            return false;
        }
        this.setApplicable(true);
        return true;
    }

    @Override
    public boolean updateSelection(IStructuredSelection sel) {
        if (!super.updateSelection(sel) || !this.calculateApplicable(sel)) {
            return false;
        }
        Status status = AddFeatureToKeyAction.checkSelection(sel, false);
        return status.isOK();
    }

    public static Status checkSelection(IStructuredSelection sel, boolean searchForKeyCycles) {
        boolean hasDevRole = J2EEPlugin.hasDevelopmentRole();
        ContainerManagedEntity ejb = null;
        ContainerManagedEntity cmp = null;
        for (Object next : sel) {
            boolean canAddPrimKey;
            cmp = null;
            if (next instanceof CMPAttribute) {
                EObject refObject;
                CMPAttribute attribute = (CMPAttribute)next;
                if (attribute.getType() == null) {
                    return FALSE_STATUS;
                }
                if (!attribute.isKey() && (refObject = attribute.eContainer()) instanceof ContainerManagedEntity) {
                    cmp = (ContainerManagedEntity)refObject;
                }
            } else if (next instanceof CommonRelationshipRole) {
                String cycle;
                if (!hasDevRole) {
                    return FALSE_STATUS;
                }
                CommonRelationshipRole role = (CommonRelationshipRole)next;
                if (!role.isMany() && !role.isKey() && role.isForward()) {
                    cmp = role.getSourceEntity();
                }
                if (searchForKeyCycles && (cycle = AddFeatureToKeyAction.findCyclicalKeyRefsFromRole(role)) != null) {
                    return new Status(cycle);
                }
            } else {
                return FALSE_STATUS;
            }
            if (AddFeatureToKeyAction.getSupertype(cmp) != null) {
                return FALSE_STATUS;
            }
            if (ejb == null) {
                ejb = cmp;
            }
            if (ejb != cmp || cmp == null) {
                return FALSE_STATUS;
            }
            if (AddFeatureToKeyAction.getSupertype((EnterpriseBean)cmp) != null) {
                return FALSE_STATUS;
            }
            if (cmp.getPrimKeyField() != null) continue;
            boolean bl = canAddPrimKey = cmp.getKeyAttributes().isEmpty() && next instanceof CMPAttribute && ((CMPAttribute)next).getType() == cmp.getPrimaryKey();
            if (canAddPrimKey || hasDevRole && EnterpriseBeanHelper.canModifyKey((EnterpriseBean)cmp)) continue;
            return FALSE_STATUS;
        }
        return new Status(true);
    }

    public static String findCyclicalKeyRefsFromRole(Object role) {
        ContainerManagedEntity cmp = null;
        ContainerManagedEntity nextCMP = null;
        String roleName = null;
        CommonRelationshipRole relRole = (CommonRelationshipRole)role;
        nextCMP = relRole.getTypeEntity();
        cmp = relRole.getOppositeAsCommonRole().getTypeEntity();
        roleName = relRole.getName();
        if (cmp == nextCMP) {
            return EJBUIResourceHandler.AddFeatureToKeyAction_Self_reference_key_cycle;
        }
        HashSet<ContainerManagedEntity> visitedCMPs = new HashSet<ContainerManagedEntity>();
        visitedCMPs.add(cmp);
        String cycle = AddFeatureToKeyAction.findCylicalKeyRefs(nextCMP, visitedCMPs);
        if (cycle != null) {
            String prefix = String.valueOf(EJBUIResourceHandler.AddFeatureToKeyAction_Key_role_cycle_detected) + SPACE;
            prefix = String.valueOf(prefix) + roleName;
            prefix = String.valueOf(prefix) + SPACE + EJBUIResourceHandler.AddFeatureToKeyAction_to_key;
            cycle = String.valueOf(prefix) + cycle;
            cycle = AddFeatureToKeyAction.addCycle(cycle, nextCMP, cmp, roleName);
        }
        return cycle;
    }

    public static String addCycle(String cycle, ContainerManagedEntity nextCMP, ContainerManagedEntity cmp, String roleName) {
        cycle = String.valueOf(cycle) + "\n";
        cycle = String.valueOf(cycle) + EJBUIResourceHandler.AddFeatureToKeyAction_CMP + SPACE;
        cycle = String.valueOf(cycle) + nextCMP.getName();
        cycle = String.valueOf(cycle) + SPACE + EJBUIResourceHandler.AddFeatureToKeyAction_referenced_from + SPACE;
        cycle = String.valueOf(cycle) + roleName;
        cycle = String.valueOf(cycle) + SPACE + EJBUIResourceHandler.AddFeatureToKeyAction_defined_in_CMP + SPACE;
        cycle = String.valueOf(cycle) + cmp.getName();
        return cycle;
    }

    /*
     * Unable to fully structure code
     */
    public static String findCylicalKeyRefs(ContainerManagedEntity cmp, HashSet visitedCMPs) {
        if (!visitedCMPs.contains(cmp)) ** GOTO lbl8
        return "";
lbl-1000:
        // 1 sources

        {
            cmp = (ContainerManagedEntity)superType;
            if (visitedCMPs.contains(cmp)) {
                return "";
            }
            visitedCMPs.add(cmp);
lbl8:
            // 2 sources

            ** while ((superType = AddFeatureToKeyAction.getSupertype((EnterpriseBean)cmp)) != null)
        }
lbl9:
        // 1 sources

        visitedCMPs.add(cmp);
        roles = cmp.getRoles();
        i = 0;
        while (i < roles.size()) {
            role = (CommonRelationshipRole)roles.get(i);
            nextCMP = null;
            roleName = null;
            if (role.isKey()) {
                nextCMP = role.getTypeEntity();
                roleName = role.getName();
            }
            if (nextCMP != null && (cycle = AddFeatureToKeyAction.findCylicalKeyRefs(nextCMP, visitedCMPs)) != null) {
                return AddFeatureToKeyAction.addCycle(cycle, nextCMP, cmp, roleName);
            }
            ++i;
        }
        visitedCMPs.remove(cmp);
        return null;
    }

    public Status findCylicalKeyRefs() {
        IStructuredSelection sel = this.getStructuredSelection();
        return AddFeatureToKeyAction.checkSelection(sel, true);
    }

    @Override
    public void doRun() {
        super.doRun();
    }

    private static class Status {
        private boolean ok = false;
        private String cycle = null;

        public Status(boolean ok) {
            this.ok = ok;
            this.cycle = null;
        }

        public Status(String cycle) {
            this.ok = false;
            this.cycle = cycle;
        }

        public boolean isOK() {
            return this.ok;
        }

        public String getCycle() {
            return this.cycle;
        }
    }
}

