/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.creation.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SimpleSelectionList
extends SelectionDialog {
    private Object[] fElements;
    protected Object[] fResult;
    protected Table fList;
    protected Label fMessage;
    private String fMessageText;
    protected Button okButton;
    private boolean fIsMultipleSelection;

    public SimpleSelectionList(Shell shell, Object[] elements, boolean multipleSelection) {
        super(shell);
        this.fElements = elements;
        this.fIsMultipleSelection = multipleSelection;
        this.fMessageText = "";
        this.quickSort(0, this.fElements.length - 1);
    }

    public void create() {
        super.create();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        ((GridLayout)contents.getLayout()).numColumns = 1;
        this.fMessage = this.createMessage(contents);
        this.fList = this.createList(contents);
        this.fList.deselectAll();
        int i = 0;
        while (i < this.fElements.length) {
            TableItem ti = new TableItem(this.fList, i);
            ti.setText(this.fElements[i].toString());
            ++i;
        }
        this.fResult = null;
        List sl = this.getInitialElementSelections();
        if (sl != null && this.fList != null) {
            block1: for (Object o : sl) {
                int i2 = 0;
                while (i2 < this.fElements.length) {
                    if (o.equals(this.fElements[i2])) {
                        this.fList.select(i2);
                        TableItem ti = this.fList.getItem(i2);
                        ti.setChecked(true);
                        continue block1;
                    }
                    ++i2;
                }
            }
        }
        return contents;
    }

    protected Table createList(Composite parent) {
        int flags = 0;
        if (this.fIsMultipleSelection) {
            flags |= 2;
        }
        Table list = new Table(parent, flags | 0x800 | 0x200 | 0x100 | 0x20);
        list.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                SimpleSelectionList.this.handleSelectionChanged();
            }
        });
        GridData spec = new GridData();
        spec.widthHint = 200;
        spec.heightHint = 200;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        list.setLayoutData((Object)spec);
        return list;
    }

    protected Label createMessage(Composite parent) {
        Label text = new Label(parent, 0);
        text.setText(this.fMessageText);
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        text.setLayoutData((Object)spec);
        return text;
    }

    public Object[] getResult() {
        return this.fResult;
    }

    private Object[] getSelected() {
        if (this.fList == null || this.fList.isDisposed()) {
            return new Object[0];
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < this.fList.getItemCount()) {
            TableItem ti = this.fList.getItem(i);
            if (ti.getChecked()) {
                list.add(this.fElements[i]);
            }
            ++i;
        }
        return list.toArray();
    }

    private void handleSelectionChanged() {
        if (!this.fIsMultipleSelection) {
            int index = this.fList.getSelectionIndex();
            int i = 0;
            while (i < this.fList.getItemCount()) {
                if (i == index) {
                    this.fList.getItem(i).setChecked(true);
                } else {
                    this.fList.getItem(i).setChecked(false);
                }
                ++i;
            }
        }
        if (this.okButton != null) {
            int i = 0;
            while (i < this.fList.getItemCount()) {
                TableItem ti = this.fList.getItem(i);
                if (ti.getChecked()) {
                    this.okButton.setEnabled(true);
                    return;
                }
                ++i;
            }
            this.okButton.setEnabled(false);
        }
    }

    protected void okPressed() {
        this.fResult = this.getSelected();
        super.okPressed();
    }

    private void quickSort(int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = this.fElements[(left + right) / 2].toString();
        while (true) {
            if (this.smaller(this.fElements[left].toString(), mid)) {
                ++left;
                continue;
            }
            while (this.smaller(mid, this.fElements[right].toString())) {
                --right;
            }
            if (left <= right) {
                Object tmp2 = this.fElements[left];
                this.fElements[left] = this.fElements[right];
                this.fElements[right] = tmp2;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            this.quickSort(original_left, right);
        }
        if (left < original_right) {
            this.quickSort(left, original_right);
        }
    }

    public void setInitialSelections(Object[] selectedElements) {
        super.setInitialSelections(selectedElements);
    }

    public void setMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.fMessageText = message;
        if (this.fMessage != null && !this.fMessage.isDisposed()) {
            this.fMessage.setText(message);
        }
    }

    private boolean smaller(String left, String right) {
        return left.toLowerCase().compareTo(right.toLowerCase()) < 0;
    }
}

