/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.creation.wizard;

import com.ibm.etools.ejb.creation.ui.nls.EJBCreationUIResourceHandler;
import com.ibm.etools.ejb.creation.wizard.ElementListSelectionDialog;
import com.ibm.etools.ejb.creation.wizard.ProjectHierarchyScope;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jem.internal.adapters.jdom.JDOMSearchHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.xml.core.internal.provisional.NameValidator;

public class PageHelper {
    protected static final int HORIZONTAL_INDENT = 15;
    protected static final int SIZING_TEXT_FIELD_WIDTH = 250;
    protected static IJavaProject fJavaProject;
    protected static IPackageFragment[] allPackages;
    protected static String[] allPackageNames;

    public static void addClassPath(String path) throws JavaModelException {
        IClasspathEntry[] entries = new IClasspathEntry[]{JavaCore.newLibraryEntry((IPath)new Path(path), null, null)};
        fJavaProject.setRawClasspath(entries, null);
    }

    public static String convertToJavaIdentifier(String identifier) {
        StringBuffer sb = new StringBuffer();
        boolean foundStartChar = false;
        int i = 0;
        int n = identifier.length();
        while (i < n) {
            char ch = identifier.charAt(i);
            if (!foundStartChar) {
                if (Character.isJavaIdentifierStart(ch)) {
                    sb.append(ch);
                    foundStartChar = true;
                }
            } else if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
            }
            ++i;
        }
        if (PageHelper.isJavaKeyword(identifier)) {
            sb.append("1");
        }
        return sb.toString();
    }

    public static Button createCheckButton(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    public static Combo createCombo(Composite parent, String[] list) {
        Combo combo = new Combo(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        combo.setLayoutData((Object)data);
        int i = 0;
        while (i < list.length) {
            combo.add(list[i]);
            ++i;
        }
        return combo;
    }

    public static Composite createComposite(Composite parent, int numColumns, int horizontalIndent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 450;
        data.horizontalIndent = horizontalIndent;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    public static org.eclipse.swt.widgets.List createList(Composite parent, int style) {
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, style);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        data.verticalSpan = 4;
        list.setLayoutData((Object)data);
        return list;
    }

    public static Button createPushButton(Composite group, String label, boolean enabled) {
        Button button = new Button(group, 0x1000008);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        button.setLayoutData((Object)data);
        button.setEnabled(enabled);
        return button;
    }

    public static Button createRadioButton(Composite group, String label) {
        Button button = new Button(group, 16400);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    public static Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        return text;
    }

    public static IType findType(String bean) {
        if (fJavaProject == null) {
            return null;
        }
        return PageHelper.findType(bean, fJavaProject.getProject());
    }

    public static IType findType(String qualifiedName, IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return JDOMSearchHelper.findType((String)qualifiedName, (boolean)true, (IJavaProject)javaProject, null);
    }

    public static String[] getAllPackageNames() {
        return allPackageNames;
    }

    public static boolean getAllPackages() {
        if (fJavaProject == null) {
            return false;
        }
        if (allPackages == null || allPackages.length == 0) {
            int i;
            int count;
            int[] index;
            IPackageFragment[] allPackagesTemp;
            block10: {
                block9: {
                    allPackagesTemp = fJavaProject.getPackageFragments();
                    if (allPackagesTemp != null && allPackagesTemp.length != 0) break block9;
                    return false;
                }
                index = new int[allPackagesTemp.length];
                HashSet<String> set = new HashSet<String>();
                count = 0;
                i = 0;
                while (i < allPackagesTemp.length) {
                    if (allPackagesTemp[i].hasChildren() && !set.contains(allPackagesTemp[i].getElementName())) {
                        index[count] = i;
                        ++count;
                        set.add(allPackagesTemp[i].getElementName());
                    }
                    ++i;
                }
                if (count != 0) break block10;
                return false;
            }
            try {
                allPackages = new IPackageFragment[count];
                allPackageNames = new String[count];
                i = 0;
                while (i < count) {
                    PageHelper.allPackages[i] = allPackagesTemp[index[i]];
                    PageHelper.allPackageNames[i] = allPackages[i].getElementName();
                    ++i;
                }
                PageHelper.quickSort(allPackageNames, allPackages, 0, allPackages.length - 1);
            }
            catch (JavaModelException e) {
                J2EEUIPlugin.logError((CoreException)((Object)e));
            }
        }
        return true;
    }

    public static IProject getExistingProjectForName(String projectName) {
        IProject project = J2EEPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            return project;
        }
        return null;
    }

    public static String[] getHomeInterfaces(Shell shell, boolean multipleSelection, boolean classOnly, boolean interfaceOnly) {
        String typeName;
        Vector<String> v;
        IJavaElement[] children;
        String packageName;
        block14: {
            if (!PageHelper.getAllPackages()) {
                return new String[0];
            }
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, allPackageNames, (ILabelProvider)new LabelProvider(), false, false);
            dialog.setMessage(EJBCreationUIResourceHandler.Please_select_a_package_fi_UI_);
            dialog.open();
            Object[] result = dialog.getResult();
            if (result == null) {
                return null;
            }
            if (result.length != 1) {
                return new String[0];
            }
            int index = -1;
            int i = 0;
            while (i < allPackageNames.length) {
                if (allPackageNames[i].equals(result[0].toString())) {
                    index = i;
                    break;
                }
                ++i;
            }
            packageName = allPackageNames[index];
            children = null;
            v = new Vector<String>(100);
            typeName = null;
            children = allPackages[index].getChildren();
            if (children != null && children.length != 0) break block14;
            MessageDialog.openInformation((Shell)shell, (String)EJBCreationUIResourceHandler.Information_UI_, (String)(String.valueOf(EJBCreationUIResourceHandler.No_types_in_the_package__UI_) + packageName));
            return null;
        }
        try {
            int j = 0;
            while (j < children.length) {
                typeName = children[j].getElementName();
                if (!(typeName.indexOf("$") != -1 || interfaceOnly && !((IClassFile)children[j]).getType().isInterface() || classOnly && !((IClassFile)children[j]).getType().isClass())) {
                    v.addElement(typeName.substring(0, typeName.length() - 6));
                }
                ++j;
            }
        }
        catch (JavaModelException e) {
            J2EEUIPlugin.logError((CoreException)((Object)e));
        }
        Object[] typeNames = new String[v.size()];
        v.copyInto(typeNames);
        PageHelper.quickSort((String[])typeNames, 0, typeNames.length - 1);
        ElementListSelectionDialog dialog2 = new ElementListSelectionDialog(shell, typeNames, (ILabelProvider)new LabelProvider(), false, multipleSelection);
        dialog2.setMessage(NLS.bind((String)EJBCreationUIResourceHandler.Types_in__UI_, (Object[])new Object[]{packageName}));
        if (classOnly) {
            dialog2.setMessage(NLS.bind((String)EJBCreationUIResourceHandler.Classes_in__UI_, (Object[])new Object[]{packageName}));
        }
        if (interfaceOnly) {
            dialog2.setMessage(NLS.bind((String)EJBCreationUIResourceHandler.Interfaces_in__UI_, (Object[])new Object[]{packageName}));
        }
        dialog2.open();
        Object[] types = dialog2.getResult();
        if (types == null || types.length == 0) {
            return null;
        }
        String[] selectedTypeNames = new String[types.length];
        int i = 0;
        while (i < types.length) {
            selectedTypeNames[i] = String.valueOf(packageName) + "." + types[i].toString();
            ++i;
        }
        return selectedTypeNames;
    }

    public static IJavaProject getJavaProject() {
        return fJavaProject;
    }

    public static String[] getProjectNamesForNature(String natureId) {
        List<IProject> projects = Arrays.asList(J2EEPlugin.getWorkspace().getRoot().getProjects());
        ArrayList<String> projectList = new ArrayList<String>();
        try {
            int i = 0;
            int n = projects.size();
            while (i < n) {
                IProject project = projects.get(i);
                if (project.isOpen() && project.isAccessible() && project.hasNature(natureId)) {
                    projectList.add(project.getFullPath().lastSegment());
                }
                ++i;
            }
        }
        catch (CoreException e) {
            J2EEUIPlugin.logError(e.getMessage());
        }
        int n = projectList.size();
        String[] projectNames = new String[n];
        int i = 0;
        while (i < n) {
            projectNames[i] = (String)projectList.get(i);
            ++i;
        }
        return projectNames;
    }

    public static String[] getProjectNamesForNature(String natureId, String natureId20) {
        List<IProject> projects = Arrays.asList(J2EEPlugin.getWorkspace().getRoot().getProjects());
        ArrayList<String> projectList = new ArrayList<String>();
        try {
            int i = 0;
            int n = projects.size();
            while (i < n) {
                IProject project = projects.get(i);
                if (project.isOpen() && project.isAccessible() && (project.hasNature(natureId) || project.hasNature(natureId20))) {
                    projectList.add(project.getFullPath().lastSegment());
                }
                ++i;
            }
        }
        catch (CoreException e) {
            J2EEUIPlugin.logError(e.getMessage());
        }
        int n = projectList.size();
        String[] projectNames = new String[n];
        int i = 0;
        while (i < n) {
            projectNames[i] = (String)projectList.get(i);
            ++i;
        }
        return projectNames;
    }

    public static String[] getTypes(Shell shell, boolean multipleSelection, boolean classOnly, boolean interfaceOnly, boolean homeInterfaceOnly, boolean remoteInterfaceOnly) {
        String typeName;
        Vector<String> v;
        IJavaElement[] children;
        String packageName;
        block16: {
            if (!PageHelper.getAllPackages()) {
                return new String[0];
            }
            Object[] packageNames = null;
            if (homeInterfaceOnly || remoteInterfaceOnly) {
                packageNames = new String[]{"javax.ejb"};
            } else {
                packageNames = new String[allPackageNames.length];
                System.arraycopy(allPackageNames, 0, packageNames, 0, allPackageNames.length);
            }
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, packageNames, (ILabelProvider)new LabelProvider(), false, false);
            dialog.setMessage(EJBCreationUIResourceHandler.Select_a_Package_UI_);
            dialog.open();
            Object[] result = dialog.getResult();
            if (result == null) {
                return null;
            }
            if (result.length != 1) {
                return new String[0];
            }
            int index = -1;
            int i = 0;
            while (i < allPackageNames.length) {
                if (allPackageNames[i].equals(result[0].toString())) {
                    index = i;
                    break;
                }
                ++i;
            }
            packageName = allPackageNames[index];
            children = null;
            v = new Vector<String>(100);
            typeName = null;
            children = allPackages[index].getChildren();
            if (children != null && children.length != 0) break block16;
            MessageDialog.openInformation((Shell)shell, (String)EJBCreationUIResourceHandler.Information_UI_, (String)(String.valueOf(EJBCreationUIResourceHandler.No_types_in_the_package__UI_) + packageName));
            return null;
        }
        try {
            int j = 0;
            while (j < children.length) {
                int offset;
                int elementType;
                typeName = children[j].getElementName();
                if (!(typeName.indexOf("$") != -1 || (elementType = children[j].getElementType()) == 6 && (interfaceOnly && (!((IClassFile)children[j]).getType().isInterface() || homeInterfaceOnly && !typeName.endsWith("Home.class") || remoteInterfaceOnly && typeName.endsWith("Home.class")) || classOnly && !((IClassFile)children[j]).getType().isClass()) || (offset = typeName.lastIndexOf(".")) == -1)) {
                    v.addElement(typeName.substring(0, offset));
                }
                ++j;
            }
        }
        catch (JavaModelException e) {
            J2EEUIPlugin.logError(e.getMessage());
        }
        Object[] typeNames = new String[v.size()];
        v.copyInto(typeNames);
        PageHelper.quickSort((String[])typeNames, 0, typeNames.length - 1);
        ElementListSelectionDialog dialog2 = new ElementListSelectionDialog(shell, typeNames, (ILabelProvider)new LabelProvider(), false, multipleSelection);
        dialog2.setTitle(EJBCreationUIResourceHandler.Type_Selection_Dialog_Title_UI_);
        dialog2.setMessage(String.valueOf(EJBCreationUIResourceHandler.Types_in__UI_) + " " + packageName);
        if (classOnly) {
            dialog2.setMessage(String.valueOf(EJBCreationUIResourceHandler.Classes_in__UI_) + " " + packageName);
        }
        if (interfaceOnly) {
            dialog2.setMessage(String.valueOf(EJBCreationUIResourceHandler.Interfaces_in__UI_) + " " + packageName);
        }
        dialog2.open();
        Object[] types = dialog2.getResult();
        if (types == null || types.length == 0) {
            return null;
        }
        String[] selectedTypeNames = new String[types.length];
        int i = 0;
        while (i < types.length) {
            selectedTypeNames[i] = String.valueOf(packageName) + "." + types[i].toString();
            ++i;
        }
        return selectedTypeNames;
    }

    public static void init() {
        fJavaProject = null;
        allPackages = null;
        allPackageNames = null;
    }

    public static boolean isJavaKeyword(String identifier) {
        if (identifier == null || identifier.equals("")) {
            return false;
        }
        return identifier.equals("abstract") || identifier.equals("boolean") || identifier.equals("break") || identifier.equals("byte") || identifier.equals("case") || identifier.equals("catch") || identifier.equals("char") || identifier.equals("class") || identifier.equals("const") || identifier.equals("continue") || identifier.equals("default") || identifier.equals("do") || identifier.equals("double") || identifier.equals("else") || identifier.equals("extends") || identifier.equals("false") || identifier.equals("final") || identifier.equals("finally") || identifier.equals("float") || identifier.equals("for") || identifier.equals("goto") || identifier.equals("if") || identifier.equals("implements") || identifier.equals("import") || identifier.equals("instanceof") || identifier.equals("int") || identifier.equals("interface") || identifier.equals("long") || identifier.equals("native") || identifier.equals("new") || identifier.equals("null") || identifier.equals("package") || identifier.equals("private") || identifier.equals("protected") || identifier.equals("public") || identifier.equals("return") || identifier.equals("short") || identifier.equals("static") || identifier.equals("strictfp") || identifier.equals("super") || identifier.equals("switch") || identifier.equals("sychronized") || identifier.equals("this") || identifier.equals("throw") || identifier.equals("throws") || identifier.equals("transient") || identifier.equals("true") || identifier.equals("try") || identifier.equals("void") || identifier.equals("volatile") || identifier.equals("while");
    }

    public static void quickSort(String[] keys, Object[] values, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = keys[(left + right) / 2];
        while (true) {
            if (PageHelper.smaller(keys[left], mid)) {
                ++left;
                continue;
            }
            while (PageHelper.smaller(mid, keys[right])) {
                --right;
            }
            if (left <= right) {
                String tmp = keys[left];
                keys[left] = keys[right];
                keys[right] = tmp;
                Object tmp2 = values[left];
                values[left] = values[right];
                values[right] = tmp2;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            PageHelper.quickSort(keys, values, original_left, right);
        }
        if (left < original_right) {
            PageHelper.quickSort(keys, values, left, original_right);
        }
    }

    public static void quickSort(String[] keys, int left, int right) {
        if (keys == null || keys.length == 0) {
            return;
        }
        int original_left = left;
        int original_right = right;
        String mid = keys[(left + right) / 2];
        while (true) {
            if (PageHelper.smaller(keys[left], mid)) {
                ++left;
                continue;
            }
            while (PageHelper.smaller(mid, keys[right])) {
                --right;
            }
            if (left <= right) {
                String tmp = keys[left];
                keys[left] = keys[right];
                keys[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            PageHelper.quickSort(keys, original_left, right);
        }
        if (left < original_right) {
            PageHelper.quickSort(keys, left, original_right);
        }
    }

    public static String selectTypes(Shell shell, int style, String classType, boolean ignoreCase, boolean matchEmtpyString, boolean AllowProjectFiltering) {
        return PageHelper.selectTypes(shell, style, classType, fJavaProject);
    }

    public static String selectTypes(Shell shell, int style, String classType, IJavaProject aJavaProject) {
        return PageHelper.selectTypes(shell, style, classType, aJavaProject, false);
    }

    public static String selectTypes(Shell shell, int style, String classType, IJavaProject aJavaProject, boolean includeClasspaths) {
        IJavaSearchScope scope = null;
        SelectionDialog dialog = null;
        try {
            IType type = null;
            if (classType != null && aJavaProject != null) {
                type = PageHelper.findType(classType, aJavaProject.getProject());
            }
            scope = type != null ? (aJavaProject != null ? new ProjectHierarchyScope(type, aJavaProject) : SearchEngine.createHierarchyScope(type)) : (aJavaProject != null ? SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{aJavaProject}, (boolean)true) : SearchEngine.createWorkspaceScope());
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)scope, (int)style, (boolean)false, (String)"*");
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        dialog.setTitle(EJBCreationUIResourceHandler.Type_Selection_UI_);
        String msg = style == 4 ? EJBCreationUIResourceHandler.Select_an_Interface_UI_ : EJBCreationUIResourceHandler.Select_a_Class_UI_;
        msg = classType != null ? String.valueOf(msg) + " " + classType : String.valueOf(msg) + EJBCreationUIResourceHandler.any_UI_;
        dialog.setMessage(msg);
        if (dialog.open() == 1) {
            return null;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            return ((IType)types[0]).getFullyQualifiedName();
        }
        return null;
    }

    public static String selectTypes(Shell shell, int style, boolean ignoreCase, boolean matchEmtpyString) {
        return PageHelper.selectTypes(shell, style, null, ignoreCase, matchEmtpyString, true);
    }

    public static void setJavaProject(IJavaProject javaProject) {
        fJavaProject = javaProject;
    }

    private static boolean smaller(String left, String right) {
        return left.toLowerCase().compareTo(right.toLowerCase()) < 0;
    }

    public static boolean verifyCDATA(String stringText) {
        int i = 0;
        int n = stringText.length();
        while (i < n) {
            char ch = stringText.charAt(i);
            if (ch == '<' || ch == '>' || ch == '&') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean verifyJavaIdentifier(String identifier) {
        String s = identifier.trim();
        int i = 0;
        int n = s.length();
        while (i < n) {
            char ch = s.charAt(i);
            if (i == 0 ? !Character.isJavaIdentifierStart(ch) : !Character.isJavaIdentifierPart(ch)) {
                return false;
            }
            ++i;
        }
        return !PageHelper.isJavaKeyword(identifier);
    }

    public static boolean verifyJavaPackagePath(String path) {
        String s = path.trim();
        int i = 0;
        int n = s.length();
        while (i < n) {
            char ch = s.charAt(i);
            if (i == 0 ? !Character.isJavaIdentifierStart(ch) : (i == n - 1 ? !Character.isJavaIdentifierPart(ch) : ch != '.' && !Character.isJavaIdentifierPart(ch))) {
                return false;
            }
            ++i;
        }
        return !PageHelper.isJavaKeyword(path);
    }

    public static boolean verifyNMTOKEN(String stringText) {
        return NameValidator.isValid((String)stringText);
    }
}

