/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.creation.wizard;

import com.ibm.etools.common.ui.wizards.dialogs.SimpleDialog;
import com.ibm.etools.ejb.codegen.EJBGenHelpers;
import com.ibm.etools.ejb.creation.CMPField;
import com.ibm.etools.ejb.creation.ui.nls.EJBCreationUIResourceHandler;
import com.ibm.etools.ejb.creation.wizard.PageHelper;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jem.internal.adapters.jdom.JDOMSearchHelper;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jst.common.jdt.internal.integration.WorkingCopyProvider;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBRelationshipRole;
import org.eclipse.jst.j2ee.ejb.internal.util.CMPFieldDescriptor;
import org.eclipse.jst.j2ee.ejb.internal.util.CMPHelper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.internal.ui.TimedModifyListener;

public class CMPFieldDialog
extends SimpleDialog
implements ActionListener,
FocusListener {
    private static final int ADD_ID = 1025;
    private static final int CLOSE_ID = 1026;
    private static final int IS_ARRAY_ID = 1027;
    private static final int FIELD_TYPE_ID = 1028;
    private static final int KEY_ID = 1029;
    private static final int PROMOTE_ID = 1030;
    private static final int GETTERS_SETTERS_ID = 1031;
    private static final int PROMOTE_LOCAL_ID = 1032;
    private static final int BUTTON_WIDTH = 100;
    protected static final String[] nativeTypes = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Long", "java.lang.Integer", "java.lang.Short", "java.lang.String", "boolean", "byte", "char", "double", "float", "int", "long", "short", "java.math.BigDecimal", "java.net.URL", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp"};
    protected Text fieldNameText;
    protected Combo fieldNameCombo;
    protected Combo fieldTypeCombo;
    protected Button fieldTypeButton;
    protected Button addButton;
    protected Button isArrayCheckButton;
    protected Button keyFieldCheckButton;
    protected Button accessCheckButton;
    protected Button promoteCheckButton;
    protected Button getterReadOnlyCheckButton;
    protected Label dimensionLabel;
    protected Text dimensionText;
    protected Label messageLabel;
    protected boolean remainOpen = true;
    protected List fFields;
    protected List fAttributes;
    protected TableViewer fTable;
    protected boolean enableKey = true;
    protected CMPField result;
    protected boolean fieldNameOK = false;
    protected boolean fieldTypeOK = false;
    protected boolean arrayDimensionOK = false;
    protected boolean generatedBean = true;
    protected boolean firstTimeName = true;
    protected boolean firstTimeType = true;
    protected List errorWidgetList = new ArrayList();
    protected List errorMessageList = new ArrayList();
    public static final int NOT_BINARY = 0;
    public static final int BINARY_BEAN = 1;
    public static final int BINARY_HOME = 2;
    public static final int BINARY_REMOTE = 4;
    public static final int BINARY_KEY = 8;
    public static final int BINARY_LOCAL = 22;
    int binaryMode = 0;
    protected boolean is20Bean;
    private Button promoteLocalCheckButton;
    protected boolean wizardMode = false;
    protected String javaKeyType;
    protected boolean beanHasRemote;
    protected boolean beanHasLocal;
    private ContainerManagedEntity cmp;
    private List availableCMPDescriptors;
    private boolean isExistingField = false;
    private WorkingCopyProvider workingCopyProvider;

    public CMPFieldDialog(Shell shell, boolean isOpenedOn20Bean, boolean hasRemote, boolean hasLocal) {
        super(shell);
        this.is20Bean = isOpenedOn20Bean;
        this.beanHasRemote = hasRemote;
        this.beanHasLocal = hasLocal;
    }

    public CMPFieldDialog(Shell shell, ContainerManagedEntity aCMP, WorkingCopyProvider aProvider) {
        super(shell);
        this.workingCopyProvider = aProvider;
        this.initialize(aCMP);
    }

    protected CMPFieldDialog(Shell shell) {
        super(shell);
    }

    private void initialize(ContainerManagedEntity aCMP) {
        if (aCMP == null) {
            return;
        }
        this.cmp = aCMP;
        this.is20Bean = aCMP.getVersionID() >= 20;
        this.beanHasRemote = aCMP.getRemoteInterface() != null;
        this.beanHasLocal = aCMP.getLocalInterface() != null;
        this.availableCMPDescriptors = this.initializeAvailableCMPDescriptors(aCMP);
    }

    private CMPHelper.CMPFieldExistTester createCMPFieldTester() {
        return new CMPHelper.CMPFieldExistTester(){
            ICompilationUnit beanClass;

            public boolean isExisting(Field aField) {
                if (EJBGenHelpers.getType((JavaClass)aField.getContainingJavaClass()).isBinary()) {
                    return true;
                }
                this.initializeBeanClass(aField.getContainingJavaClass());
                if (this.beanClass != null) {
                    IType type = this.beanClass.findPrimaryType();
                    while (type != null) {
                        IField typeField = type.getField(aField.getName());
                        if (typeField != null && typeField.exists()) {
                            return true;
                        }
                        type = this.getSuperType(type);
                    }
                }
                return false;
            }

            public boolean isExisting(Method aMethod) {
                if (EJBGenHelpers.getType((JavaClass)aMethod.getContainingJavaClass()).isBinary()) {
                    return true;
                }
                this.initializeBeanClass(aMethod.getContainingJavaClass());
                if (this.beanClass != null) {
                    IType type = this.beanClass.findPrimaryType();
                    while (type != null) {
                        IMethod typeMeth = type.getMethod(aMethod.getName(), null);
                        if (typeMeth != null && typeMeth.exists()) {
                            return true;
                        }
                        type = this.getSuperType(type);
                    }
                }
                return false;
            }

            private void initializeBeanClass(JavaClass javaClass) {
                if (this.beanClass == null && CMPFieldDialog.this.workingCopyProvider != null) {
                    try {
                        this.beanClass = CMPFieldDialog.this.workingCopyProvider.getWorkingCopy(EJBGenHelpers.getCompilationUnit((JavaClass)javaClass), false);
                    }
                    catch (CoreException coreException) {}
                }
            }

            private IType getSuperType(IType aType) {
                if (aType != null) {
                    String superName = null;
                    try {
                        superName = aType.getSuperclassName();
                    }
                    catch (JavaModelException javaModelException) {}
                    if (superName != null) {
                        try {
                            superName = JDOMSearchHelper.resolveSimpleTypeName((IType)aType, (String)superName);
                            return aType.getJavaProject().findType(superName);
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                }
                return null;
            }
        };
    }

    private List initializeAvailableCMPDescriptors(ContainerManagedEntity aCMP) {
        List fields = CMPHelper.getAvailableCMPFieldDescriptors((ContainerManagedEntity)aCMP, (CMPHelper.CMPFieldExistTester)this.createCMPFieldTester());
        if (!fields.isEmpty()) {
            EList currentAtts = aCMP.getPersistentAttributes();
            List currentCMRs = null;
            if (aCMP.getVersionID() >= 20) {
                currentCMRs = aCMP.getRoles();
            }
            Iterator it = fields.iterator();
            boolean removed = false;
            while (it.hasNext()) {
                CMPFieldDescriptor descriptor = (CMPFieldDescriptor)it.next();
                int i = 0;
                while (i < currentAtts.size()) {
                    CMPAttribute att = (CMPAttribute)currentAtts.get(i);
                    if (att.getName().equals(descriptor.getName())) {
                        it.remove();
                        removed = true;
                    }
                    ++i;
                }
                if (removed || currentCMRs == null || currentCMRs.isEmpty()) continue;
                EJBRelationshipRole role = null;
                int i2 = 0;
                while (i2 < currentCMRs.size()) {
                    role = (EJBRelationshipRole)currentCMRs.get(i2);
                    if (role.getCmrField() != null && descriptor.getName().equals(role.getCmrField().getName())) {
                        it.remove();
                    }
                    ++i2;
                }
            }
        }
        return fields;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Widget source = (Widget)e.getSource();
            if (source == this.fieldTypeCombo && !this.fieldTypeCombo.isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!CMPFieldDialog.this.fieldTypeCombo.isDisposed()) {
                            CMPFieldDialog.this.validateControls();
                            CMPFieldDialog.this.enableKeySelection();
                        }
                    }
                });
            }
        }
        catch (Throwable err) {
            J2EEUIPlugin.logError(err);
        }
    }

    protected void addCMPFieldToDisplayTable() {
        if (this.fTable != null && this.result != null) {
            this.fTable.add((Object)this.result);
        }
    }

    protected void addPressed() {
        this.setupResultCMPField();
        this.getFields().add(this.result);
        this.addCMPFieldToDisplayTable();
        this.result = null;
        this.initializeWidgets();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.addPressed();
                return;
            }
            case 1026: {
                this.cancelPressed();
                return;
            }
            case 1027: {
                this.handleIsArrayCheckButtonPressed();
                return;
            }
            case 1031: {
                this.handleGenerateGettersAndSettersButtonPressed();
                return;
            }
            case 1028: {
                this.handleFieldTypeButtonPressed();
                return;
            }
            case 1029: {
                this.handleKeyFieldCheckButtonPressed();
                return;
            }
            case 1030: {
                this.handlePromoteCheckButtonPressed();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public void create() {
        super.create();
        this.setInitialFocus();
    }

    protected void createAddCloseButtons(Composite theParent) {
        this.addButton = this.createButton(theParent, 1025, EJBCreationUIResourceHandler._And_Apply_UI_, true);
        GridData bGrid = new GridData(768);
        bGrid.grabExcessHorizontalSpace = true;
        bGrid.widthHint = 100;
        this.addButton.setLayoutData((Object)bGrid);
        this.createButton(theParent, 1026, IDialogConstants.CLOSE_LABEL, false);
        this.addButton.setEnabled(false);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = new Button(parent, 8);
        GridData gridData = new GridData(768);
        button.setLayoutData((Object)gridData);
        button.setText(label);
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CMPFieldDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(128));
        this.createButtonsForButtonBar(composite);
        this.enableAddButton();
        return composite;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        if (this.shouldRemainOpen()) {
            this.createAddCloseButtons(parent);
        } else {
            this.createOkCancelButtons(parent);
        }
    }

    protected Button createCheckButton(Composite parent, int id, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CMPFieldDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        return button;
    }

    protected void createControlsFieldGenOptions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 10;
        composite.setLayoutData((Object)gridData);
        this.keyFieldCheckButton = this.createCheckButton(composite, 1029, EJBCreationUIResourceHandler._And_Key_field_UI_);
        this.keyFieldCheckButton.setEnabled(this.enableKey);
        if (!this.is20Bean) {
            this.accessCheckButton = this.createCheckButton(composite, 1031, EJBCreationUIResourceHandler.Access_with__And_getter_and_se_UI_);
        }
        this.promoteCheckButton = this.createCheckButton(composite, 1030, EJBCreationUIResourceHandler._And_Promote_getter_and_setter_UI_);
        if (this.is20Bean) {
            this.promoteLocalCheckButton = this.createCheckButton(composite, 1032, EJBCreationUIResourceHandler.Promote_getter_and_setter_methods_to_local_interface_18);
        } else {
            this.getterReadOnlyCheckButton = new Button(composite, 32);
            this.getterReadOnlyCheckButton.setText(EJBCreationUIResourceHandler.Make_getter_read_only_UI_);
            this.getterReadOnlyCheckButton.setEnabled(false);
        }
        if (this.isBinaryMode()) {
            this.promoteCheckButton.setEnabled(this.beanHasRemote && !this.isBinaryRemote() && !this.keyFieldCheckButton.getSelection());
            if (this.is20Bean) {
                this.promoteLocalCheckButton.setEnabled(this.beanHasLocal && !this.isBinaryLocal() && !this.keyFieldCheckButton.getSelection());
            } else {
                this.accessCheckButton.setEnabled(!this.isBinaryBean() && !this.keyFieldCheckButton.getSelection());
            }
        }
    }

    protected void createControlsFieldNameAndType(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this.createControlsFieldName(composite);
        Label label = new Label(composite, 0);
        label.setText("");
        label = new Label(composite, 0);
        label.setText(EJBCreationUIResourceHandler.Type__UI_);
        this.fieldTypeCombo = new Combo(composite, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 280;
        this.fieldTypeCombo.setLayoutData((Object)gridData);
        this.fieldTypeCombo.setItems(nativeTypes);
        this.fieldTypeCombo.addFocusListener((FocusListener)this);
        TimedModifyListener timedListener = new TimedModifyListener((ActionListener)this);
        this.fieldTypeCombo.addListener(24, (Listener)new TypedListener((SWTEventListener)timedListener));
        this.fieldTypeButton = this.createButton(composite, 1028, EJBCreationUIResourceHandler.Browse____UI_, false);
        if (this.isBinaryBean()) {
            if (this.wizardMode) {
                this.setFieldNameEnabled(false);
            }
            this.fieldTypeCombo.setEnabled(false);
            this.fieldTypeButton.setEnabled(false);
        }
    }

    protected void createControlsFieldName(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(EJBCreationUIResourceHandler.Name__UI_);
        if (this.getAvailableCMPDescriptors().isEmpty() && (!this.isBinaryBean() || this.wizardMode)) {
            this.createFieldNameText(composite);
        } else {
            this.createFieldNameCombo(composite, this.isBinaryBean());
        }
    }

    protected void createFieldNameText(Composite composite) {
        this.fieldNameText = new Text(composite, 2052);
        GridData gridData = new GridData(768);
        this.fieldNameText.setLayoutData((Object)gridData);
        this.fieldNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CMPFieldDialog.this.validateControls();
            }
        });
        this.fieldNameText.addFocusListener((FocusListener)this);
    }

    protected void createFieldNameCombo(Composite composite, boolean isBinaryBean) {
        this.fieldNameCombo = isBinaryBean ? new Combo(composite, 2056) : new Combo(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 280;
        this.fieldNameCombo.setLayoutData((Object)gridData);
        this.fieldNameCombo.setItems(this.getAvailableFieldNames());
        this.fieldNameCombo.addFocusListener((FocusListener)this);
        this.fieldNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CMPFieldDialog.this.validateControls();
            }
        });
        this.fieldNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CMPFieldDialog.this.handleFieldNameComboSelectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fieldNameCombo.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                CMPFieldDialog.this.handleFieldNameComboTyped();
            }
        });
    }

    private void handleFieldNameComboTyped() {
        String name = this.getFieldName();
        if (name.length() > 0) {
            CMPFieldDescriptor desc = null;
            int i = 0;
            while (i < this.availableCMPDescriptors.size()) {
                desc = (CMPFieldDescriptor)this.availableCMPDescriptors.get(i);
                if (name.equals(desc.getName())) break;
                desc = null;
                ++i;
            }
            if (desc != null) {
                this.fieldTypeCombo.setText(desc.getType());
            }
            boolean wasExistingField = this.isExistingField;
            this.isExistingField = desc != null;
            this.enableAllForExistingField(desc == null, wasExistingField);
        }
    }

    private void handleFieldNameComboSelectionChanged() {
        int index = this.fieldNameCombo.getSelectionIndex();
        CMPFieldDescriptor desc = (CMPFieldDescriptor)this.getAvailableCMPDescriptors().get(index);
        this.fieldTypeCombo.setText(desc.getType());
        this.isExistingField = true;
        this.enableAllForExistingField(false, true);
    }

    private void enableAllForExistingField(boolean enabled, boolean forceKeyRefresh) {
        boolean isExistingKey;
        this.fieldTypeCombo.setEnabled(enabled);
        this.fieldTypeButton.setEnabled(enabled);
        this.isArrayCheckButton.setEnabled(enabled);
        this.keyFieldCheckButton.setEnabled(enabled);
        boolean bl = isExistingKey = !enabled && this.isExistingFieldKey();
        if (!enabled || forceKeyRefresh) {
            this.keyFieldCheckButton.setSelection(isExistingKey);
            this.handleKeyFieldCheckButtonPressed();
        }
        if (enabled) {
            if (this.isArrayCheckButton.getSelection()) {
                this.dimensionLabel.setEnabled(enabled);
                this.dimensionText.setEnabled(enabled);
            }
        } else {
            this.isArrayCheckButton.setSelection(false);
            this.dimensionLabel.setEnabled(enabled);
            this.dimensionText.setEnabled(enabled);
        }
        if (this.accessCheckButton != null) {
            this.accessCheckButton.setEnabled(enabled);
        }
        if (this.beanHasRemote && !this.isBinaryRemote()) {
            if (enabled && !this.keyFieldCheckButton.getSelection()) {
                this.promoteCheckButton.setEnabled(enabled);
            } else {
                this.promoteCheckButton.setEnabled(enabled);
            }
        }
        if (this.beanHasLocal && !this.isBinaryLocal()) {
            if (enabled && !this.keyFieldCheckButton.getSelection()) {
                this.promoteLocalCheckButton.setEnabled(enabled);
            } else {
                this.promoteLocalCheckButton.setEnabled(enabled);
            }
        }
    }

    private boolean isExistingFieldKey() {
        if (this.cmp == null) {
            return false;
        }
        JavaClass primaryKeyClass = this.cmp.getPrimaryKey();
        if (primaryKeyClass == null) {
            return false;
        }
        return primaryKeyClass.getField(this.fieldNameCombo.getText()) != null;
    }

    private String[] getAvailableFieldNames() {
        int size = this.getAvailableCMPDescriptors().size();
        String[] result = new String[size];
        CMPFieldDescriptor descriptor = null;
        int i = 0;
        while (i < size) {
            descriptor = (CMPFieldDescriptor)this.availableCMPDescriptors.get(i);
            result[i] = descriptor.getName();
            ++i;
        }
        return result;
    }

    private void setFieldNameEnabled(boolean aBoolean) {
        if (this.fieldNameText != null) {
            this.fieldNameText.setEnabled(aBoolean);
        } else if (this.fieldNameCombo != null) {
            this.fieldNameCombo.setEnabled(aBoolean);
        }
    }

    protected void createControlsIsArray(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 10;
        composite.setLayoutData((Object)gridData);
        this.isArrayCheckButton = this.createCheckButton(composite, 1027, EJBCreationUIResourceHandler.A_And_rray__UI_);
        this.dimensionLabel = new Label(composite, 0);
        this.dimensionLabel.setText(EJBCreationUIResourceHandler.Dimension__UI_);
        this.dimensionText = new Text(composite, 2048);
        gridData = new GridData(32);
        gridData.widthHint = 30;
        this.dimensionText.setLayoutData((Object)gridData);
        this.dimensionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CMPFieldDialog.this.validateArrayDimension();
            }
        });
        if (this.isBinaryBean()) {
            this.isArrayCheckButton.setEnabled(false);
        }
    }

    protected void createControlsMessageText(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(272);
        composite.setLayoutData((Object)data);
        Label emptyLabel = new Label(composite, 0);
        this.messageLabel = new Label(composite, 16384);
        data = new GridData(768);
        this.messageLabel.setLayoutData((Object)data);
        this.messageLabel.setBackground(emptyLabel.getBackground());
        this.messageLabel.setForeground(this.messageLabel.getDisplay().getSystemColor(3));
    }

    @Override
    public Control createTopLevelComposite(Composite parent) {
        this.setTitle(EJBCreationUIResourceHandler.Create_CMP_Attribute_UI_);
        this.getShell().setText(EJBCreationUIResourceHandler.CMP_Attribute_UI_);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createControlsFieldNameAndType(composite);
        this.createControlsIsArray(composite);
        this.createControlsFieldGenOptions(composite);
        this.initializeWidgets();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.j2ee.ui.ADD_CMP_ATTRIBUTE");
        return composite;
    }

    protected void createOkCancelButtons(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        GridData bGrid = new GridData(768);
        bGrid.grabExcessHorizontalSpace = true;
        bGrid.widthHint = 100;
        this.okButton.setLayoutData((Object)bGrid);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void enableAddButton() {
        boolean shouldEnable;
        boolean arrayOK = !this.isArrayCheckButton.getSelection() || this.isArrayCheckButton.getSelection() && this.arrayDimensionOK;
        boolean bl = shouldEnable = this.fieldNameOK && this.fieldTypeOK && arrayOK;
        if (this.addButton != null) {
            this.addButton.setEnabled(shouldEnable);
        } else if (this.okButton != null) {
            this.okButton.setEnabled(shouldEnable);
        }
    }

    protected IType findFieldType() {
        if (PageHelper.getJavaProject() == null) {
            return null;
        }
        String typeName = this.fieldTypeCombo.getText();
        if (typeName.trim().length() == 0) {
            return null;
        }
        IType type = PageHelper.findType(typeName);
        if (type != null) {
            return type;
        }
        if (!this.isQualified(typeName)) {
            typeName = "java.lang." + typeName;
            return PageHelper.findType(typeName);
        }
        return null;
    }

    protected IType findType(String aFieldType) {
        if (PageHelper.getJavaProject() == null) {
            return null;
        }
        String typeName = aFieldType;
        if (typeName.trim().length() == 0) {
            return null;
        }
        IType type = PageHelper.findType(typeName);
        return type;
    }

    public void focusGained(FocusEvent event) {
        Object widget = event.getSource();
        this.showErrorMessageForWidget(widget);
    }

    public void focusLost(FocusEvent event) {
    }

    public List getFAttributes() {
        return this.fAttributes;
    }

    List getFields() {
        if (this.fFields == null) {
            this.fFields = new ArrayList();
        }
        return this.fFields;
    }

    public CMPField getResult() {
        return this.result;
    }

    protected void handleFieldTypeButtonPressed() {
        int style = 6;
        String typeName = PageHelper.selectTypes(this.getShell(), style, true, true);
        if (typeName != null) {
            this.fieldTypeCombo.setText(typeName);
        }
    }

    protected void handleIsArrayCheckButtonPressed() {
        boolean selected = this.isArrayCheckButton.getSelection();
        this.dimensionLabel.setEnabled(selected);
        this.dimensionText.setEnabled(selected);
        if (!selected) {
            this.dimensionText.setText("1");
        }
        this.enableAddButton();
    }

    protected void handleKeyFieldCheckButtonPressed() {
        boolean accessEnable;
        boolean bl = accessEnable = !this.keyFieldCheckButton.getSelection() && !this.isBinaryBean();
        if (this.beanHasRemote) {
            this.promoteCheckButton.setEnabled(!this.isBinaryRemote());
            this.promoteCheckButton.setSelection(!this.isBinaryRemote());
        }
        if (this.beanHasLocal) {
            this.promoteLocalCheckButton.setEnabled(!this.isBinaryLocal());
            this.promoteLocalCheckButton.setSelection(!this.isBinaryLocal());
        }
        if (!this.is20Bean) {
            this.accessCheckButton.setEnabled(accessEnable);
            this.accessCheckButton.setSelection(accessEnable);
            this.getterReadOnlyCheckButton.setEnabled(!this.keyFieldCheckButton.getSelection() && !this.isBinaryRemote());
            this.getterReadOnlyCheckButton.setSelection(!this.keyFieldCheckButton.getSelection() && !this.isBinaryRemote());
            this.promoteCheckButton.setEnabled(!this.keyFieldCheckButton.getSelection() && !this.isBinaryRemote());
            this.promoteCheckButton.setSelection(!this.keyFieldCheckButton.getSelection() && !this.isBinaryRemote());
        }
    }

    protected void handleGenerateGettersAndSettersButtonPressed() {
        boolean generate = true;
        if (!this.is20Bean) {
            generate = this.accessCheckButton.getSelection();
        }
        if (this.beanHasRemote) {
            this.promoteCheckButton.setEnabled(generate);
            this.promoteCheckButton.setSelection(generate);
        }
        if (this.beanHasLocal && this.is20Bean) {
            this.promoteLocalCheckButton.setEnabled(generate);
            this.promoteLocalCheckButton.setSelection(generate);
        }
        if (!this.is20Bean) {
            this.getterReadOnlyCheckButton.setEnabled(generate);
            this.getterReadOnlyCheckButton.setSelection(generate);
        }
    }

    protected void handlePromoteCheckButtonPressed() {
        if (!this.is20Bean) {
            this.getterReadOnlyCheckButton.setSelection(this.promoteCheckButton.getSelection());
            this.getterReadOnlyCheckButton.setEnabled(this.promoteCheckButton.getEnabled() && this.promoteCheckButton.getSelection());
        }
    }

    private void initializeWidgetsForNewField() {
        this.setFieldName("");
        this.fieldTypeCombo.setText("");
        this.isArrayCheckButton.setSelection(false);
        this.dimensionLabel.setEnabled(false);
        this.dimensionText.setEnabled(false);
        this.dimensionText.setText("1");
        this.keyFieldCheckButton.setSelection(false);
        if (this.accessCheckButton != null) {
            this.accessCheckButton.setSelection(false);
        }
        this.promoteCheckButton.setSelection(false);
        if (this.promoteLocalCheckButton != null) {
            this.promoteLocalCheckButton.setSelection(false);
        }
    }

    private void initializeWidgetsForEdit(CMPField cmpField) {
        if (this.fieldNameText != null) {
            this.fieldNameText.setText(cmpField.getName());
        }
        this.fieldTypeCombo.setText(cmpField.getType());
        this.isArrayCheckButton.setSelection(cmpField.isIsArray());
        if (cmpField.isIsArray()) {
            this.dimensionLabel.setEnabled(true);
            this.dimensionText.setEnabled(true);
            this.dimensionText.setText(String.valueOf(cmpField.getArrayDimension()));
        } else {
            this.dimensionLabel.setEnabled(false);
            this.dimensionText.setEnabled(false);
            this.dimensionText.setText("1");
        }
        this.keyFieldCheckButton.setSelection(cmpField.isIsKey());
        this.promoteCheckButton.setSelection(cmpField.isPromoteGS());
        if (this.is20Bean) {
            if (this.beanHasLocal) {
                this.promoteLocalCheckButton.setSelection(cmpField.isPromoteLocalGS());
            }
        } else {
            if (this.accessCheckButton != null) {
                this.accessCheckButton.setSelection(cmpField.isAccessWithGS());
            }
            this.promoteCheckButton.setEnabled(this.beanHasRemote && !this.isBinaryRemote() && !cmpField.isIsKey());
            this.getterReadOnlyCheckButton.setEnabled(this.promoteCheckButton.getEnabled());
        }
    }

    private void initializeWidgetEnablementAndSelections(CMPField cmpField, boolean selectionsSet) {
        boolean promoteEnable;
        boolean bl = promoteEnable = this.beanHasRemote && !this.isBinaryRemote();
        if (this.is20Bean) {
            this.promoteCheckButton.setEnabled(promoteEnable);
            boolean promoteLccalEnable = this.beanHasLocal && !this.isBinaryLocal();
            this.promoteLocalCheckButton.setEnabled(promoteLccalEnable);
            if (!selectionsSet) {
                this.promoteLocalCheckButton.setSelection(promoteLccalEnable);
                this.promoteCheckButton.setSelection(promoteEnable);
            }
        } else {
            boolean accessEnable;
            boolean bl2 = accessEnable = !this.keyFieldCheckButton.getSelection() && (!this.isBinaryBean() || this.isGeneratedBean());
            if (this.accessCheckButton != null) {
                this.accessCheckButton.setEnabled(accessEnable);
            }
            if (!this.keyFieldCheckButton.getSelection()) {
                this.promoteCheckButton.setEnabled(promoteEnable);
            }
            this.getterReadOnlyCheckButton.setEnabled(this.promoteCheckButton.getEnabled());
            if (!selectionsSet) {
                if (this.accessCheckButton != null) {
                    this.accessCheckButton.setSelection(accessEnable);
                }
                this.promoteCheckButton.setSelection(promoteEnable);
                this.getterReadOnlyCheckButton.setSelection(promoteEnable);
            } else {
                this.getterReadOnlyCheckButton.setSelection(cmpField.isGetterRO());
            }
        }
    }

    protected void initializeWidgets() {
        boolean selectionsSet = false;
        CMPField cmpField = this.result;
        if (cmpField == null) {
            this.initializeWidgetsForNewField();
        } else {
            selectionsSet = true;
            this.initializeWidgetsForEdit(cmpField);
        }
        this.initializeWidgetEnablementAndSelections(cmpField, selectionsSet);
        this.setInitialFocus();
    }

    protected void setFieldName(String s) {
        if (this.fieldNameText != null) {
            this.fieldNameText.setText(s);
        } else if (this.fieldNameCombo != null) {
            this.fieldNameCombo.setText(s);
        }
    }

    public boolean isBinaryBean() {
        return (this.binaryMode & 1) > 0;
    }

    public boolean isBinaryHome() {
        return (this.binaryMode & 2) > 0;
    }

    public boolean isBinaryKey() {
        return (this.binaryMode & 8) > 0;
    }

    public boolean isBinaryMode() {
        return this.binaryMode > 0;
    }

    public boolean isBinaryRemote() {
        return (this.binaryMode & 4) > 0;
    }

    public boolean isBinaryLocal() {
        return (this.binaryMode & 0x16) > 0;
    }

    public boolean isEnableKey() {
        return this.enableKey;
    }

    public boolean isGeneratedBean() {
        return this.generatedBean;
    }

    protected boolean isPrimitiveType(String typeName) {
        if (typeName.trim().length() == 0) {
            return false;
        }
        int i = 0;
        int n = nativeTypes.length;
        while (i < n) {
            if (nativeTypes[i].equals(typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isQualified(String typeName) {
        return typeName.indexOf(".") != -1;
    }

    protected void okPressed() {
        this.setupResultCMPField();
        if (this.fTable != null) {
            this.fTable.refresh((Object)this.result);
        }
        super.okPressed();
    }

    public int open(Shell parent, List fields, TableViewer table, boolean enableKey, CMPField field, String javaKeyType, boolean wizardMode) {
        this.enter();
        this.fFields = fields;
        this.fTable = table;
        this.result = field;
        this.enableKey = enableKey;
        this.javaKeyType = javaKeyType;
        this.wizardMode = wizardMode;
        return this.open();
    }

    protected void resetErrorMessageForWidget(Object widget) {
        int index = -1;
        int i = 0;
        int n = this.errorWidgetList.size();
        while (i < n) {
            if (this.errorWidgetList.get(i).equals(widget)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            this.errorWidgetList.remove(index);
            this.errorMessageList.remove(index);
        }
    }

    public void setBinaryMode(int newBinaryMode) {
        this.binaryMode = newBinaryMode;
        if (newBinaryMode > 0) {
            this.generatedBean = false;
        }
    }

    public void setEnableKey(boolean newEnableKey) {
        this.enableKey = newEnableKey;
    }

    public void setFAttributes(List newFAttributes) {
        this.fAttributes = newFAttributes;
    }

    public void setGeneratedBean(boolean newGeneratedBean) {
        this.generatedBean = newGeneratedBean;
    }

    protected void setInitialFocus() {
        if (this.fieldNameText != null) {
            this.fieldNameText.setFocus();
        } else if (this.fieldNameCombo != null) {
            this.fieldNameCombo.setFocus();
        }
    }

    public void setRemainOpen(boolean newRemainOpen) {
        this.remainOpen = newRemainOpen;
    }

    public void setResult(CMPField newResult) {
        this.result = newResult;
    }

    protected void setupResultCMPField() {
        if (this.result == null) {
            this.result = new CMPField();
        }
        this.result.setName(this.getFieldName());
        this.result.setExisting(this.isExistingField);
        this.result.setType(this.getFieldTypeName());
        this.result.setIsArray(this.isArrayCheckButton.getSelection());
        if (this.isArrayCheckButton.getSelection()) {
            this.result.setArrayDimension(this.getArrayDimensionsAsInt());
        }
        this.result.setInitialValue("");
        this.result.setIsKey(this.keyFieldCheckButton.getSelection());
        this.result.setAccessWithGS(this.is20Bean || this.accessCheckButton.getSelection());
        if (this.beanHasRemote) {
            this.result.setPromoteGS(this.promoteCheckButton.getSelection());
        }
        if (!this.is20Bean) {
            this.result.setGetterRO(this.getterReadOnlyCheckButton.getSelection());
        } else if (this.beanHasLocal) {
            this.result.setPromoteLocalGS(this.promoteLocalCheckButton.getSelection());
        }
    }

    protected int getArrayDimensionsAsInt() {
        return Integer.parseInt(this.dimensionText.getText());
    }

    protected String getFieldTypeName() {
        String text = this.fieldTypeCombo.getText().trim();
        if (!this.isPrimitiveType(text) && !this.isQualified(text)) {
            text = "java.lang." + text;
        }
        return text;
    }

    protected String getFieldName() {
        if (this.fieldNameText != null) {
            return this.fieldNameText.getText();
        }
        if (this.fieldNameCombo != null) {
            return this.fieldNameCombo.getText();
        }
        return "";
    }

    public boolean shouldRemainOpen() {
        return this.remainOpen;
    }

    protected void showErrorMessageForWidget(Object widget) {
        int n = this.errorWidgetList.size();
        if (n == 0) {
            this.setErrorStatus("");
            return;
        }
        int index = -1;
        int i = 0;
        while (i < n) {
            if (this.errorWidgetList.get(i).equals(widget)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            this.setErrorStatus((String)this.errorMessageList.get(index));
        } else {
            this.setErrorStatus((String)this.errorMessageList.get(n - 1));
        }
    }

    protected void validateArrayDimension() {
        this.arrayDimensionOK = true;
        this.resetErrorMessageForWidget(this.dimensionText);
        if (this.isArrayCheckButton.getSelection()) {
            int d = -1;
            try {
                d = Integer.parseInt(this.dimensionText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.errorWidgetList.add(this.dimensionText);
                this.errorMessageList.add(EJBCreationUIResourceHandler.Enter_a_valid_number_of_ar_UI_);
                this.arrayDimensionOK = false;
                this.dimensionText.setFocus();
            }
            if (this.arrayDimensionOK && (d < 1 || d > 10)) {
                this.errorWidgetList.add(this.dimensionText);
                this.errorMessageList.add(EJBCreationUIResourceHandler.Enter_a_valid_number_of_ar_UI_);
                this.arrayDimensionOK = false;
                this.dimensionText.setFocus();
            }
            if (this.arrayDimensionOK) {
                this.resetErrorMessageForWidget(this.dimensionText);
            }
        }
        this.showErrorMessageForWidget(this.dimensionText);
        this.enableAddButton();
    }

    protected void validateFieldName() {
        IStatus status;
        int i;
        this.fieldNameOK = true;
        String contents = this.getFieldName();
        this.resetErrorMessageForWidget(this.getFieldNameControl());
        if (!contents.equals("")) {
            this.firstTimeName = false;
        }
        if (contents.equals("") && this.firstTimeName) {
            this.errorWidgetList.add(this.getFieldNameControl());
            this.errorMessageList.add("");
            this.fieldNameOK = false;
        } else if (contents.equals("") && !this.firstTimeName) {
            this.errorWidgetList.add(this.getFieldNameControl());
            this.errorMessageList.add(EJBCreationUIResourceHandler.Name_of_field_must_be_entered_UI_);
            this.fieldNameOK = false;
        }
        if (this.fieldNameOK) {
            i = 0;
            while (i < this.getFields().size()) {
                CMPField field = (CMPField)this.getFields().get(i);
                if (field != this.result && contents.equals(field.getName())) {
                    this.errorWidgetList.add(this.getFieldNameControl());
                    this.errorMessageList.add(NLS.bind((String)EJBCreationUIResourceHandler.Field_name_ERROR_UI_, (Object[])new Object[]{contents}));
                    this.fieldNameOK = false;
                }
                ++i;
            }
        }
        if (this.fieldNameOK && this.getFAttributes() != null) {
            i = 0;
            while (i < this.getFAttributes().size()) {
                CMPAttribute att = (CMPAttribute)this.getFAttributes().get(i);
                if ((this.result == null || this.result.getName() == null || !this.result.getName().equals(att.getName())) && contents.equals(att.getName())) {
                    this.errorWidgetList.add(this.getFieldNameControl());
                    this.errorMessageList.add(EJBCreationUIResourceHandler.The_field_with_the_same_na_UI_);
                    this.fieldNameOK = false;
                }
                ++i;
            }
        }
        if (this.fieldNameOK && this.cmp != null) {
            List cmrFields = this.cmp.getCMRFields();
            i = 0;
            while (i < cmrFields.size()) {
                if (contents.equals(((CMPAttribute)cmrFields.get(0)).getName())) {
                    this.errorWidgetList.add(this.getFieldNameControl());
                    this.errorMessageList.add(EJBCreationUIResourceHandler.FIELD_NAME_COLLIDES_WITH_CMR);
                    this.fieldNameOK = false;
                }
                ++i;
            }
        }
        if (this.fieldNameOK && this.is20Bean && Character.isUpperCase(contents.charAt(0))) {
            this.errorWidgetList.add(this.getFieldNameControl());
            this.errorMessageList.add(EJBCreationUIResourceHandler.FIELD_VAL_UPPER_ERROR_UI_);
            this.fieldNameOK = false;
        }
        if (this.fieldNameOK && !(status = JavaConventions.validateFieldName((String)contents)).isOK()) {
            this.errorWidgetList.add(this.getFieldNameControl());
            this.errorMessageList.add(NLS.bind((String)EJBCreationUIResourceHandler.is_not_a_valid_Java_indentifier_UI_, (Object[])new Object[]{contents}));
            this.fieldNameOK = false;
        }
        this.showErrorMessageForWidget(this.getFieldNameControl());
        this.enableAddButton();
    }

    protected void setFieldNameFocus() {
        Control control = this.getFieldNameControl();
        if (control != null) {
            control.setFocus();
        }
    }

    protected Control getFieldNameControl() {
        if (this.fieldNameText != null) {
            return this.fieldNameText;
        }
        return this.fieldNameCombo;
    }

    protected void validateFieldType() {
        this.fieldTypeOK = true;
        this.resetErrorMessageForWidget(this.fieldTypeCombo);
        String fieldTypeString = this.fieldTypeCombo.getText();
        if (fieldTypeString.trim().length() == 0) {
            if (!this.firstTimeType && this.fieldNameOK) {
                this.errorWidgetList.add(this.fieldTypeCombo);
                this.errorMessageList.add(EJBCreationUIResourceHandler.Type_of_field_must_be_selected_UI_);
            }
            this.fieldTypeOK = false;
        } else {
            this.firstTimeType = false;
            if (fieldTypeString.endsWith("[]")) {
                fieldTypeString = fieldTypeString.substring(0, fieldTypeString.indexOf("[]"));
            }
            if (!Arrays.asList(nativeTypes).contains(fieldTypeString)) {
                IStatus status = JavaConventions.validateJavaTypeName((String)fieldTypeString);
                if (status.getMessage().equals(Messages.convention_type_lowercaseName) && status.getSeverity() == 4) {
                    this.errorWidgetList.add(this.fieldTypeCombo);
                    this.errorMessageList.add(status.getMessage());
                    this.fieldTypeOK = false;
                } else {
                    IType type = this.findType(fieldTypeString);
                    boolean isqualified = this.isQualified(fieldTypeString);
                    if (isqualified) {
                        if (type == null) {
                            this.errorWidgetList.add(this.fieldTypeCombo);
                            this.errorMessageList.add(EJBCreationUIResourceHandler.Message_type_not_exists_UI_);
                            this.fieldTypeOK = false;
                        }
                    } else {
                        String qualifiedTypeName = this.getQualifiedTypeName(fieldTypeString);
                        IType theType = this.findType(qualifiedTypeName);
                        if (theType == null) {
                            if (type != null) {
                                this.errorWidgetList.add(this.fieldTypeCombo);
                                this.errorMessageList.add(EJBCreationUIResourceHandler.The_attribute_type_cannot_be_of_type_that_exists_in_the_project_default_folder_20);
                                this.fieldTypeOK = false;
                            } else {
                                this.errorWidgetList.add(this.fieldTypeCombo);
                                this.errorMessageList.add(EJBCreationUIResourceHandler.Enter_the_fully_qualified_name_of_the_attribute_type_21);
                                this.fieldTypeOK = false;
                            }
                        } else {
                            this.fieldTypeCombo.setText(qualifiedTypeName);
                        }
                    }
                }
            }
        }
        this.showErrorMessageForWidget(this.fieldTypeCombo);
        this.enableAddButton();
    }

    private String getQualifiedTypeName(String fieldTypeString) {
        int i = 0;
        while (i < nativeTypes.length) {
            String typeName = nativeTypes[i];
            if (("java.lang." + fieldTypeString).equals(typeName)) {
                return typeName;
            }
            if (("java.math." + fieldTypeString).equals(typeName)) {
                return typeName;
            }
            if (("java.net." + fieldTypeString).equals(typeName)) {
                return typeName;
            }
            if (("java.sql." + fieldTypeString).equals(typeName)) {
                return typeName;
            }
            ++i;
        }
        return fieldTypeString;
    }

    public boolean checkIfFieldTypeInDefaultPackage(String attributeType) {
        JavaClass jclass = JavaRefFactory.eINSTANCE.createClassRef(attributeType);
        String refClassName = jclass.getQualifiedName();
        char[] charArray = refClassName.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (charArray[i] == '.') {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void enableKeySelection() {
        if (this.keyFieldCheckButton == null) {
            return;
        }
    }

    public List getAvailableCMPDescriptors() {
        if (this.availableCMPDescriptors == null) {
            this.availableCMPDescriptors = Collections.EMPTY_LIST;
        }
        return this.availableCMPDescriptors;
    }

    @Override
    protected void validateControls() {
        this.validateFieldName();
        this.validateFieldType();
    }

    @Override
    protected void setPageComplete(boolean comp) {
    }
}

