/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.creation.model.wizard;

import com.ibm.etools.ejb.creation.ui.nls.EJBCreationUIResourceHandler;
import com.ibm.etools.j2ee.ui.nls.UIResourceHandler;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.ejb.ui.project.facet.EjbProjectWizard;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.wizard.AnnotationsStandaloneGroup;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;

public class EJBBasicPropertiesComposite {
    private static String SOURCE_FOLDER_SETTING = "EJBBasicPropertiesComposite.sourceFolderName";
    private static String PACKAGE_NAME_SETTING = "EJBBasicPropertiesComposite.packageName";
    private static String USE_ANNOTATIONS = "EJBBasicPropertiesComposite.useAnnotations";
    private IDataModel model;
    private DataModelSynchHelper synchHelper;
    private Text beanNameText;
    private Composite parent;
    private AnnotationsStandaloneGroup annotationsGroup;
    private Combo ejbComponentCombo;

    public EJBBasicPropertiesComposite(Composite parent, IDataModel model) {
        this.model = model;
        this.parent = parent;
        this.synchHelper = new DataModelSynchHelper(model);
        this.createContents();
    }

    private void createContents() {
        boolean allowProjectChg = this.model.getBooleanProperty("ICreateEnterpriseBeanDataModelProperties.allowProjectChange");
        if (allowProjectChg) {
            this.createSelectableEJBProjectControls();
        } else {
            this.createReadOnlyEJBProjectControls();
        }
        this.createBeanNameControls();
        this.createPackageRootControls();
        this.createDefaultPackageControls();
        this.createCMPVersionComposite();
        this.createAnnotationsGroup();
    }

    private void createCMPVersionComposite() {
        if (this.model.getID().equals("new_ejb_creation") || this.model.getIntProperty("ICreateEnterpriseBeanDataModelProperties.getEJBType") == 3) {
            final Label label = new Label(this.parent, 0);
            label.setLayoutData((Object)new GridData());
            label.setText(EJBCreationUIResourceHandler.CMPVersion);
            final Combo combo = new Combo(this.parent, 12);
            if (this.model.getBooleanProperty("NewEJBCreationWizardDataProvider.useCMP")) {
                this.synchHelper.synchCombo(combo, "ICreateCMPBeanDataModelProperties.CMP_VERSION", null);
            }
            combo.setFont(JFaceResources.getDialogFont());
            PixelConverter converter = new PixelConverter((Control)combo);
            GridData data = new GridData();
            data.widthHint = converter.convertWidthInCharsToPixels(8);
            data.horizontalSpan = 2;
            combo.setLayoutData((Object)data);
            this.model.addListener(new IDataModelListener(){

                public void propertyChanged(DataModelEvent event) {
                    String prop = event.getPropertyName();
                    if (prop.equals("NewEJBCreationWizardDataProvider.useCMP")) {
                        Control[] cntr = new Control[]{label};
                        EJBBasicPropertiesComposite.this.synchHelper.synchCombo(combo, "ICreateCMPBeanDataModelProperties.CMP_VERSION", cntr);
                    }
                    if (prop.equals("NewEJBCreationWizardDataProvider.useCMP") || prop.equals("IArtifactEditOperationDataModelProperties.PROJECT_NAME") || prop.equals("IArtifactEditOperationDataModelProperties.COMPONENT_NAME") || prop.equals("NewEJBCreationWizardDataProvider.ejbTypeModel")) {
                        EJBBasicPropertiesComposite.this.setCMPVersionVisibility(label, combo);
                    }
                }
            });
            this.setCMPVersionVisibility(label, combo);
        }
    }

    protected void setCMPVersionVisibility(Label label, Combo combo) {
        boolean visible = false;
        visible = this.model.getBooleanProperty("NewEJBCreationWizardDataProvider.useCMP");
        label.setVisible(visible);
        combo.setVisible(visible);
    }

    private void createAnnotationsGroup() {
        this.annotationsGroup = new AnnotationsStandaloneGroup(this.parent, (Object)this.model, true);
        IProject project = null;
        try {
            IVirtualComponent component = (IVirtualComponent)this.model.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
            if (component != null) {
                project = component.getProject();
            }
        }
        catch (Exception exception) {
            return;
        }
        this.annotationsGroup.setEnablement(project);
    }

    protected void createBeanNameControls() {
        Label label = new Label(this.parent, 0);
        label.setText(EJBCreationUIResourceHandler.Bean_name__UI_);
        this.beanNameText = new Text(this.parent, 2052);
        this.beanNameText.setLayoutData((Object)new GridData(768));
        this.createSpacer();
        this.synchHelper.synchText(this.beanNameText, "ICreateEnterpriseBeanDataModelProperties.beanName", true, null);
    }

    protected void createDefaultPackageControls() {
        Label label = new Label(this.parent, 0);
        label.setText(EJBCreationUIResourceHandler.Default_package__UI_);
        Text defaultPackageText = new Text(this.parent, 2052);
        defaultPackageText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(defaultPackageText, "ICreateEnterpriseBeanDataModelProperties.defaultPackageName", null);
        Button defaultPackageButton = new Button(this.parent, 8);
        defaultPackageButton.setText(EJBCreationUIResourceHandler.Browse____UI_);
        GridData bGrid = new GridData(34);
        bGrid.widthHint = 80;
        defaultPackageButton.setLayoutData((Object)bGrid);
        defaultPackageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EJBBasicPropertiesComposite.this.handleDefaultPackageButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void handleDefaultPackageButtonSelected() {
        IFolder sourceFolder = (IFolder)this.model.getProperty("ICreateEnterpriseBeanDataModelProperties.sourceFolder");
        IJavaElement element = JavaCore.create((IFolder)sourceFolder);
        IPackageFragmentRoot root = null;
        if (element.getElementType() == 3) {
            root = (IPackageFragmentRoot)element;
        }
        if (root == null) {
            return;
        }
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createPackageDialog((Shell)this.parent.getShell(), (IPackageFragmentRoot)root, null);
            dialog.setTitle(EJBCreationUIResourceHandler.Select_a_Package_UI_);
        }
        catch (JavaModelException javaModelException) {}
        if (dialog == null || dialog.open() == 1) {
            return;
        }
        String pkg = ((IPackageFragment)dialog.getResult()[0]).getElementName();
        this.model.setProperty("ICreateEnterpriseBeanDataModelProperties.defaultPackageName", (Object)pkg);
    }

    private void createPackageRootControls() {
        Label label = new Label(this.parent, 0);
        label.setText(EJBCreationUIResourceHandler.Source_folder__UI_);
        Combo combo = new Combo(this.parent, 2048);
        combo.setLayoutData((Object)new GridData(768));
        this.createSpacer();
        this.synchHelper.synchCombo(combo, "ICreateEnterpriseBeanDataModelProperties.sourceFolderName", null);
    }

    private void createSelectableEJBProjectControls() {
        Label ejbProjectLabel = new Label(this.parent, 64);
        ejbProjectLabel.setText(EJBCreationUIResourceHandler.EJB_Proj_UI_);
        this.ejbComponentCombo = new Combo(this.parent, 2056);
        this.ejbComponentCombo.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(this.ejbComponentCombo, "IArtifactEditOperationDataModelProperties.PROJECT_NAME", null);
        this.ejbComponentCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String projName = ((Combo)e.getSource()).getText();
                EJBBasicPropertiesComposite.this.annotationsGroup.setEnablement(ProjectUtilities.getProject((String)projName));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button ejbProjectNewButton = new Button(this.parent, 8);
        ejbProjectNewButton.setText(UIResourceHandler.New_UI_);
        GridData bGrid = new GridData();
        bGrid.widthHint = 70;
        ejbProjectNewButton.setLayoutData((Object)bGrid);
        ejbProjectNewButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EJBBasicPropertiesComposite.this.handleNewEJBProjectButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void handleNewEJBProjectButtonSelected() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetProjectCreationDataModelProvider());
        IFacetProjectCreationDataModelProperties.FacetDataModelMap fdmm = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        fdmm.getFacetDataModel("jst.ejb").setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", true);
        EjbProjectWizard wizard = new EjbProjectWizard(dataModel);
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
        WizardDialog wizardDialog = new WizardDialog(this.parent.getShell(), (IWizard)wizard);
        wizardDialog.create();
        if (wizardDialog.open() == 0) {
            String projectName = dataModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
            IDataModel nestedEJBCreationModel = this.model.getNestedModel("EJB_Model");
            if (nestedEJBCreationModel != null) {
                nestedEJBCreationModel.setStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", projectName);
                nestedEJBCreationModel.setStringProperty("ICreateEnterpriseBeanDataModelProperties.componentVersionMap", projectName);
                this.synchHelper.propertyChanged(new DataModelEvent(nestedEJBCreationModel, "IArtifactEditOperationDataModelProperties.PROJECT_NAME", 4));
                this.ejbComponentCombo.select(this.ejbComponentCombo.indexOf(projectName));
            }
        }
    }

    protected void createReadOnlyEJBProjectControls() {
        Label label = new Label(this.parent, 0);
        label.setText(EJBCreationUIResourceHandler.EJB_project__UI_);
        Label ejbProjectNamelabel = new Label(this.parent, 0);
        ejbProjectNamelabel.setLayoutData((Object)new GridData(768));
        this.createSpacer();
        this.synchHelper.synchLabel(ejbProjectNamelabel, "IArtifactEditOperationDataModelProperties.PROJECT_NAME", null);
    }

    private void createSpacer() {
        new Label(this.parent, 0);
    }

    public boolean setFocus() {
        return this.beanNameText.setFocus();
    }

    public void storeDefaultSettings(IDialogSettings settings) {
        if (settings == null) {
            return;
        }
        this.storeSourceFolderName(settings);
        this.storePackageName(settings);
        this.storeUseAnnotations(settings);
    }

    private void storeSourceFolderName(IDialogSettings settings) {
        if (this.model.isPropertySet("ICreateEnterpriseBeanDataModelProperties.sourceFolderName")) {
            settings.put(SOURCE_FOLDER_SETTING, this.model.getStringProperty("ICreateEnterpriseBeanDataModelProperties.sourceFolderName"));
        }
    }

    private void storeUseAnnotations(IDialogSettings settings) {
        if (this.model.isPropertySet("IAnnotationsDataModel.useAnnotations")) {
            settings.put(USE_ANNOTATIONS, this.model.getBooleanProperty("IAnnotationsDataModel.useAnnotations"));
        }
    }

    private void storePackageName(IDialogSettings settings) {
        if (this.model.isPropertySet("ICreateEnterpriseBeanDataModelProperties.defaultPackageName")) {
            settings.put(PACKAGE_NAME_SETTING, this.model.getStringProperty("ICreateEnterpriseBeanDataModelProperties.defaultPackageName"));
        }
    }

    public void restoreDefaultSettings(IDialogSettings settings) {
        if (settings == null) {
            return;
        }
        this.restoreSourceFolderName(settings);
        this.restorePackageName(settings);
        this.restoreUseAnnotations(settings);
    }

    private void restoreSourceFolderName(IDialogSettings settings) {
        IFolder folder;
        IProject project;
        String folderName;
        if ((!this.model.isPropertySet("ICreateEnterpriseBeanDataModelProperties.sourceFolderName") || !this.model.isPropertySet("ICreateEnterpriseBeanDataModelProperties.sourceFolder")) && (folderName = settings.get(SOURCE_FOLDER_SETTING)) != null && (project = this.getTargetProject()) != null && project.exists() && (folder = project.getFolder(folderName)).exists()) {
            this.model.setProperty("ICreateEnterpriseBeanDataModelProperties.sourceFolderName", (Object)folderName);
        }
    }

    private void restoreUseAnnotations(IDialogSettings settings) {
        if (!this.model.isPropertySet("IAnnotationsDataModel.useAnnotations")) {
            boolean useAnnotations = settings.getBoolean(USE_ANNOTATIONS);
            this.model.setProperty("IAnnotationsDataModel.useAnnotations", (Object)new Boolean(useAnnotations));
        }
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && projectName.length() > 0) {
            return ProjectUtilities.getProject((String)projectName);
        }
        return null;
    }

    private void restorePackageName(IDialogSettings settings) {
        IPackageFragmentRoot root;
        IFolder sourceFolder;
        String packName;
        if (!this.model.isPropertySet("ICreateEnterpriseBeanDataModelProperties.defaultPackageName") && (packName = settings.get(PACKAGE_NAME_SETTING)) != null && (sourceFolder = (IFolder)this.model.getProperty("ICreateEnterpriseBeanDataModelProperties.sourceFolder")) != null && (root = (IPackageFragmentRoot)JavaCore.create((IFolder)sourceFolder)).exists()) {
            this.model.setProperty("ICreateEnterpriseBeanDataModelProperties.defaultPackageName", (Object)packName);
        }
    }
}

