/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.ui.wizards;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.common.ui.wizards.EJBReferenceWizard;
import com.ibm.etools.common.ui.wizards.GenericCommandWizard;
import com.ibm.etools.common.ui.wizards.GenericWizardNode;
import com.ibm.etools.common.ui.wizards.IWizardConstants;
import com.ibm.etools.common.ui.wizards.MessageDestReferenceWizard;
import com.ibm.etools.common.ui.wizards.ResourceEnvironmentReferenceWizard;
import com.ibm.etools.common.ui.wizards.ResourceReferenceWizard;
import com.ibm.etools.common.ui.wizards.SecurityRoleReferenceWizard;
import com.ibm.etools.common.ui.wizards.ServiceReferenceWizard;
import com.ibm.etools.common.ui.wizards.helpers.AppClientWizardEditModel;
import com.ibm.etools.common.ui.wizards.helpers.EJBWizardEditModel;
import com.ibm.etools.common.ui.wizards.helpers.WizardEditModel;
import com.ibm.etools.common.ui.wizards.nls.CommonAppEJBWizardsResourceHandler;
import com.ibm.etools.ejb.ui.wizards.helpers.OneBeanWizardEditModel;
import com.ibm.etools.j2ee.ejb.operations.SecurityRoleReferenceDataModel;
import com.ibm.etools.j2ee.reference.EJBReferenceDataModel;
import com.ibm.etools.j2ee.reference.MessageDestReferenceDataModel;
import com.ibm.etools.j2ee.reference.ResourceEnvironmentReferenceDataModel;
import com.ibm.etools.j2ee.reference.ResourceReferenceDataModel;
import com.ibm.etools.j2ee.reference.ServiceReferenceDataModel;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.web.ui.wizards.WebWizardEditModel;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ReferenceSelectionPage
extends WizardSelectionPage
implements Listener {
    Button ejbRef;
    Button serviceRef;
    Button resRef;
    Button secRoleRef;
    Button resEnvRef;
    Button messDestRef;
    protected WizardEditModel model;
    GenericWizardNode refNode;
    GenericWizardNode resRefNode;
    GenericWizardNode serviceRefWizardNode;
    GenericWizardNode resEnvRefWizardNode;
    GenericWizardNode secRoleRefNode;
    GenericWizardNode messDestRefNode;
    protected boolean version = false;

    public ReferenceSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(CommonAppEJBWizardsResourceHandler.Reference_UI_);
        this.setDescription(CommonAppEJBWizardsResourceHandler.Select_the_type_of_reference_to_create_UI_);
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("resource_ref_wiz"));
    }

    public void createControl(Composite parent) {
        this.loadData();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.j2ee.ui.REFERENCE_WIZARD_PAGE1");
        this.createEJBRefButton(composite);
        this.createServiceRefButton(composite);
        this.createResourceRefButton(composite);
        this.createMessageDestRefButton(composite);
        this.createSecurityRoleRefButton(composite);
        this.createResourceEnvironmentRefButton(composite);
        this.setControl((Control)composite);
    }

    protected void createResourceEnvironmentRefButton(Composite composite) {
        boolean skip = false;
        if (this.version || this.isApplicationClientBound() || this.isWebBound()) {
            if (this.isApplicationClientBound() && this.getAppClientModel().getApplicationClient().getVersionID() == 12) {
                skip = true;
            }
            if (this.isWebBound() && this.getWebModel().getWebApp().getVersionID() == 22) {
                skip = true;
            }
            if (!skip) {
                this.resEnvRef = new Button(composite, 16);
                this.resEnvRef.setText(CommonAppEJBWizardsResourceHandler.Resource_environment_reference_UI_);
                this.resEnvRef.addListener(13, (Listener)this);
                this.setButtonDescription(composite, CommonAppEJBWizardsResourceHandler.Creates_a_reference_to_administered_objects_referenced_by_an_enterprise_bean_UI_);
                this.setSpacer(composite);
            }
        }
    }

    protected void createSecurityRoleRefButton(Composite composite) {
        if (this.isEJBBound() && !this.getEJBModel().getEnterpriseBean().isMessageDriven()) {
            this.secRoleRef = new Button(composite, 16);
            this.secRoleRef.setText(CommonAppEJBWizardsResourceHandler.Security_role_reference_UI_);
            this.secRoleRef.addListener(13, (Listener)this);
            this.setButtonDescription(composite, CommonAppEJBWizardsResourceHandler.Creates_a_reference_to_a_security_role_UI_);
            this.setSpacer(composite);
        }
    }

    protected void createResourceRefButton(Composite composite) {
        this.resRef = new Button(composite, 16);
        this.resRef.setText(CommonAppEJBWizardsResourceHandler.EJB_resource_reference_UI_);
        this.resRef.addListener(13, (Listener)this);
        this.setButtonDescription(composite, CommonAppEJBWizardsResourceHandler.Create_a_reference_to_an_external_resource_UI_);
        this.setSpacer(composite);
    }

    protected void createEJBRefButton(Composite composite) {
        this.ejbRef = new Button(composite, 16);
        this.ejbRef.setText(CommonAppEJBWizardsResourceHandler.EJB_reference_UI_);
        this.ejbRef.addListener(13, (Listener)this);
        this.ejbRef.setSelection(true);
        this.handleEJBRef();
        this.setButtonDescription(composite, CommonAppEJBWizardsResourceHandler.Creates_a_reference_to_an_enterprise_bean_that_is_accessed_through_its_remote_home_and_remote_interface_UI_);
        this.setSpacer(composite);
    }

    protected void createServiceRefButton(Composite composite) {
        boolean is13OrGreater = true;
        if (this.isEJBBound()) {
            is13OrGreater = this.getEJBModel().getEJBJar().getVersionID() >= 20;
        } else if (this.isWebBound()) {
            is13OrGreater = this.getWebModel().getWebApp().getVersionID() >= 23;
        } else if (this.isApplicationClientBound()) {
            boolean bl = is13OrGreater = this.getAppClientModel().getApplicationClient().getVersionID() >= 13;
        }
        if (is13OrGreater) {
            this.serviceRef = new Button(composite, 16);
            this.serviceRef.setText(CommonAppEJBWizardsResourceHandler.Service_reference_UI_);
            this.serviceRef.addListener(13, (Listener)this);
            this.setButtonDescription(composite, CommonAppEJBWizardsResourceHandler.Create_a_reference_to_an_web_service_);
            this.setSpacer(composite);
        }
    }

    protected void createMessageDestRefButton(Composite composite) {
        boolean is14OrGreater = true;
        if (this.isEJBBound()) {
            is14OrGreater = this.getEJBModel().getEJBJar().getVersionID() >= 21;
        } else if (this.isWebBound()) {
            is14OrGreater = this.getWebModel().getWebApp().getVersionID() >= 24;
        } else if (this.isApplicationClientBound()) {
            boolean bl = is14OrGreater = this.getAppClientModel().getApplicationClient().getVersionID() >= 14;
        }
        if (is14OrGreater) {
            this.messDestRef = new Button(composite, 16);
            this.messDestRef.setText(CommonAppEJBWizardsResourceHandler.Message_dest_reference_UI_);
            this.messDestRef.addListener(13, (Listener)this);
            this.setButtonDescription(composite, CommonAppEJBWizardsResourceHandler.Create_a_reference_to_an_message_destination_);
            this.setSpacer(composite);
        }
    }

    private void setSpacer(Composite composite) {
        Label space = new Label(composite, 0);
        GridData data = new GridData(768);
        space.setLayoutData((Object)data);
    }

    private void setButtonDescription(Composite composite, String desc) {
        Label descLabel = new Label(composite, 64);
        descLabel.setForeground(IWizardConstants.DESC_COLOR);
        GridData data = new GridData();
        data.horizontalIndent = 17;
        data.widthHint = 300;
        descLabel.setLayoutData((Object)data);
        descLabel.setText(desc);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.ejbRef) {
            this.handleEJBRef();
        } else if (this.serviceRef != null && event.widget == this.serviceRef) {
            this.handleWebServClientRef();
        } else if (event.widget == this.resRef) {
            this.handleResRef();
        } else if (event.widget == this.messDestRef) {
            this.handleMessDestRef();
        } else if (event.widget == this.secRoleRef) {
            this.handleSecRoleRef();
        } else if (event.widget == this.resEnvRef) {
            this.handleResEnvRef();
        }
    }

    protected void handleEJBRef() {
        if (this.refNode == null) {
            if (this.isEJBBound()) {
                this.refNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        EJBReferenceDataModel dataModel = new EJBReferenceDataModel();
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getEJBModel().getEnterpriseBean());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getEJBModel().getEditingDomain());
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getEJBModel().getArtifactEdit().getProject().getName());
                        dataModel.setProperty("EJBReferenceDataModel.LOCAL_REMOTE_TYPE", (Object)"Remote");
                        return new EJBReferenceWizard(dataModel);
                    }
                };
            } else if (this.isApplicationClientBound()) {
                this.refNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        EJBReferenceDataModel dataModel = new EJBReferenceDataModel();
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getAppClientModel().getApplicationClient());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getAppClientModel().getEditingDomain());
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getAppClientModel().getArtifactEdit().getProject().getName());
                        dataModel.setProperty("EJBReferenceDataModel.LOCAL_REMOTE_TYPE", (Object)"Remote");
                        return new EJBReferenceWizard(dataModel);
                    }
                };
            } else if (this.isWebBound()) {
                this.refNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        EJBReferenceDataModel dataModel = new EJBReferenceDataModel();
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getWebModel().getWebApp());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getWebModel().getEditingDomain());
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getWebModel().getArtifactEdit().getProject().getName());
                        dataModel.setProperty("EJBReferenceDataModel.LOCAL_REMOTE_TYPE", (Object)"Local");
                        return new EJBReferenceWizard(dataModel);
                    }
                };
            }
        }
        this.setSelectedNode(this.refNode);
    }

    protected void handleWebServClientRef() {
        if (this.serviceRefWizardNode == null) {
            if (this.isEJBBound()) {
                this.serviceRefWizardNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        ServiceReferenceDataModel dataModel = new ServiceReferenceDataModel();
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getEJBModel().getArtifactEdit().getProject().getName());
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getEJBModel().getEnterpriseBean());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getEJBModel().getEditingDomain());
                        return new ServiceReferenceWizard(dataModel);
                    }
                };
            } else if (this.isApplicationClientBound()) {
                this.serviceRefWizardNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        ServiceReferenceDataModel dataModel = new ServiceReferenceDataModel();
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getAppClientModel().getArtifactEdit().getProject().getName());
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getAppClientModel().getApplicationClient());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getAppClientModel().getEditingDomain());
                        return new ServiceReferenceWizard(dataModel);
                    }
                };
            } else if (this.isWebBound()) {
                this.serviceRefWizardNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        ServiceReferenceDataModel dataModel = new ServiceReferenceDataModel();
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getWebModel().getArtifactEdit().getProject().getName());
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getWebModel().getWebApp());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getWebModel().getEditingDomain());
                        return new ServiceReferenceWizard(dataModel);
                    }
                };
            }
        }
        this.setSelectedNode(this.serviceRefWizardNode);
    }

    protected void handleResRef() {
        if (this.resRefNode == null) {
            if (this.isEJBBound()) {
                this.resRefNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        ResourceReferenceDataModel dataModel = new ResourceReferenceDataModel();
                        ArtifactEdit artifactEdit = ReferenceSelectionPage.this.getEJBModel().getArtifactEdit();
                        IVirtualComponent comp = artifactEdit.getComponent();
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)comp.getProject().getName());
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getEJBModel().getEnterpriseBean());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getEJBModel().getEditingDomain());
                        return new ResourceReferenceWizard(dataModel);
                    }
                };
            } else if (this.isApplicationClientBound()) {
                this.resRefNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        ResourceReferenceDataModel dataModel = new ResourceReferenceDataModel();
                        ArtifactEdit artifactEdit = ReferenceSelectionPage.this.getAppClientModel().getArtifactEdit();
                        IVirtualComponent comp = artifactEdit.getComponent();
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)comp.getProject().getName());
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getAppClientModel().getApplicationClient());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getAppClientModel().getEditingDomain());
                        return new ResourceReferenceWizard(dataModel);
                    }
                };
            } else if (this.isWebBound()) {
                this.resRefNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        ResourceReferenceDataModel dataModel = new ResourceReferenceDataModel();
                        ArtifactEdit artifactEdit = ReferenceSelectionPage.this.getWebModel().getArtifactEdit();
                        IVirtualComponent comp = artifactEdit.getComponent();
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)comp.getProject().getName());
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getWebModel().getWebApp());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getWebModel().getEditingDomain());
                        return new ResourceReferenceWizard(dataModel);
                    }
                };
            }
        }
        this.setSelectedNode(this.resRefNode);
    }

    protected void handleMessDestRef() {
        if (this.messDestRefNode == null) {
            if (this.isEJBBound()) {
                this.messDestRefNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        MessageDestReferenceDataModel dataModel = new MessageDestReferenceDataModel();
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getEJBModel().getEnterpriseBean());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getEJBModel().getEditingDomain());
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getEJBModel().getArtifactEdit().getProject().getName());
                        return new MessageDestReferenceWizard((WTPOperationDataModel)dataModel);
                    }
                };
            } else if (this.isApplicationClientBound()) {
                this.messDestRefNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        MessageDestReferenceDataModel dataModel = new MessageDestReferenceDataModel();
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getAppClientModel().getApplicationClient());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getAppClientModel().getEditingDomain());
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getAppClientModel().getArtifactEdit().getProject().getName());
                        return new MessageDestReferenceWizard((WTPOperationDataModel)dataModel);
                    }
                };
            } else if (this.isWebBound()) {
                this.messDestRefNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        MessageDestReferenceDataModel dataModel = new MessageDestReferenceDataModel();
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getWebModel().getWebApp());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getWebModel().getEditingDomain());
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getWebModel().getArtifactEdit().getProject().getName());
                        return new MessageDestReferenceWizard((WTPOperationDataModel)dataModel);
                    }
                };
            }
        }
        this.setSelectedNode(this.messDestRefNode);
    }

    protected void handleResEnvRef() {
        if (this.resEnvRefWizardNode == null) {
            if (this.isEJBBound()) {
                this.resEnvRefWizardNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        ResourceEnvironmentReferenceDataModel dataModel = new ResourceEnvironmentReferenceDataModel();
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getEJBModel().getProject().getName());
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getEJBModel().getEnterpriseBean());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getEJBModel().getEditingDomain());
                        return new ResourceEnvironmentReferenceWizard(dataModel);
                    }
                };
            } else if (this.isApplicationClientBound()) {
                this.resEnvRefWizardNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        ResourceEnvironmentReferenceDataModel dataModel = new ResourceEnvironmentReferenceDataModel();
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getAppClientModel().getProject().getName());
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getAppClientModel().getApplicationClient());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getAppClientModel().getEditingDomain());
                        return new ResourceEnvironmentReferenceWizard(dataModel);
                    }
                };
            } else if (this.isWebBound()) {
                this.resEnvRefWizardNode = new GenericWizardNode(){

                    @Override
                    public IWizard createWizard() {
                        ResourceEnvironmentReferenceDataModel dataModel = new ResourceEnvironmentReferenceDataModel();
                        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getWebModel().getProject().getName());
                        dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getWebModel().getWebApp());
                        dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getWebModel().getEditingDomain());
                        return new ResourceEnvironmentReferenceWizard(dataModel);
                    }
                };
            }
        }
        this.setSelectedNode(this.resEnvRefWizardNode);
    }

    protected void handleSecRoleRef() {
        if (this.secRoleRefNode == null && this.isEJBBound()) {
            this.secRoleRefNode = new GenericWizardNode(){

                @Override
                public IWizard createWizard() {
                    SecurityRoleReferenceDataModel dataModel = new SecurityRoleReferenceDataModel();
                    dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)ReferenceSelectionPage.this.getEJBModel().getProject().getName());
                    dataModel.setProperty("ReferenceDataModel.OWNER", (Object)ReferenceSelectionPage.this.getEJBModel().getEnterpriseBean());
                    dataModel.setProperty("ModelModifierOperationDataModel.EDITING_DOMAIN", (Object)ReferenceSelectionPage.this.getEJBModel().getEditingDomain());
                    return new SecurityRoleReferenceWizard(dataModel);
                }
            };
        }
        this.setSelectedNode(this.secRoleRefNode);
    }

    protected void loadData() {
        if (this.getWizard() instanceof GenericCommandWizard) {
            GenericCommandWizard wizard = (GenericCommandWizard)this.getWizard();
            this.model = wizard.getWizardEditModel();
            if (this.isEJBBound()) {
                this.version = this.getEJBModel().getEJBJar().getVersionID() >= 20;
            }
        }
    }

    protected boolean isApplicationClientBound() {
        return this.model instanceof AppClientWizardEditModel;
    }

    protected boolean isEJBBound() {
        return this.model instanceof EJBWizardEditModel;
    }

    protected OneBeanWizardEditModel getEJBModel() {
        return (OneBeanWizardEditModel)this.model;
    }

    protected AppClientWizardEditModel getAppClientModel() {
        return (AppClientWizardEditModel)this.model;
    }

    protected boolean isWebBound() {
        return this.model instanceof WebWizardEditModel;
    }

    protected WebWizardEditModel getWebModel() {
        return (WebWizardEditModel)this.model;
    }

    public void dispose() {
        if (this.serviceRefWizardNode != null) {
            this.serviceRefWizardNode.dispose();
        }
        if (this.resRefNode != null) {
            this.resRefNode.dispose();
        }
        if (this.refNode != null) {
            this.refNode.dispose();
        }
        if (this.resEnvRefWizardNode != null) {
            this.resEnvRefWizardNode.dispose();
        }
        if (this.secRoleRefNode != null) {
            this.secRoleRefNode.dispose();
        }
        if (this.messDestRefNode != null) {
            this.messDestRefNode.dispose();
        }
    }
}

