/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.ui.sections;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.ArrayList;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;

public class EJBSearchScope
implements IJavaSearchScope {
    public static final int EJBHOME = 1;
    public static final int EJBLOCALHOME = 2;
    public static final int EJBOBJECT = 3;
    public static final int EJBLOCALOBJECT = 4;
    private IJavaSearchScope javaScope;
    IProject project;
    IProject[] ejbProjects;
    private String filterString;

    public EJBSearchScope(IProject project, int filter) {
        this.project = project;
        switch (filter) {
            case 1: {
                this.filterString = "EJBHome";
                break;
            }
            case 2: {
                this.filterString = "EJBLocalHome";
                break;
            }
            case 3: {
                this.filterString = "EJBObject";
                break;
            }
            case 4: {
                this.filterString = "EJBLocalObject";
                break;
            }
        }
        this.init();
    }

    protected void init() {
        try {
            this.javaScope = SearchEngine.createWorkspaceScope();
        }
        catch (Exception e) {
            J2EEUIPlugin.logError(e);
        }
    }

    public boolean includesClasspaths() {
        return true;
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean encloses(String resourcePath) {
        int indexEnd;
        String source;
        block8: {
            int indexStart;
            block7: {
                int index = resourcePath.indexOf(".java");
                if (index == -1) {
                    return false;
                }
                IFile resource = this.findFile(resourcePath);
                if (resource == null) {
                    return false;
                }
                IJavaElement element = JavaCore.create((IResource)resource);
                if (!(element instanceof ICompilationUnit)) {
                    return false;
                }
                ICompilationUnit cu = (ICompilationUnit)element;
                try {
                    cu.open(null);
                    source = cu.getSource();
                    indexStart = source.indexOf("extends");
                    if (indexStart != -1) break block7;
                    return false;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            source = source.substring(indexStart);
            indexEnd = source.indexOf("{");
            if (indexEnd != -1) break block8;
            return false;
        }
        source = source.substring(0, indexEnd);
        return source.indexOf(this.filterString) != -1;
    }

    protected IProject[] getReferencingEARProjects() {
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        IProject[] refProjects = this.project.getReferencingProjects();
        int i = 0;
        while (i < refProjects.length) {
            if (J2EEProjectUtilities.isEJBProject((IProject)refProjects[i])) {
                projectList.add(refProjects[i]);
            }
            ++i;
        }
        Project[] earProjects = new Project[projectList.size()];
        projectList.toArray(earProjects);
        return earProjects;
    }

    protected IProject[] getReferencedEJBProjectsInEAR() {
        IProject[] earProjects = this.getReferencingEARProjects();
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        try {
            int j = 0;
            while (j < earProjects.length) {
                IProject[] refProjects = earProjects[j].getReferencedProjects();
                int i = 0;
                while (i < refProjects.length) {
                    if (J2EEProjectUtilities.isEJBProject((IProject)refProjects[i])) {
                        projectList.add(refProjects[i]);
                    }
                    ++i;
                }
                ++j;
            }
        }
        catch (CoreException coreException) {}
        Project[] ejbProjects = new Project[projectList.size()];
        projectList.toArray(ejbProjects);
        return ejbProjects;
    }

    protected IFile findFile(String resourcePath) {
        IFile file = null;
        if (this.ejbProjects == null) {
            this.ejbProjects = this.getReferencedEJBProjectsInEAR();
        }
        int i = 0;
        while (i < this.ejbProjects.length) {
            file = this.ejbProjects[i].getFile(new Path(resourcePath).removeFirstSegments(1));
            if (file != null && file.exists()) {
                return file;
            }
            ++i;
        }
        return null;
    }

    public boolean encloses(IJavaElement element) {
        return true;
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.javaScope.enclosingProjectsAndJars();
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }
}

