/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.insertions;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.common.insertions.ServiceReferenceSelectionModel;
import com.ibm.etools.common.ui.wizards.ServiceReferenceWizard;
import com.ibm.etools.emf.workbench.ui.wizard.datamodel.WTPWizardPage;
import com.ibm.etools.j2ee.reference.ServiceReferenceDataModel;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.webservice.ui.nls.WebServiceUIResourceHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jem.java.Method;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wst.common.frameworks.internal.ui.ClosableWizardDialog;
import org.eclipse.wst.common.internal.emfworkbench.integration.DynamicAdapterFactory;

public class ServiceReferenceSelectionPage
extends WTPWizardPage {
    protected static final Object[] EMPTY_ELEMENTS = new Object[0];
    protected TableViewer serviceRefViewer;
    protected Button newButton;
    private DynamicAdapterFactory adapterFactory;
    private Label ownerLabel;
    private AdapterFactoryLabelProvider labelProvider;
    private Label ownerImage;

    public ServiceReferenceSelectionPage(String pageName, String title, ServiceReferenceSelectionModel model) {
        super((WTPOperationDataModel)model, pageName, title, J2EEUIPlugin.getDefault().getImageDescriptor("Serviceref_wiz"));
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.verticalSpacing = 10;
        main.setLayout((Layout)mainLayout);
        main.setLayoutData((Object)new GridData(768));
        this.createOwnerControls(main);
        this.createEJBRefView(main);
        this.createNewButton(main);
        this.setMessage(WebServiceUIResourceHandler.ServiceReferenceSelectionPage_UI_0);
        return main;
    }

    private void createOwnerControls(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 3;
        main.setLayout((Layout)mainLayout);
        main.setLayoutData((Object)new GridData(768));
        Label label = new Label(main, 0);
        label.setText(WebServiceUIResourceHandler.ServiceReferenceSelectionPage_UI_1);
        this.ownerImage = new Label(main, 0);
        this.ownerLabel = new Label(main, 0);
        this.ownerLabel.setLayoutData((Object)new GridData(512));
    }

    private void createNewButton(Composite main) {
        this.newButton = new Button(main, SWT.BUTTON_MASK);
        GridData gd = new GridData(2);
        this.newButton.setLayoutData((Object)gd);
        this.newButton.setText(WebServiceUIResourceHandler.ServiceReferenceSelectionPage_UI_2);
        this.newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceReferenceSelectionPage.this.handleNewButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.model.getProperty("J2EEReferenceSnippetDataModel.owner") == null) {
            this.newButton.setEnabled(false);
        }
    }

    protected void createEJBRefView(Composite parent) {
        this.serviceRefViewer = new TableViewer(parent, 516);
        Table table = this.serviceRefViewer.getTable();
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        table.setLayoutData((Object)gd);
        this.createTableContentProvider();
        this.adapterFactory = new DynamicAdapterFactory(null);
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        this.serviceRefViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    protected void createTableContentProvider() {
        this.serviceRefViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ServiceReferenceSelectionPage.this.getServiceRefs(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    protected Object[] getServiceRefs(Object inputElement) {
        if (inputElement instanceof EnterpriseBean) {
            return this.getServiceRefs((EnterpriseBean)inputElement);
        }
        if (inputElement instanceof WebApp) {
            return this.getServiceRefs((WebApp)inputElement);
        }
        if (inputElement instanceof ApplicationClient) {
            return this.getServiceRefs((ApplicationClient)inputElement);
        }
        return EMPTY_ELEMENTS;
    }

    protected Object[] getServiceRefs(EnterpriseBean ejb) {
        return WebServicesManager.getInstance().getServiceRefs(ejb).toArray();
    }

    protected Object[] getServiceRefs(WebApp web) {
        return WebServicesManager.getInstance().getServiceRefs(web).toArray();
    }

    protected Object[] getServiceRefs(ApplicationClient appClient) {
        return WebServicesManager.getInstance().getServiceRefs(appClient).toArray();
    }

    protected void addListeners() {
        this.serviceRefViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object sel = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (sel instanceof ServiceRef) {
                    ServiceReferenceSelectionPage.this.model.setProperty("J2EEReferenceSnippetDataModel.selectedReference", sel);
                }
                ServiceReferenceSelectionPage.this.validatePage();
            }
        });
        this.serviceRefViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!ServiceReferenceSelectionPage.this.isPageComplete()) {
                    return;
                }
                if (ServiceReferenceSelectionPage.this.model.getProperty("J2EEReferenceSnippetDataModel.selectedReference") != null) {
                    IWizardPage nextPage = ServiceReferenceSelectionPage.this.getNextPage();
                    if (nextPage == null && ServiceReferenceSelectionPage.this.getWizard().getContainer() instanceof ClosableWizardDialog) {
                        Method method = (Method)ServiceReferenceSelectionPage.this.model.getProperty("MethodBasedReferenceSnippetDataModel.selectedMethod");
                        if (method != null && method.getParameters().isEmpty() && ServiceReferenceSelectionPage.this.getWizard().performFinish()) {
                            ((ClosableWizardDialog)ServiceReferenceSelectionPage.this.getWizard().getContainer()).finishAndClose();
                        }
                    } else {
                        ServiceReferenceSelectionPage.this.getContainer().showPage(nextPage);
                    }
                }
            }
        });
        this.newButton.addListener(13, (Listener)this);
    }

    protected void handleNewButtonPressed() {
        Object owner = this.model.getProperty("J2EEReferenceSnippetDataModel.owner");
        Object[] refs = this.getServiceRefs(owner);
        IWizard wizard = this.createNewServiceReferenceWizard(owner);
        if (wizard != null) {
            WizardDialog dialog = new WizardDialog(this.getShell(), wizard);
            dialog.create();
            dialog.getShell().setSize(400, 500);
            int result = dialog.open();
            if (result == 0) {
                this.serviceRefViewer.refresh();
                Object[] newRefs = this.getServiceRefs(owner);
                Object newSel = this.getNewObject(refs, newRefs);
                if (newSel != null) {
                    StructuredSelection selection = new StructuredSelection(newSel);
                    this.serviceRefViewer.setSelection((ISelection)selection, true);
                }
            }
        }
    }

    private Object getNewObject(Object[] oldObjects, Object[] newObjects) {
        if (oldObjects != null && newObjects != null && oldObjects.length < newObjects.length) {
            int i = 0;
            while (i < newObjects.length) {
                boolean found = false;
                Object object = newObjects[i];
                int j = 0;
                while (j < oldObjects.length) {
                    if (oldObjects[j] == object) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return object;
                }
                ++i;
            }
        }
        return null;
    }

    private IWizard createNewServiceReferenceWizard(Object anObject) {
        ServiceReferenceDataModel dataModel = new ServiceReferenceDataModel();
        dataModel.setProperty("ReferenceDataModel.OWNER", anObject);
        IProject project = (IProject)this.getModel().getProperty("J2EEReferenceSnippetDataModel.project");
        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)project.getName());
        return new ServiceReferenceWizard(dataModel);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"J2EEReferenceSnippetDataModel.selectedReference"};
    }

    public void dispose() {
        super.dispose();
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
    }

    protected void enter() {
        Object owner = this.model.getProperty("J2EEReferenceSnippetDataModel.owner");
        this.serviceRefViewer.setInput(owner);
        if (this.labelProvider != null) {
            this.ownerImage.setImage(this.labelProvider.getImage(owner));
            this.ownerLabel.setText(this.labelProvider.getText(owner));
            this.ownerImage.setSize(this.ownerImage.computeSize(-1, -1));
            this.ownerLabel.setVisible(true);
            this.ownerLabel.setSize(this.ownerLabel.computeSize(-1, -1));
        }
        super.enter();
    }
}

