/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.application.presentation;

import com.ibm.etools.application.action.ApplicationHelper;
import com.ibm.etools.application.presentation.ConsolidateRole;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.Identity;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.common.internal.provider.CommonItemProviderAdapterFactory;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.AuthConstraint;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModelModifier;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class CombineRolesOperation
extends WTPOperation {
    protected EARArtifactEdit artifactEdit;
    protected IProject earProject;
    protected AdapterFactoryEditingDomain editingDomain;
    protected List consolidateRoleList;

    public CombineRolesOperation(EARArtifactEdit artifactEdit, AdapterFactoryEditingDomain editingDomain, List consolidateRoleList) {
        this.editingDomain = editingDomain;
        this.consolidateRoleList = consolidateRoleList;
        this.artifactEdit = artifactEdit;
        this.earProject = ProjectUtilities.getProject((EObject)artifactEdit.getApplication());
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        ArrayList moduleList = new ArrayList();
        ArrayList roleList = new ArrayList();
        this.getModuleRoleRelations(moduleList, roleList);
        Application application = this.artifactEdit.getApplication();
        int i = 0;
        int n = this.consolidateRoleList.size();
        while (i < n) {
            String replaceName;
            String originalName = ((ConsolidateRole)this.consolidateRoleList.get(i)).getOriginalName();
            if (this.shouldReplace(originalName, replaceName = ((ConsolidateRole)this.consolidateRoleList.get(i)).getReplaceName())) {
                SecurityRole originalRole = application.getSecurityRoleNamed(originalName);
                SecurityRole replaceRole = application.getSecurityRoleNamed(replaceName);
                ArrayList<Integer> affectedModuleIndexes = new ArrayList<Integer>();
                int j = 0;
                int nRole = roleList.size();
                while (j < nRole) {
                    SecurityRole role = (SecurityRole)roleList.get(j);
                    if (originalRole.getRoleName().equals(role.getRoleName())) {
                        affectedModuleIndexes.add(new Integer(j));
                    }
                    ++j;
                }
                int nModule = affectedModuleIndexes.size();
                int j2 = 0;
                while (j2 < nModule) {
                    int index = (Integer)affectedModuleIndexes.get(j2);
                    Module module = (Module)moduleList.get(index);
                    IVirtualComponent comp = ApplicationHelper.getVirtualComponentFromModule(this.artifactEdit, module);
                    if (comp != null) {
                        if (module.isEjbModule()) {
                            this.consolidateRoleForEjbModule(comp, originalRole, replaceRole);
                        } else if (module.isWebModule()) {
                            CombineRolesOperation.consolidateRoleForWebModule(comp, originalRole, replaceRole);
                        }
                    }
                    ++j2;
                }
                this.consolidateRoleForApplication(originalRole, replaceRole);
            }
            ++i;
        }
        this.artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
    }

    protected void getModuleRoleRelations(List moduleList, List roleList) {
        EList modules = this.artifactEdit.getApplication().getModules();
        int nModule = modules.size();
        if (nModule == 0) {
            return;
        }
        int i = 0;
        while (i < nModule) {
            Module module = (Module)modules.get(i);
            IVirtualComponent comp = ApplicationHelper.getVirtualComponentFromModule(this.artifactEdit, module);
            if (comp != null && (module.isEjbModule() || module.isWebModule())) {
                List roles = ApplicationHelper.getSecurityRolesFromModule(this.artifactEdit, this.earProject, module);
                int j = 0;
                int nRole = roles.size();
                while (j < nRole) {
                    moduleList.add(module);
                    roleList.add(roles.get(j));
                    ++j;
                }
            }
            ++i;
        }
    }

    protected boolean shouldReplace(String originalRoleName, String replaceRoleName) {
        if ((replaceRoleName = replaceRoleName.trim()).equals("") || replaceRoleName.equals(originalRoleName)) {
            return false;
        }
        Application application = this.artifactEdit.getApplication();
        EList roleList = application.getSecurityRoles();
        int n = roleList.size();
        int i = 0;
        while (i < n) {
            if (replaceRoleName.equals(((SecurityRole)roleList.get(i)).getRoleName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void consolidateRoleForEjbModule(IVirtualComponent ejbComp, SecurityRole originalRole, SecurityRole replaceRole) {
        EJBArtifactEdit ejbArtifactEdit = null;
        try {
            ejbArtifactEdit = EJBArtifactEdit.getEJBArtifactEditForWrite((IVirtualComponent)ejbComp);
            ModelModifier modifier = null;
            try {
                AdapterFactory[] af = new AdapterFactory[]{new CommonItemProviderAdapterFactory()};
                ComposedAdapterFactory ejbComposedAdapterFactory = new ComposedAdapterFactory(af);
                AdapterFactoryEditingDomain ejbEditingDomain = new AdapterFactoryEditingDomain((AdapterFactory)ejbComposedAdapterFactory, ejbArtifactEdit.getCommandStack(), ejbArtifactEdit.getEJBJar().eResource().getResourceSet());
                modifier = new ModelModifier((EditingDomain)ejbEditingDomain);
            }
            catch (Exception e) {
                J2EEUIPlugin.logError(e);
            }
            if (modifier != null) {
                ModifierHelper helper;
                EJBJar ejbJar = ejbArtifactEdit.getEJBJar();
                AssemblyDescriptor ad = ejbJar.getAssemblyDescriptor();
                String originalRoleName = originalRole.getRoleName();
                String replaceRoleName = replaceRole.getRoleName();
                List methodPermissionList = ApplicationHelper.collectMethodPermissionsForRoleNamed(ejbJar, originalRoleName);
                ArrayList identity20List = new ArrayList();
                ArrayList bean20List = new ArrayList();
                ApplicationHelper.collectEJB20IdentitiesForRoleNamed(ejbJar, originalRoleName, identity20List, bean20List);
                ArrayList securityRoleRefList = new ArrayList();
                ArrayList beanList = new ArrayList();
                ApplicationHelper.collectSecurityRoleRefsForRoleNamed(ejbJar, originalRoleName, securityRoleRefList, beanList);
                SecurityRole theReplaceRole = ad.getSecurityRoleNamed(replaceRoleName);
                if (theReplaceRole == null) {
                    ModifierHelper helper2 = ApplicationHelper.createHelperForAddSecurityRole((EObject)ad, replaceRoleName, replaceRole.getDescription());
                    modifier.addHelper(helper2);
                }
                int i = 0;
                int n = methodPermissionList.size();
                while (i < n) {
                    MethodPermission methodPermission = (MethodPermission)methodPermissionList.get(i);
                    if (methodPermission.getSecurityRole(replaceRoleName) == null) {
                        helper = ApplicationHelper.createHelperForAddSecurityRole((EObject)methodPermission, replaceRoleName, replaceRole.getDescription());
                        modifier.addHelper(helper);
                    }
                    SecurityRole role = methodPermission.getSecurityRole(originalRoleName);
                    ModifierHelper helper3 = ApplicationHelper.createHelperForRemoveAttribute((EObject)methodPermission, (EStructuralFeature)EjbPackage.eINSTANCE.getMethodPermission_Roles(), role);
                    modifier.addHelper(helper3);
                    ++i;
                }
                i = 0;
                n = identity20List.size();
                while (i < n) {
                    Identity identity = (Identity)identity20List.get(i);
                    helper = ApplicationHelper.createHelperForModifyAttribute((EObject)identity, (EStructuralFeature)CommonPackage.eINSTANCE.getIdentity_RoleName(), replaceRoleName);
                    modifier.addHelper(helper);
                    ++i;
                }
                i = 0;
                n = securityRoleRefList.size();
                while (i < n) {
                    SecurityRoleRef securityRoleRef = (SecurityRoleRef)securityRoleRefList.get(i);
                    helper = ApplicationHelper.createHelperForModifyAttribute((EObject)securityRoleRef, (EStructuralFeature)CommonPackage.eINSTANCE.getSecurityRoleRef_Link(), replaceRoleName);
                    modifier.addHelper(helper);
                    ++i;
                }
                SecurityRole theOriginalRole = ad.getSecurityRoleNamed(originalRoleName);
                ModifierHelper helper4 = ApplicationHelper.createHelperForRemoveAttribute((EObject)ad, (EStructuralFeature)EjbPackage.eINSTANCE.getAssemblyDescriptor_SecurityRoles(), theOriginalRole);
                modifier.addHelper(helper4);
                if (modifier.getHelpers().size() > 0) {
                    modifier.execute();
                }
            }
        }
        finally {
            if (ejbArtifactEdit != null) {
                ejbArtifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                ejbArtifactEdit.dispose();
                ejbArtifactEdit = null;
            }
        }
    }

    public static void consolidateRoleForWebModule(IVirtualComponent webComp, SecurityRole originalRole, SecurityRole replaceRole) {
        WebArtifactEdit webArtifactEdit = null;
        ModelModifier modifier = null;
        try {
            webArtifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)webComp);
            try {
                AdapterFactory[] af = new AdapterFactory[]{new CommonItemProviderAdapterFactory()};
                ComposedAdapterFactory webComposedAdapterFactory = new ComposedAdapterFactory(af);
                AdapterFactoryEditingDomain webEditingDomain = new AdapterFactoryEditingDomain((AdapterFactory)webComposedAdapterFactory, webArtifactEdit.getCommandStack(), webArtifactEdit.getWebApp().eResource().getResourceSet());
                modifier = new ModelModifier((EditingDomain)webEditingDomain);
            }
            catch (Exception e) {
                J2EEUIPlugin.logError(e);
            }
            if (modifier != null) {
                WebApp webApp = webArtifactEdit.getWebApp();
                String originalRoleName = originalRole.getRoleName();
                String replaceRoleName = replaceRole.getRoleName();
                ArrayList securityRoleRefList = new ArrayList();
                ArrayList servletRefList = new ArrayList();
                ApplicationHelper.collectSecurityRoleRefsForRoleNamed(webApp, originalRoleName, securityRoleRefList, servletRefList);
                ArrayList authList = new ArrayList();
                ArrayList constraintList = new ArrayList();
                ApplicationHelper.collectAuthConstraintsForRoleNamed(webApp, originalRoleName, authList, constraintList);
                SecurityRole theReplaceRole = webApp.getSecurityRoleNamed(replaceRoleName);
                if (theReplaceRole == null) {
                    ModifierHelper helper = ApplicationHelper.createHelperForAddSecurityRole((EObject)webApp, replaceRoleName, replaceRole.getDescription());
                    modifier.addHelper(helper);
                }
                int i = 0;
                int n = securityRoleRefList.size();
                while (i < n) {
                    SecurityRoleRef securityRoleRef = (SecurityRoleRef)securityRoleRefList.get(i);
                    ModifierHelper helper = ApplicationHelper.createHelperForModifyAttribute((EObject)securityRoleRef, (EStructuralFeature)CommonPackage.eINSTANCE.getSecurityRoleRef_Link(), replaceRoleName);
                    modifier.addHelper(helper);
                    ++i;
                }
                i = 0;
                n = authList.size();
                while (i < n) {
                    AuthConstraint auth = (AuthConstraint)authList.get(i);
                    EList roles = auth.getRoles();
                    ArrayList<String> newRoles = new ArrayList<String>();
                    int j = 0;
                    int m = roles.size();
                    while (j < m) {
                        String role;
                        String newRole = role = (String)roles.get(j);
                        if (role.equals(originalRoleName)) {
                            newRole = replaceRoleName;
                        }
                        boolean dup = false;
                        int k = 0;
                        int h = newRoles.size();
                        while (k < h) {
                            if (newRole.equals(newRoles.get(k))) {
                                dup = true;
                                break;
                            }
                            ++k;
                        }
                        if (!dup) {
                            newRoles.add(newRole);
                        }
                        ++j;
                    }
                    roles.clear();
                    roles.addAll(newRoles);
                    SecurityConstraint secCons = (SecurityConstraint)constraintList.get(i);
                    ModifierHelper helper = ApplicationHelper.createHelperForModifyAttribute((EObject)secCons, (EStructuralFeature)WebapplicationPackage.eINSTANCE.getSecurityConstraint_AuthConstraint(), auth);
                    modifier.addHelper(helper);
                    ++i;
                }
                SecurityRole theOriginalRole = webApp.getSecurityRoleNamed(originalRoleName);
                ModifierHelper helper = ApplicationHelper.createHelperForRemoveAttribute((EObject)webApp, (EStructuralFeature)WebapplicationPackage.eINSTANCE.getWebApp_SecurityRoles(), theOriginalRole);
                modifier.addHelper(helper);
                if (modifier.getHelpers().size() > 0) {
                    modifier.execute();
                }
            }
        }
        finally {
            if (webArtifactEdit != null) {
                webArtifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                webArtifactEdit.dispose();
                webArtifactEdit = null;
            }
        }
    }

    protected void consolidateRoleForApplication(SecurityRole originalRole, SecurityRole replaceRole) {
        Application application = this.artifactEdit.getApplication();
        ModelModifier modifier = new ModelModifier((EditingDomain)this.editingDomain);
        ModifierHelper helper = ApplicationHelper.createHelperForRemoveAttribute((EObject)application, (EStructuralFeature)ApplicationPackage.eINSTANCE.getApplication_SecurityRoles(), originalRole);
        modifier.addHelper(helper);
        if (modifier.getHelpers().size() > 0) {
            modifier.execute();
        }
    }
}

