/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.application.action;

import com.ibm.etools.application.action.ApplicationHelper;
import com.ibm.etools.application.nls.ApplicationEditorResourceHandler;
import com.ibm.etools.ejb.ui.actions.standalone.AbstractEJBAction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModelModifier;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class RemoveSecurityRoleAction
extends AbstractEJBAction {
    protected StructuredViewer viewer;
    protected EditingDomain editingDomain;
    protected EARArtifactEdit artifactEdit;
    protected IProject project;

    public RemoveSecurityRoleAction(String label, StructuredViewer viewer, EditingDomain editingDomain, EARArtifactEdit artifactEdit, IProject project) {
        super(label);
        this.viewer = viewer;
        this.editingDomain = editingDomain;
        this.artifactEdit = artifactEdit;
        this.project = project;
    }

    @Override
    protected IHeadlessRunnableWithProgress getHeadlessOperation() {
        return null;
    }

    @Override
    public void run() {
        List selectedObjectList = this.getStructuredSelectionFromViewer().toList();
        int size = selectedObjectList.size();
        ArrayList<SecurityRole> roleToBeRemoved = new ArrayList<SecurityRole>();
        int i = size - 1;
        while (i >= 0) {
            SecurityRole role = (SecurityRole)selectedObjectList.get(i);
            if (this.validateRoleNotInModules(role)) {
                roleToBeRemoved.add(role);
            }
            --i;
        }
        if (roleToBeRemoved.size() == 0) {
            return;
        }
        ModelModifier modifier = new ModelModifier(this.editingDomain);
        int i2 = 0;
        while (i2 < roleToBeRemoved.size()) {
            EObject ref = (EObject)roleToBeRemoved.get(i2);
            ModifierHelper helper = new ModifierHelper();
            helper.setOwner(ref.eContainer());
            helper.setFeature((EStructuralFeature)ref.eContainmentFeature());
            helper.setValue((Object)ref);
            helper.doUnsetValue();
            modifier.addHelper(helper);
            ++i2;
        }
        modifier.execute();
    }

    protected boolean validateRoleNotInModules(SecurityRole role) {
        List moduleList = ApplicationHelper.getModulesForRoleNamed(this.artifactEdit, this.project, role.getRoleName());
        if (moduleList.size() > 0) {
            boolean rtrn = MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)ApplicationEditorResourceHandler.SECURITY_ROLE_REFERENCED_TITLE_UI_, (String)ApplicationEditorResourceHandler.SECURITY_ROLE_REFERENCED_MESSAGE_UI_);
            return rtrn;
        }
        return true;
    }

    public StructuredSelection getStructuredSelectionFromViewer() {
        return (StructuredSelection)this.viewer.getSelection();
    }

    public IStructuredSelection getStructuredSelection() {
        return this.getStructuredSelectionFromViewer();
    }
}

