/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.reference.snippets;

import com.ibm.etools.j2ee.reference.snippets.J2EEReferenceSnippetDataModel;
import com.ibm.etools.j2ee.reference.snippets.ReferenceSnippetsPlugin;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;

public abstract class MethodBasedReferenceSnippetDataModel
extends J2EEReferenceSnippetDataModel {
    public static final String SELECTED_METHOD = "MethodBasedReferenceSnippetDataModel.selectedMethod";
    public static final String SELECTED_PARAM_VALUES = "MethodBasedReferenceSnippetDataModel.selectedParamValues";
    public static final String METHODS_FILTER = "MethodBasedReferenceSnippetDataModel.methodsFilter";
    protected List filteredMethods;

    @Override
    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(SELECTED_METHOD);
        this.addValidBaseProperty(SELECTED_PARAM_VALUES);
        this.addValidBaseProperty(METHODS_FILTER);
    }

    @Override
    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(SELECTED_METHOD)) {
            return this.getDefaultMethod();
        }
        return super.getDefaultProperty(propertyName);
    }

    @Override
    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean notify = super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals(SELECTED_METHOD)) {
            this.resetMethodParams();
        }
        return notify;
    }

    @Override
    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(SELECTED_METHOD)) {
            return this.validateSelectedMethod();
        }
        return super.doValidateProperty(propertyName);
    }

    @Override
    protected void selectedReferenceChanged() {
        super.selectedReferenceChanged();
        this.setProperty(SELECTED_METHOD, null);
        this.filteredMethods = null;
    }

    protected Method getDefaultMethod() {
        List methods = this.getAvailableMethods();
        if (methods.size() == 1) {
            return (Method)methods.get(0);
        }
        return null;
    }

    @Override
    public IStatus validateSelectedReference() {
        IStatus status = super.validateSelectedReference();
        return status;
    }

    public IStatus validateSelectedMethod() {
        Method selectedMethod = (Method)this.getProperty(SELECTED_METHOD);
        if (selectedMethod == null) {
            return new Status(4, "com.ibm.etools.j2ee.reference.snippets", 0, ReferenceSnippetsPlugin.getResourceString("1_UI_"), null);
        }
        return J2EEPlugin.OK_STATUS;
    }

    public List getAvailableMethods() {
        if (this.filteredMethods == null) {
            this.filteredMethods = this.initializeFilteredMethods();
        }
        if (this.filteredMethods == null) {
            return Collections.EMPTY_LIST;
        }
        return this.filteredMethods;
    }

    protected abstract List initializeFilteredMethods();

    public abstract JavaClass getInterfaceOrClass();

    protected void resetFilteredMethods() {
        this.filteredMethods = null;
    }

    public String getSignature(Method method) {
        StringBuffer b = new StringBuffer();
        b.append(method.getName()).append('(');
        EList parms = method.getParameters();
        Iterator it = parms.iterator();
        while (it.hasNext()) {
            JavaParameter parm = (JavaParameter)it.next();
            b.append(parm.getJavaType().getName());
            if (parm.getName() != null) {
                b.append(' ').append(parm.getName());
            }
            if (!it.hasNext()) continue;
            b.append(", ");
        }
        b.append(')');
        return b.toString();
    }

    protected void resetMethodParams() {
        if (this.isSet(SELECTED_PARAM_VALUES)) {
            Map map = (Map)this.getProperty(SELECTED_PARAM_VALUES);
            map.clear();
        }
    }

    public void setParamValue(JavaParameter param, String value) {
        if (param != null && value != null) {
            Map<JavaParameter, String> params;
            if (!this.isSet(SELECTED_PARAM_VALUES)) {
                params = new HashMap();
                this.setProperty(SELECTED_PARAM_VALUES, params);
            } else {
                params = (Map)this.getProperty(SELECTED_PARAM_VALUES);
            }
            params.put(param, value);
        }
    }

    public String getParamValue(JavaParameter param) {
        String value = null;
        if (this.isSet(SELECTED_PARAM_VALUES)) {
            value = (String)((Map)this.getProperty(SELECTED_PARAM_VALUES)).get(param);
        }
        if (value == null) {
            value = param.getName();
        }
        return value;
    }
}

