/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.reference.snippets;

import com.ibm.etools.j2ee.insertion.JavaInsertionOperation;
import com.ibm.etools.j2ee.internal.java.insertion.JavaInsertionHelper;
import com.ibm.etools.j2ee.reference.snippets.J2EEReferenceSnippetDataModel;
import com.ibm.etools.j2ee.reference.snippets.J2EEReferenceSnippetFactory;
import com.ibm.etools.j2ee.reference.snippets.ReferenceSnippetsPlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.common.frameworks.internal.ui.ClosableWizardDialog;

public class J2EEReferenceSnippetManager {
    public static final J2EEReferenceSnippetManager INSTANCE = new J2EEReferenceSnippetManager();
    private static final String FACTORY_EXT_PT = "SnippetFactories";
    private static final String FACTORY_EXT_ELEMENT = "referenceFactoryClass";
    private static final String FACTORY_ID_ATT = "id";
    private static final String FACTORY_CLASS_ATT = "factoryClass";
    private Map factories;

    public void invokeJ2EEReferenceSnippet(String key, IEditorInput editorInput, IDocument document, ITextSelection textSelection, Shell shell) {
        if (key == null || editorInput == null || document == null || textSelection == null) {
            return;
        }
        J2EEReferenceSnippetDataModel model = this.createReferenceSnippetModel(key);
        this.invokeJ2EEReferenceSnippet(key, model, editorInput, document, textSelection, shell);
    }

    private void initializeModelDefaults(J2EEReferenceSnippetDataModel model, IEditorInput editorInput) {
        if (!model.isSet("J2EEReferenceSnippetDataModel.selectedCompilationUnit")) {
            IResource resource;
            ICompilationUnit cu = JavaUI.getWorkingCopyManager().getWorkingCopy(editorInput);
            if (cu != null) {
                model.setProperty("J2EEReferenceSnippetDataModel.selectedCompilationUnit", cu);
            } else if (!model.isSet("J2EEReferenceSnippetDataModel.project") && (resource = (IResource)editorInput.getAdapter(IResource.class)) != null) {
                model.setProperty("J2EEReferenceSnippetDataModel.project", resource.getProject());
            }
        }
    }

    public void invokeJ2EEReferenceSnippet(String key, J2EEReferenceSnippetDataModel model, IEditorInput editorInput, IDocument document, ITextSelection textSelection, Shell shell) {
        if (key == null || editorInput == null || document == null || textSelection == null) {
            return;
        }
        this.initializeModelDefaults(model, editorInput);
        if (this.launchReferneceWizard(key, model, shell)) {
            JavaInsertionHelper helper = this.createJavaInsertionHelper(key, model);
            this.insertJavaSnippets(helper, editorInput, document, textSelection);
        }
    }

    public J2EEReferenceSnippetDataModel createReferenceSnippetModel(String key) {
        J2EEReferenceSnippetFactory factory = this.getFactory(key);
        if (factory == null) {
            return null;
        }
        return factory.createModel();
    }

    public JavaInsertionHelper createJavaInsertionHelper(String key, J2EEReferenceSnippetDataModel model) {
        J2EEReferenceSnippetFactory factory = this.getFactory(key);
        if (factory == null) {
            return null;
        }
        return factory.createJavaInsertionHelper(model);
    }

    public boolean launchReferneceWizard(String key, J2EEReferenceSnippetDataModel model, Shell shell) {
        IWizard wizard = this.createReferenceWizard(key, model);
        return this.launchClosableWizard(wizard, shell);
    }

    private IWizard createReferenceWizard(String key, J2EEReferenceSnippetDataModel model) {
        J2EEReferenceSnippetFactory factory = this.getFactory(key);
        if (factory == null) {
            return null;
        }
        return factory.createWizard(model);
    }

    public void insertJavaSnippets(JavaInsertionHelper helper, IEditorInput editorInput, IDocument document, ITextSelection textSelection) {
        if (helper == null || !helper.canInsertText()) {
            return;
        }
        JavaInsertionOperation op = new JavaInsertionOperation(helper, editorInput, document, textSelection);
        try {
            op.run(null);
        }
        catch (Exception e) {
            ReferenceSnippetsPlugin.logError(e);
        }
    }

    private boolean launchClosableWizard(IWizard wizard, Shell shell) {
        if (wizard == null) {
            return false;
        }
        ClosableWizardDialog dialog = new ClosableWizardDialog(shell, wizard);
        int result = dialog.open();
        return result != 1;
    }

    private J2EEReferenceSnippetFactory getFactory(String key) {
        return (J2EEReferenceSnippetFactory)this.getFactories().get(key);
    }

    private Map getFactories() {
        if (this.factories == null) {
            this.factories = new HashMap();
            this.initializeFactories();
        }
        return this.factories;
    }

    private void initializeFactories() {
        RegistryReader reader = new RegistryReader("com.ibm.etools.j2ee.reference.snippets", FACTORY_EXT_PT){

            public boolean readElement(IConfigurationElement element) {
                if (element.getName().equals(J2EEReferenceSnippetManager.FACTORY_EXT_ELEMENT)) {
                    return J2EEReferenceSnippetManager.this.addFactory(element);
                }
                return false;
            }
        };
        reader.readRegistry();
    }

    protected boolean addFactory(IConfigurationElement element) {
        String id = element.getAttribute(FACTORY_ID_ATT);
        if (id == null) {
            return false;
        }
        J2EEReferenceSnippetFactory factory = this.createFactory(element);
        if (factory == null) {
            return false;
        }
        this.factories.put(id, factory);
        return true;
    }

    private J2EEReferenceSnippetFactory createFactory(IConfigurationElement element) {
        try {
            return (J2EEReferenceSnippetFactory)element.createExecutableExtension(FACTORY_CLASS_ATT);
        }
        catch (CoreException e) {
            ReferenceSnippetsPlugin.logError("[J2EEReferenceSnippetFactory]" + ReferenceSnippetsPlugin.getString("J2EEReferenceSnippetManager_UI_0", new Object[]{element.getAttribute(FACTORY_CLASS_ATT)}));
            ReferenceSnippetsPlugin.logError(e);
            return null;
        }
    }
}

