/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.reference.snippets;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.j2ee.reference.snippets.ReferenceSnippetsPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public abstract class J2EEReferenceSnippetDataModel
extends WTPOperationDataModel {
    private HashMap earArtifactEditsMap = null;
    private ArtifactEdit artifactEdit = null;
    public static final String OWNER = "J2EEReferenceSnippetDataModel.owner";
    public static final String OWNER_LBL = "J2EEReferenceSnippetDataModel.ownerLabel";
    public static final String PROJECT = "J2EEReferenceSnippetDataModel.project";
    public static final String SELECTED_COMPILATIONUNIT = "J2EEReferenceSnippetDataModel.selectedCompilationUnit";
    public static final String NAME_SERVICE_TYPE = "J2EEReferenceSnippetDataModel.nameServiceType";
    public static final String PROVIDER_URL = "J2EEReferenceSnippetDataModel.providerURL";
    public static final String USE_CONTEXT_PROPS = "J2EEReferenceSnippetDataModel.useContextProperties";
    public static final String SELECTED_REFERENCE = "J2EEReferenceSnippetDataModel.selectedReference";
    private static final String DEFAULT_PROV_URL = "iiop:///";
    private static final String DEFAULT_NAME_SERV_TYPE = "com.ibm.websphere.naming.WsnInitialContextFactory";
    private boolean useDefaultContextProperties = true;
    protected List applications;
    protected Map appsToModuleRoots;
    protected Map moduleRootsToApps;
    private boolean in50EAR = false;

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(OWNER);
        this.addValidBaseProperty(OWNER_LBL);
        this.addValidBaseProperty(NAME_SERVICE_TYPE);
        this.addValidBaseProperty(PROJECT);
        this.addValidBaseProperty(SELECTED_COMPILATIONUNIT);
        this.addValidBaseProperty(PROVIDER_URL);
        this.addValidBaseProperty(SELECTED_REFERENCE);
        this.addValidBaseProperty(USE_CONTEXT_PROPS);
    }

    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(NAME_SERVICE_TYPE)) {
            return null;
        }
        if (propertyName.equals(PROVIDER_URL)) {
            return null;
        }
        if (propertyName.equals(PROJECT)) {
            return this.getDefaultProject();
        }
        if (propertyName.equals(OWNER)) {
            return this.getDefaultOwner();
        }
        if (propertyName.equals(USE_CONTEXT_PROPS)) {
            return new Boolean(!this.useDefaultContextProperties);
        }
        return super.getDefaultProperty(propertyName);
    }

    protected EObject getDefaultOwner() {
        IProject proj = (IProject)this.getProperty(PROJECT);
        if (proj != null && this.getProperty(SELECTED_COMPILATIONUNIT) != null) {
            EJBJar jar;
            String projectTypeId;
            CompilationUnit cu = (CompilationUnit)this.getProperty(SELECTED_COMPILATIONUNIT);
            if (this.artifactEdit == null) {
                this.artifactEdit = ArtifactEdit.getArtifactEditForRead((IProject)proj);
            }
            if ((projectTypeId = J2EEProjectUtilities.getJ2EEProjectType((IProject)proj)).equals("jst.appclient") || projectTypeId.equals("jst.web")) {
                return this.artifactEdit.getContentModelRoot();
            }
            if (projectTypeId.equals("jst.ejb") && (jar = (EJBJar)this.artifactEdit.getContentModelRoot()) != null) {
                int index = cu.getElementName().indexOf(46);
                String className = cu.getElementName();
                if (index > 0) {
                    className = className.substring(0, index);
                }
                JavaClass javaClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(cu.getParent().getElementName(), className, jar.eResource().getResourceSet());
                return jar.getEnterpriseBeanWithReference(javaClass);
            }
        }
        return null;
    }

    protected Object getDefaultProject() {
        ICompilationUnit cu = (ICompilationUnit)this.getProperty(SELECTED_COMPILATIONUNIT);
        if (cu != null) {
            return cu.getJavaProject().getProject();
        }
        return null;
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        if (propertyName.equals(OWNER_LBL)) {
            return false;
        }
        boolean notify = super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals(SELECTED_REFERENCE)) {
            this.selectedReferenceChanged();
        } else if (propertyName.equals(USE_CONTEXT_PROPS)) {
            boolean val = (Boolean)propertyValue;
            this.useDefaultContextProperties = !val;
            this.notifyEnablementChange(NAME_SERVICE_TYPE);
            this.notifyEnablementChange(PROVIDER_URL);
            if (!this.useDefaultContextProperties) {
                this.removeNameServiceValues();
                this.removeProviderURLValues();
            } else {
                this.setProperty(NAME_SERVICE_TYPE, DEFAULT_NAME_SERV_TYPE);
                this.setProperty(PROVIDER_URL, DEFAULT_PROV_URL);
            }
        }
        return notify;
    }

    private void removeNameServiceValues() {
        if (this.isSet(NAME_SERVICE_TYPE)) {
            this.setProperty(NAME_SERVICE_TYPE, null);
        }
    }

    private void removeProviderURLValues() {
        if (this.isSet(PROVIDER_URL)) {
            this.setProperty(PROVIDER_URL, null);
        }
    }

    protected Boolean basicIsEnabled(String propertyName) {
        boolean val = (Boolean)this.getProperty(USE_CONTEXT_PROPS);
        if (propertyName.equals(NAME_SERVICE_TYPE)) {
            return val ? Boolean.FALSE : Boolean.TRUE;
        }
        if (propertyName.equals(PROVIDER_URL)) {
            return val ? Boolean.FALSE : Boolean.TRUE;
        }
        return super.basicIsEnabled(propertyName);
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(SELECTED_REFERENCE)) {
            return this.validateSelectedReference();
        }
        if (propertyName.equals(OWNER)) {
            return this.validateSelectedOwner();
        }
        return super.doValidateProperty(propertyName);
    }

    protected void selectedReferenceChanged() {
        this.resetContextLookupProperties();
    }

    public List getReferencedApplications() {
        if (this.applications == null) {
            this.initializeReferencedApplications();
        }
        return this.applications;
    }

    protected void initializeReferencedApplications() {
        this.applications = new ArrayList();
        this.appsToModuleRoots = new HashMap();
        this.moduleRootsToApps = new HashMap();
        IProject selectedProject = (IProject)this.getProperty(PROJECT);
        IProject[] projects = J2EEProjectUtilities.getReferencingEARProjects((IProject)selectedProject);
        int i = 0;
        while (i < projects.length) {
            EARArtifactEdit edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)projects[i]);
            if (edit != null) {
                Application app = edit.getApplication();
                if (app == null && JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)projects[i]).equals("5.0")) {
                    this.in50EAR = true;
                } else {
                    this.in50EAR = false;
                    this.applications.add(app);
                    this.initializeModulesMaps(app, edit);
                    if (this.earArtifactEditsMap == null) {
                        this.earArtifactEditsMap = new HashMap();
                        this.earArtifactEditsMap.put(app, edit);
                    }
                }
            }
            ++i;
        }
    }

    protected void initializeModulesMaps(Application app, EARArtifactEdit edit) {
        EList mods = app.getModules();
        ArrayList<EObject> modRoots = new ArrayList<EObject>(mods.size());
        int i = 0;
        while (i < mods.size()) {
            EObject root;
            Module mod = (Module)mods.get(i);
            if (!mod.isConnectorModule() && (root = this.getRoot(mod, edit)) != null) {
                modRoots.add(root);
                this.moduleRootsToApps.put(root, app);
            }
            ++i;
        }
        this.appsToModuleRoots.put(app, modRoots.toArray());
    }

    protected EObject getRoot(Module mod, EARArtifactEdit earEdit) {
        IVirtualComponent comp;
        ArtifactEdit edit;
        String compName = mod.getUri().substring(0, mod.getUri().indexOf(46));
        IVirtualReference ref = earEdit.getComponentReference(compName);
        if (ref != null && (edit = EnterpriseArtifactEdit.getArtifactEditForRead((IVirtualComponent)(comp = ref.getReferencedComponent()))) != null) {
            return edit.getContentModelRoot();
        }
        return null;
    }

    public void resetContextLookupProperties() {
        this.setProperty(NAME_SERVICE_TYPE, null);
        this.setProperty(PROVIDER_URL, null);
    }

    public void setInitialContextLookupProperties() {
        this.setBooleanProperty(USE_CONTEXT_PROPS, false);
        this.setProperty(NAME_SERVICE_TYPE, DEFAULT_NAME_SERV_TYPE);
        this.setProperty(PROVIDER_URL, DEFAULT_PROV_URL);
    }

    public IStatus validateSelectedReference() {
        EObject selectedRef = (EObject)this.getProperty(SELECTED_REFERENCE);
        if (selectedRef == null && this.in50EAR) {
            return this.getNoDDMsg();
        }
        if (selectedRef == null) {
            return new Status(4, "com.ibm.etools.j2ee.reference.snippets", 0, this.getMissingReferenceMessage(), null);
        }
        return J2EEPlugin.OK_STATUS;
    }

    protected abstract String getMissingReferenceMessage();

    public IStatus validateSelectedOwner() {
        if (this.getProperty(SELECTED_REFERENCE) != null) {
            return J2EEPlugin.OK_STATUS;
        }
        EObject owner = (EObject)this.getProperty(OWNER);
        if (owner == null && this.in50EAR) {
            return this.getNoDDMsg();
        }
        if (owner == null) {
            return new Status(4, "com.ibm.etools.j2ee.reference.snippets", 0, this.getMissingOwnerMessage(), null);
        }
        if (!this.isValidOwner(owner)) {
            return new Status(4, "com.ibm.etools.j2ee.reference.snippets", 0, this.getInvalidOwnerMessage(), null);
        }
        return J2EEPlugin.OK_STATUS;
    }

    protected abstract String getInvalidOwnerMessage();

    protected abstract String getMissingOwnerMessage();

    protected boolean isValidOwner(EObject owner) {
        return owner instanceof EnterpriseBean || owner instanceof WebApp || owner instanceof ApplicationClient;
    }

    public List getApplications() {
        if (this.applications == null) {
            this.initializeReferencedApplications();
        }
        return this.applications;
    }

    public Object[] getModuleRoots(Application app) {
        Object[] result = null;
        if (app != null) {
            result = (Object[])this.appsToModuleRoots.get(app);
        }
        if (result == null) {
            result = new Object[]{};
        }
        return result;
    }

    public Application getApplication(EObject moduleRoot) {
        if (moduleRoot != null) {
            return (Application)this.moduleRootsToApps.get(moduleRoot);
        }
        return null;
    }

    public abstract boolean requiresContextProperties();

    public boolean hasContextProperties() {
        String providerURL;
        if (this.requiresContextProperties() && (providerURL = (String)this.getProperty(PROVIDER_URL)) != null && providerURL.length() > 0) {
            String nameServiceType = (String)this.getProperty(NAME_SERVICE_TYPE);
            return nameServiceType != null && nameServiceType.length() > 0;
        }
        return false;
    }

    public WTPOperation getDefaultOperation() {
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.earArtifactEditsMap != null) {
            this.earArtifactEditsMap.clear();
            this.earArtifactEditsMap = null;
        }
        if (this.artifactEdit != null) {
            this.artifactEdit.dispose();
            this.artifactEdit = null;
        }
    }

    private IStatus getNoDDMsg() {
        return new Status(4, "com.ibm.etools.j2ee.reference.snippets", 0, ReferenceSnippetsPlugin.getResourceString("NO_DD"), null);
    }
}

