/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.insertion;

import com.ibm.etools.j2ee.internal.java.insertion.JavaInsertionHelper;
import com.ibm.etools.j2ee.reference.snippets.ReferenceSnippetsPlugin;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;

public class JavaInsertionOperation
implements IHeadlessRunnableWithProgress {
    private static final String NEW_LINE = System.getProperty("line.separator");
    protected JavaInsertionHelper insertionHelper;
    protected IEditorInput editorInput;
    protected IDocument document;
    protected ITextSelection textSelection;
    protected IProgressMonitor monitor;

    public JavaInsertionOperation(JavaInsertionHelper insertionHelper, IEditorInput editorInput, IDocument document, ITextSelection textSelection) {
        this.insertionHelper = insertionHelper;
        this.editorInput = editorInput;
        this.document = document;
        this.textSelection = textSelection;
    }

    public void run(IProgressMonitor monitorArg) throws InvocationTargetException, InterruptedException {
        this.monitor = monitorArg;
        this.insertCodeSnippet();
        this.processJavaHelper();
    }

    protected void insertCodeSnippet() throws InvocationTargetException {
        String replacementString = this.insertionHelper.getInsertionString();
        if (replacementString == null || replacementString.length() == 0) {
            return;
        }
        if (this.textSelection == null) {
            throw new RuntimeException("No text selection for inserting text.");
        }
        try {
            this.document.replace(this.textSelection.getOffset(), this.textSelection.getLength(), replacementString);
        }
        catch (BadLocationException e) {
            throw new InvocationTargetException(e);
        }
        int start = this.textSelection.getStartLine();
        int lines = this.document.computeNumberOfLines(replacementString) + 1;
        this.format(this.document, start, lines, 0);
    }

    protected void processJavaHelper() {
        ICompilationUnit cu = JavaUI.getWorkingCopyManager().getWorkingCopy(this.editorInput);
        if (cu != null) {
            IType type = null;
            try {
                type = cu.getTypes()[0];
            }
            catch (JavaModelException javaModelException) {}
            if (type != null) {
                if (this.insertionHelper.hasFields()) {
                    this.createFields(type, this.insertionHelper.getFields());
                }
                if (this.insertionHelper.hasMethods()) {
                    this.createMethods(type, this.insertionHelper.getMethods());
                }
                if (this.insertionHelper.hasImports()) {
                    this.createImports(cu, this.insertionHelper.getImportStatements());
                }
                this.executeExtendedOperations();
            }
        }
    }

    private void executeExtendedOperations() {
        List ops = this.insertionHelper.getExtendedOperations();
        if (ops != null) {
            int i = 0;
            while (i < ops.size()) {
                this.executedExtendedOperation((IHeadlessRunnableWithProgress)ops.get(i));
                ++i;
            }
        }
    }

    private void executedExtendedOperation(IHeadlessRunnableWithProgress operation) {
        try {
            operation.run(null);
        }
        catch (Exception e) {
            ReferenceSnippetsPlugin.logError("Executing extended operation failed:  " + operation, e);
        }
    }

    protected void createFields(IType aType, List fields) {
        int i = 0;
        while (i < fields.size()) {
            IDOMField field = (IDOMField)fields.get(i);
            if (!aType.getField(field.getName()).exists()) {
                try {
                    aType.createField(this.format(field.getContents(), 1, true), null, true, null);
                }
                catch (JavaModelException e) {
                    ReferenceSnippetsPlugin.logError((CoreException)e);
                }
            }
            ++i;
        }
    }

    protected void createMethods(IType aType, List methods) {
        int i = 0;
        while (i < methods.size()) {
            IDOMMethod method = (IDOMMethod)methods.get(i);
            if (!aType.getMethod(method.getName(), this.getParamaterTypeSignatures(method)).exists()) {
                try {
                    aType.createMethod(this.format(method.getContents(), 1, true), null, true, null);
                }
                catch (JavaModelException e) {
                    ReferenceSnippetsPlugin.logError((CoreException)e);
                }
            }
            ++i;
        }
    }

    protected void createImports(ICompilationUnit cu, List imports) {
        int i = 0;
        while (i < imports.size()) {
            String importStmt = (String)imports.get(i);
            if (!cu.getImport(importStmt).exists() && !importStmt.startsWith("java.lang")) {
                try {
                    cu.createImport(importStmt, null, null);
                }
                catch (JavaModelException e) {
                    ReferenceSnippetsPlugin.logError((CoreException)e);
                }
            }
            ++i;
        }
    }

    protected String format(String contents, int indent, boolean ensureEndLineReturn) {
        Document doc = new Document(contents);
        int lines = doc.getNumberOfLines();
        this.format((IDocument)doc, 0, lines - 1, indent);
        String result = doc.get();
        if (ensureEndLineReturn) {
            result = this.ensureLineReturn(result);
        }
        return result;
    }

    protected void format(IDocument documentArg, int startLine, int lines, int indent) {
        try {
            int end = documentArg.getLineOffset(startLine + lines);
            int length = end - startLine;
            CodeFormatter formatter = ToolFactory.createCodeFormatter(null);
            TextEdit edit = formatter.format(0, documentArg.get(), startLine, length, indent, null);
            if (edit != null) {
                try {
                    edit.apply(documentArg);
                }
                catch (MalformedTreeException malformedTreeException) {}
            }
        }
        catch (BadLocationException e) {
            ReferenceSnippetsPlugin.logError("Failed to format text.");
            ReferenceSnippetsPlugin.logError(e);
        }
    }

    protected String formatString(String pattern, String[] arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    protected String ensureLineReturn(String aString) {
        if (!aString.endsWith(NEW_LINE)) {
            return String.valueOf(aString) + NEW_LINE;
        }
        return aString;
    }

    protected String[] getParamaterTypeSignatures(IDOMMethod aMethod) {
        String[] result = null;
        String[] parms = aMethod.getParameterTypes();
        if (parms != null) {
            result = parms.length == 0 ? parms : new String[parms.length];
            boolean isResolved = false;
            int i = 0;
            while (i < parms.length) {
                String parm = parms[i];
                isResolved = parm.indexOf(46) > 0;
                result[i] = Signature.createTypeSignature((String)parm, (boolean)isResolved);
                ++i;
            }
        }
        return result;
    }
}

