/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.validation;

import com.ibm.etools.j2ee.ILibModule;
import com.ibm.etools.j2ee.internal.project.BinaryProjectVirtualComponent;
import com.ibm.etools.j2ee.migration.internal.OldJ2EESettings;
import com.ibm.etools.j2ee.migration.internal.OldWebSettings;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import com.ibm.etools.j2ee.migration.validation.AbstractJ2EEValidator;
import com.ibm.etools.j2ee.migration.validation.ValidationMessages;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class WebForwardConsistencyValidator
extends AbstractJ2EEValidator {
    public static final String ID = "WebForwardConsistencyValidator";

    protected void doValidate(IProject project, IProgressMonitor subMonitor) {
        Set hasNatures = this.hasNatures(project, webNatureSet);
        if (hasNatures.isEmpty()) {
            this.reportInformation(ValidationMessages.WebForwardValidator_not_backlevel_web);
            return;
        }
        for (String natureID : hasNatures) {
            this.reportInformation(NLS.bind((String)ValidationMessages.WebForwardValidator_backlevel_web_nature, (Object)natureID));
        }
        HashSet incompatibleNatures = new HashSet();
        incompatibleNatures.addAll(earNatureSet);
        incompatibleNatures.addAll(appClientNatureSet);
        incompatibleNatures.addAll(ejbNatureSet);
        incompatibleNatures.addAll(rarNatureSet);
        this.reportIncompatibleNatures(project, incompatibleNatures);
        if (!this.didRequiresValidatorsSucceed()) {
            return;
        }
        if (!this.verifyFacetedComponentProject(project, WEB_FACET)) {
            return;
        }
        IFile dotJ2EE = project.getFile(".j2ee");
        if (!dotJ2EE.exists()) {
            boolean foundV6Nature;
            boolean bl = foundV6Nature = !this.hasNatures(project, v6NatureSet).isEmpty();
            if (foundV6Nature) {
                this.reportWarning(ValidationMessages.WebForwardValidator_missing_j2ee_file);
            }
        } else {
            IProjectFacetVersion facetVersion;
            OldJ2EESettings j2eeSetting = new OldJ2EESettings(project);
            int dotJ2EEModuleVersion = j2eeSetting.getModuleVersion();
            String dotJ2EEModuleVersionString = J2EEVersionUtil.convertVersionIntToString((int)dotJ2EEModuleVersion);
            if (dotJ2EEModuleVersionString.equals((facetVersion = this.getFacetVersion(project, WEB_FACET)).getVersionString())) {
                this.reportSuccess(ValidationMessages.WebForwardValidator_web_facet_consistent);
            } else {
                this.reportWarning(NLS.bind((String)ValidationMessages.WebForwardValidator_web_facet_inconsistent, (Object[])new Object[]{dotJ2EEModuleVersion, facetVersion.getVersionString()}));
                this.reportWarning(ValidationMessages.J2EEMigrationValidation_remove_obsolete_data);
            }
        }
        try {
            this.reportInformation(ValidationMessages.WebForwardValidator_checking_weblib_dependencies);
            IFile dotWebLibs = project.getFile(".websettings");
            if (!dotWebLibs.exists()) {
                this.reportWarning(ValidationMessages.WebForwardValidator_websettings_missing);
            } else {
                OldWebSettings webSettings = new OldWebSettings(project);
                IVirtualComponent webComponent = ComponentCore.createComponent((IProject)project);
                IVirtualReference[] references = webComponent.getReferences();
                ILibModule[] libModules = webSettings.getLibModules();
                int i = 0;
                while (i < libModules.length) {
                    IProject proj = libModules[i].getProject();
                    if (proj != null) {
                        this.validateDependency(proj, references);
                    } else if (libModules[i].getProjectName() != null) {
                        this.reportWarning(NLS.bind((String)ValidationMessages.WebForwardValidator_weblib_dependent_unresolved, (Object)libModules[i].getProjectName()));
                    }
                    ++i;
                }
            }
        }
        finally {
            this.reportInformation(ValidationMessages.WebForwardValidator_finished_weblib_check);
        }
    }

    protected void validateDependency(IProject dependentProject, IVirtualReference[] references) {
        if (dependentProject.isAccessible()) {
            if (!BinaryProjectVirtualComponent.isBinaryProject((IProject)dependentProject)) {
                boolean foundReference = false;
                int i = 0;
                while (i < references.length && !foundReference) {
                    if (references[i].getReferencedComponent().getProject().equals((Object)dependentProject) && references[i].getRuntimePath().toString().startsWith("/WEB-INF/lib")) {
                        foundReference = true;
                    }
                    ++i;
                }
                if (foundReference) {
                    this.reportSuccess(NLS.bind((String)ValidationMessages.WebForwardValidator_verified_dependency, (Object)dependentProject.getName()));
                    boolean foundFacet = false;
                    boolean isFacetedProject = false;
                    String foundFacetType = "jst.utility";
                    try {
                        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)foundFacetType);
                        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)dependentProject);
                        boolean bl = isFacetedProject = facetedProject != null;
                        if (facetedProject != null) {
                            if (isFacetedProject) {
                                foundFacet = facetedProject.hasProjectFacet(facet);
                            }
                            if (!foundFacet) {
                                foundFacetType = "jst.java";
                                IProjectFacet javaFacet = ProjectFacetsManager.getProjectFacet((String)foundFacetType);
                                foundFacet = facetedProject.hasProjectFacet(javaFacet);
                            }
                        }
                    }
                    catch (Exception e) {
                        J2EEMigrationPlugin.logError(e);
                    }
                    if (foundFacet) {
                        this.reportSuccess(NLS.bind((String)ValidationMessages.WebForwardValidator_dependent_type_valid, (Object[])new Object[]{dependentProject.getName(), foundFacetType}));
                    } else if (isFacetedProject) {
                        this.reportSuccess(NLS.bind((String)ValidationMessages.WebForwardValidator_dependent_facet_valid, (Object)dependentProject.getName()));
                        this.reportError(NLS.bind((String)ValidationMessages.WebForwardValidator_dependent_type_invalid, (Object[])new Object[]{dependentProject.getName(), foundFacetType}));
                    } else {
                        this.reportError(NLS.bind((String)ValidationMessages.WebForwardValidator_dependent_facet_invalid, (Object)dependentProject.getName()));
                    }
                } else if (ComponentCore.createComponent((IProject)dependentProject) != null) {
                    this.reportError(NLS.bind((String)ValidationMessages.WebForwardValidator_component_missing_weblib, (Object)dependentProject.getName()));
                    this.reportError(ValidationMessages.J2EEMigrationValidation_add_dependency);
                } else {
                    this.reportError(NLS.bind((String)ValidationMessages.WebForwardValidator_weblib_not_component_proj, (Object)dependentProject.getName()));
                    this.reportError(ValidationMessages.J2EEMigrationValidation_add_dependency);
                }
            }
        } else if (!dependentProject.exists()) {
            this.reportWarning(NLS.bind((String)ValidationMessages.WebForwardValidator_websettings_weblib_unresolved, (Object)dependentProject.getName()));
        } else {
            this.reportWarning(NLS.bind((String)ValidationMessages.WebForwardValidator_websettings_weblib_closed, (Object)dependentProject.getName()));
        }
    }

    public String getName() {
        return "Web Forward Consistency";
    }
}

