/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.validation;

import com.ibm.etools.j2ee.migration.validation.AbstractJ2EEValidator;
import com.ibm.etools.j2ee.migration.validation.ValidationMessages;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class WebConsistencyValidator
extends AbstractJ2EEValidator {
    public static final String ID = "WebConsistencyValidator";
    protected static final Set validWebLibFacets = new HashSet();

    static {
        validWebLibFacets.add(UTILITY_FACET);
        validWebLibFacets.add(APPCLIENT_FACET);
        validWebLibFacets.add(EJB_FACET);
    }

    protected void doValidate(IProject project, IProgressMonitor subMonitor) {
        if (!this.checkForFacetedComponentProject(project, WEB_FACET, ValidationMessages.WebConsistencyValidator_not_web_project)) {
            IVirtualComponent component;
            IVirtualFile vDDFile;
            if (this.canLoadComponent(project) && !this.canLoadFacets(project) && (vDDFile = (component = ComponentCore.createComponent((IProject)project)).getRootFolder().getFile("WEB-INF/web.xml")).exists()) {
                this.reportError(NLS.bind((String)ValidationMessages.WebConsistencyValidator_contains_file, (Object)vDDFile.getUnderlyingFile().getProjectRelativePath()));
            }
            return;
        }
        HashSet<IProjectFacet> incompatibleFacets = new HashSet<IProjectFacet>();
        incompatibleFacets.add(EJB_FACET);
        incompatibleFacets.add(STATICWEB_FACET);
        incompatibleFacets.add(APPCLIENT_FACET);
        incompatibleFacets.add(EAR_FACET);
        incompatibleFacets.add(JCA_FACET);
        incompatibleFacets.add(UTILITY_FACET);
        this.reportIncompatibleFacets(project, incompatibleFacets);
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        String ddVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
        int j2eeVersion = J2EEVersionUtil.convertVersionStringToInt((String)ddVersion);
        if (j2eeVersion < 25) {
            IVirtualFile vDDFile = component.getRootFolder().getFile("WEB-INF/web.xml");
            if (vDDFile.exists()) {
                this.reportInformation(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_found_file, (Object)vDDFile.getUnderlyingFile().getProjectRelativePath()));
            } else {
                this.reportError(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_not_properly_mapped, (Object)vDDFile.getRuntimePath()));
                return;
            }
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object mObj = provider.getModelObject();
        boolean modelLoaded = false;
        if (mObj != null && provider.getModelObject((IPath)new Path("WEB-INF/web.xml")) != null) {
            modelLoaded = true;
        }
        if (!modelLoaded) {
            this.reportError(ValidationMessages.WebConsistencyValidator_failed_xml_load);
        } else {
            this.reportSuccess(ValidationMessages.WebConsistencyValidator_success_xml_load);
            IProjectFacetVersion webFacetVersion = this.getFacetVersion(project, WEB_FACET);
            this.verifyCorrectVersion(webFacetVersion, ddVersion);
        }
        IVirtualReference[] libModules = WebUtilities.getLibModules((IProject)project);
        int i = 0;
        while (i < libModules.length) {
            IVirtualComponent libModule = libModules[i].getReferencedComponent();
            if (libModule != null) {
                IProject libProject = libModule.getProject();
                if (!libProject.isOpen()) {
                    this.reportError(NLS.bind((String)ValidationMessages.WebConsistencyValidator_weblib_ref_closed_proj, (Object)libProject.getName()));
                } else if (!libProject.exists()) {
                    this.reportError(NLS.bind((String)ValidationMessages.WebConsistencyValidator_weblib_ref_missing_proj, (Object)libProject.getName()));
                } else if (!libProject.equals((Object)project)) {
                    this.reportInformation(NLS.bind((String)ValidationMessages.WebConsistencyValidator_found_weblib_proj, (Object)libProject.getName()));
                    this.verifyReferencedProjectContainsAnyFacet(libProject, validWebLibFacets);
                }
            } else {
                this.reportError(NLS.bind((String)ValidationMessages.WebConsistencyValidator_found_null_weblib, (Object)libModules[i]));
            }
            ++i;
        }
    }

    private void verifyCorrectVersion(IProjectFacetVersion facetVersion, String ddStrVersion) {
        if (facetVersion.getVersionString().equals(ddStrVersion)) {
            this.reportSuccess(NLS.bind((String)ValidationMessages.WebConsistencyValidator_versions_equal, (Object)ddStrVersion));
        } else {
            this.reportError(NLS.bind((String)ValidationMessages.WebConsistencyValidator_versions_differ, (Object[])new Object[]{facetVersion.getVersionString(), ddStrVersion}));
        }
    }

    public String getName() {
        return "Web Consistency";
    }
}

