/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.validation;

import com.ibm.etools.j2ee.migration.validation.AbstractJ2EEValidator;
import com.ibm.etools.j2ee.migration.validation.ValidationMessages;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class OrphanedJ2EEMetaDataValidator
extends AbstractJ2EEValidator {
    public static final String ID = "OrphanedJ2EEMetaDataValidator";
    public static final String J2EE_FILE = ".j2ee";
    public static final String WEBSETTINGS = ".websettings";
    public static final String MODULE_MAPS = "META-INF/.modulemaps";

    protected void doValidate(IProject project, IProgressMonitor subMonitor) {
        Iterator iterator;
        StringBuffer natureListBuffer;
        IFile dotJ2EE = project.getFile(J2EE_FILE);
        IFile dotModuleMaps = project.getFile(MODULE_MAPS);
        HashSet allBackLevelNatures = new HashSet();
        allBackLevelNatures.addAll(earNatureSet);
        allBackLevelNatures.addAll(appClientNatureSet);
        allBackLevelNatures.addAll(webNatureSet);
        allBackLevelNatures.addAll(ejbNatureSet);
        allBackLevelNatures.addAll(rarNatureSet);
        allBackLevelNatures.addAll(staticWebSet);
        Set foundBackLevelJ2EENatures = this.hasNatures(project, allBackLevelNatures);
        if (foundBackLevelJ2EENatures.isEmpty()) {
            natureListBuffer = new StringBuffer();
            Iterator iterator2 = allBackLevelNatures.iterator();
            while (iterator2.hasNext()) {
                natureListBuffer.append(iterator2.next());
                if (!iterator2.hasNext()) continue;
                natureListBuffer.append(", ");
            }
            if (dotJ2EE.exists() || dotModuleMaps.exists()) {
                if (dotJ2EE.exists()) {
                    this.reportWarning(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_no_backlevel_natures, (Object[])new Object[]{natureListBuffer, J2EE_FILE}));
                    this.reportWarning(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_no_backlevel_delete, (Object)J2EE_FILE));
                }
                if (dotModuleMaps.exists()) {
                    StringBuffer earNatureListBuffer = new StringBuffer();
                    Iterator iterator3 = earNatureSet.iterator();
                    while (iterator3.hasNext()) {
                        earNatureListBuffer.append(iterator3.next());
                        if (!iterator3.hasNext()) continue;
                        earNatureListBuffer.append(", ");
                    }
                    this.reportWarning(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_no_backlevel_natures, (Object[])new Object[]{earNatureListBuffer, MODULE_MAPS}));
                    this.reportWarning(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_no_backlevel_delete, (Object)MODULE_MAPS));
                }
            } else {
                this.reportSuccess(ValidationMessages.OrphanedJ2EEValidator_valid_j2ee_file);
            }
        } else {
            boolean foundV6Nature;
            natureListBuffer = new StringBuffer();
            Iterator iterator4 = foundBackLevelJ2EENatures.iterator();
            while (iterator4.hasNext()) {
                natureListBuffer.append(iterator4.next());
                if (!iterator4.hasNext()) continue;
                natureListBuffer.append(", ");
            }
            boolean isEAR = !this.hasNatures(project, earNatureSet).isEmpty();
            boolean allOK = true;
            boolean bl = foundV6Nature = !this.hasNatures(project, v6NatureSet).isEmpty();
            if (!dotJ2EE.exists() && foundV6Nature) {
                allOK = false;
                this.reportWarning(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_remove_old_natures, (Object[])new Object[]{natureListBuffer, J2EE_FILE}));
                this.reportWarning(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_remove_backward_compat, (Object)J2EE_FILE));
            }
            if (isEAR) {
                if (!dotModuleMaps.exists()) {
                    allOK = false;
                    StringBuffer earNatureListBuffer = new StringBuffer();
                    Iterator iterator5 = earNatureSet.iterator();
                    while (iterator5.hasNext()) {
                        earNatureListBuffer.append(iterator5.next());
                        if (!iterator5.hasNext()) continue;
                        earNatureListBuffer.append(", ");
                    }
                    this.reportWarning(ValidationMessages.OrphanedJ2EEValidator_no_modulemaps_found);
                    this.reportWarning(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_modulemaps_should_exist, (Object)earNatureListBuffer));
                    this.reportWarning(ValidationMessages.OrphanedJ2EEValidator_no_modulemaps_remove_compat);
                }
            } else if (dotModuleMaps.exists()) {
                allOK = false;
                this.reportWarning(ValidationMessages.OrphanedJ2EEValidator_not_ear_project);
            }
            if (allOK && !isEAR) {
                this.reportSuccess(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_j2ee_file_consistent, (Object)natureListBuffer));
            }
            if (allOK && isEAR) {
                this.reportSuccess(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_j2ee_ear_consistent, (Object)natureListBuffer));
            }
        }
        IFile dotWebSettings = project.getFile(WEBSETTINGS);
        HashSet allWebNatures = new HashSet();
        allWebNatures.addAll(webNatureSet);
        allWebNatures.addAll(staticWebSet);
        Set foundBackLevelWebNatures = this.hasNatures(project, allWebNatures);
        if (foundBackLevelWebNatures.isEmpty()) {
            StringBuffer natureListBuffer2 = new StringBuffer();
            iterator = allWebNatures.iterator();
            while (iterator.hasNext()) {
                natureListBuffer2.append(iterator.next());
                if (!iterator.hasNext()) continue;
                natureListBuffer2.append(", ");
            }
            if (dotWebSettings.exists()) {
                this.reportWarning(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_no_backlevel_natures, (Object[])new Object[]{natureListBuffer2, WEBSETTINGS}));
                this.reportWarning(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_no_backlevel_delete, (Object)WEBSETTINGS));
            } else {
                this.reportSuccess(ValidationMessages.OrphanedJ2EEValidator_valid_websettings);
            }
        } else {
            StringBuffer natureListBuffer3 = new StringBuffer();
            iterator = foundBackLevelWebNatures.iterator();
            while (iterator.hasNext()) {
                natureListBuffer3.append(iterator.next());
                if (!iterator.hasNext()) continue;
                natureListBuffer3.append(", ");
            }
            if (!dotWebSettings.exists()) {
                this.reportWarning(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_remove_old_natures, (Object[])new Object[]{natureListBuffer3, WEBSETTINGS}));
                this.reportWarning(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_remove_backward_compat, (Object)WEBSETTINGS));
            } else {
                this.reportSuccess(NLS.bind((String)ValidationMessages.OrphanedJ2EEValidator_websettings_file_consistent, (Object)natureListBuffer3));
            }
        }
    }

    public String getName() {
        return "Orphaned J2EE Meta-Data";
    }
}

