/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.validation;

import com.ibm.etools.common.migration.validation.framework.AbstractMigrationValidator;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import com.ibm.etools.j2ee.migration.validation.ValidationMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class FacetConsistencyValidator
extends AbstractMigrationValidator {
    public static final String ID = "FacetConsistencyValidator";
    public static final String FACETS_METADATA_STR = ".settings/org.eclipse.wst.common.project.facet.core.xml";
    public static final Path FACETS_METADATA_PATH = new Path(".settings/org.eclipse.wst.common.project.facet.core.xml");

    public String getName() {
        return "Facet Consistency";
    }

    public boolean hasFacetNature(IProject project) {
        try {
            return project.getDescription().hasNature("org.eclipse.wst.common.project.facet.core.nature");
        }
        catch (CoreException e) {
            J2EEMigrationPlugin.logError(e);
            this.reportError((Exception)((Object)e));
            return false;
        }
    }

    protected void doValidate(IProject project, IProgressMonitor monitor) {
        try {
            boolean hasFacetNature = this.hasFacetNature(project);
            this.reportInformation(NLS.bind((String)ValidationMessages.ComponentConsistencyValidator_nature_exists, (Object)"org.eclipse.wst.common.project.facet.core.nature", (Object)hasFacetNature));
            IFile facetFile = project.getFile((IPath)FACETS_METADATA_PATH);
            boolean hasFacetSettingsFile = facetFile.exists();
            this.reportInformation(NLS.bind((String)ValidationMessages.ComponentConsistencyValidator_file_exists, (Object)facetFile.getProjectRelativePath(), (Object)hasFacetSettingsFile));
            boolean isFacetedProject = false;
            if (hasFacetNature == hasFacetSettingsFile) {
                if (hasFacetNature) {
                    isFacetedProject = true;
                    this.reportSuccess(ValidationMessages.ComponentConsistencyValidator_both_exist);
                } else {
                    this.reportSuccess(ValidationMessages.ComponentConsistencyValidator_neither_exist);
                }
            } else {
                if (hasFacetNature) {
                    this.reportError(NLS.bind((String)ValidationMessages.ComponentConsistencyValidator_file_missing, (Object[])new Object[]{"org.eclipse.wst.common.project.facet.core.nature", facetFile.getProjectRelativePath()}));
                } else {
                    this.reportError(NLS.bind((String)ValidationMessages.ComponentConsistencyValidator_nature_missing, (Object[])new Object[]{facetFile.getProjectRelativePath(), "org.eclipse.wst.common.project.facet.core.nature"}));
                }
                return;
            }
            if (isFacetedProject) {
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    if (facetedProject != null) {
                        this.reportSuccess(ValidationMessages.FacetConsistencyValidator_loaded_faceted_proj_success);
                    } else {
                        this.reportError(ValidationMessages.J2EEMigrationValidation_failed_facet_model_load);
                    }
                    return;
                }
                catch (CoreException e) {
                    J2EEMigrationPlugin.logError(e);
                    this.reportError(ValidationMessages.J2EEMigrationValidation_failed_facet_model_load);
                    this.reportError((Exception)((Object)e));
                }
            } else {
                this.reportInformation(ValidationMessages.FacetConsistencyValidator_loaded_faceted_proj_failed);
            }
        }
        finally {
            monitor.done();
        }
    }
}

