/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.validation;

import com.ibm.etools.j2ee.migration.validation.AbstractJ2EEValidator;
import com.ibm.etools.j2ee.migration.validation.ValidationMessages;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EJBUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class EJBConsistencyValidator
extends AbstractJ2EEValidator {
    public static final String ID = "EJBConsistencyValidator";

    protected void doValidate(IProject project, IProgressMonitor subMonitor) {
        if (!this.checkForFacetedComponentProject(project, EJB_FACET, ValidationMessages.EJBConsistencyValidator_not_ejb_project)) {
            IVirtualComponent component;
            IVirtualFile vDDFile;
            if (this.canLoadComponent(project) && !this.canLoadFacets(project) && (vDDFile = (component = ComponentCore.createComponent((IProject)project)).getRootFolder().getFile("META-INF/ejb-jar.xml")).exists()) {
                this.reportError(NLS.bind((String)ValidationMessages.EJBConsistencyValidator_contains_file, (Object)vDDFile.getUnderlyingFile().getProjectRelativePath()));
            }
            return;
        }
        HashSet<IProjectFacet> incompatibleFacets = new HashSet<IProjectFacet>();
        incompatibleFacets.add(WEB_FACET);
        incompatibleFacets.add(STATICWEB_FACET);
        incompatibleFacets.add(APPCLIENT_FACET);
        incompatibleFacets.add(EAR_FACET);
        incompatibleFacets.add(JCA_FACET);
        incompatibleFacets.add(UTILITY_FACET);
        this.reportIncompatibleFacets(project, incompatibleFacets);
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        String ddVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
        IVirtualFile vDDFile = component.getRootFolder().getFile("META-INF/ejb-jar.xml");
        boolean hasDD = true;
        if (vDDFile.exists()) {
            this.reportInformation(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_found_file, (Object)vDDFile.getUnderlyingFile().getProjectRelativePath()));
        } else {
            int j2eeVersion = J2EEVersionUtil.convertVersionStringToInt((String)ddVersion);
            if (j2eeVersion < 30) {
                this.reportError(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_not_properly_mapped, (Object)vDDFile.getRuntimePath()));
                return;
            }
            hasDD = false;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object mObj = provider.getModelObject();
        boolean modelLoaded = false;
        if (mObj != null && provider.getModelObject((IPath)new Path("META-INF/ejb-jar.xml")) != null) {
            modelLoaded = true;
        }
        if (!modelLoaded) {
            this.reportError(ValidationMessages.EJBConsistencyValidator_load_xml_failed);
        } else {
            this.reportSuccess(ValidationMessages.EJBConsistencyValidator_load_xml_passed);
            IProjectFacetVersion ejbFacetVersion = this.getFacetVersion(project, EJB_FACET);
            this.verifyCorrectVersion(ejbFacetVersion, ddVersion);
            String ejbClientJar = this.getEJBClientJar(mObj);
            if (ejbClientJar == null) {
                this.reportInformation(ValidationMessages.EJBConsistencyValidator_no_client_defined);
            } else {
                this.reportInformation(NLS.bind((String)ValidationMessages.EJBConsistencyValidator_client_is_defined, (Object)ejbClientJar));
            }
            Properties props = component.getMetaProperties();
            String clientCompName = props.getProperty("ClientProject");
            if (clientCompName == null || clientCompName.equals("")) {
                if (ejbClientJar == null) {
                    this.reportInformation(ValidationMessages.EJBConsistencyValidator_no_client_component);
                } else {
                    this.reportInformation(NLS.bind((String)ValidationMessages.EJBConsistencyValidator_using_xml_for_component, (Object)ejbClientJar));
                }
            } else {
                this.reportInformation(NLS.bind((String)ValidationMessages.EJBConsistencyValidator_client_defined_component, (Object)clientCompName));
                if (ejbClientJar == null) {
                    if (hasDD) {
                        this.reportWarning(ValidationMessages.EJBConsistencyValidator_remove_client_from_component);
                    }
                } else {
                    IProject clientProject = ResourcesPlugin.getWorkspace().getRoot().getProject(clientCompName);
                    if (clientProject == null || !clientProject.isAccessible()) {
                        if (clientProject != null && !clientProject.isOpen()) {
                            this.reportError(NLS.bind((String)ValidationMessages.EJBConsistencyValidator_ejb_proj_closed, (Object)clientCompName));
                        } else {
                            this.reportError(NLS.bind((String)ValidationMessages.EJBConsistencyValidator_ejb_proj_missing, (Object)clientCompName));
                        }
                    } else {
                        this.reportSuccess(NLS.bind((String)ValidationMessages.EJBConsistencyValidator_ejb_proj_found, (Object)clientCompName));
                    }
                }
            }
            IVirtualComponent ejbClientComponent = EJBUtilities.getEJBClientJar((IProject)project);
            if (ejbClientJar == null && ejbClientComponent == null) {
                this.reportSuccess(ValidationMessages.EJBConsistencyValidator_client_consistent);
            } else if (ejbClientJar == null && ejbClientComponent != null) {
                if (hasDD) {
                    this.reportError(NLS.bind((String)ValidationMessages.EJBConsistencyValidator_client_xml_model_inconsistent, (Object)ejbClientComponent.getProject().getName()));
                }
            } else if (ejbClientJar != null && ejbClientComponent == null) {
                this.reportError(NLS.bind((String)ValidationMessages.EJBConsistencyValidator_load_client_xml_failed, (Object)ejbClientJar));
            } else if (ejbClientComponent != null) {
                this.reportSuccess(NLS.bind((String)ValidationMessages.EJBConsistencyValidator_client_project_map, (Object[])new Object[]{ejbClientJar, ejbClientComponent.getProject().getName()}));
                this.verifyReferencedProjectContainsAnyFacet(ejbClientComponent.getProject(), Collections.singleton(UTILITY_FACET));
            }
        }
    }

    private String getEJBClientJar(Object mObj) {
        String ejbClientJar = null;
        if (mObj instanceof EJBJar) {
            EJBJar ejbjar = (EJBJar)mObj;
            ejbClientJar = ejbjar.getEjbClientJar();
        } else if (mObj instanceof org.eclipse.jst.j2ee.ejb.EJBJar) {
            org.eclipse.jst.j2ee.ejb.EJBJar ejbjar = (org.eclipse.jst.j2ee.ejb.EJBJar)mObj;
            ejbClientJar = ejbjar.getEjbClientJar();
        }
        return ejbClientJar;
    }

    private void verifyCorrectVersion(IProjectFacetVersion facetVersion, String ddStrVersion) {
        if (facetVersion.getVersionString().equals(ddStrVersion)) {
            this.reportSuccess(NLS.bind((String)ValidationMessages.EJBConsistencyValidator_ejb_versions_consistent, (Object)ddStrVersion));
        } else {
            this.reportError(NLS.bind((String)ValidationMessages.EJBConsistencyValidator_ejb_versions_inconsistent, (Object[])new Object[]{facetVersion.getVersionString(), ddStrVersion}));
        }
    }

    public String getName() {
        return "EJB Consistency";
    }
}

