/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.validation;

import com.ibm.etools.j2ee.internal.project.BinaryProjectVirtualComponent;
import com.ibm.etools.j2ee.migration.internal.OldJ2EESettings;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import com.ibm.etools.j2ee.migration.validation.AbstractJ2EEValidator;
import com.ibm.etools.j2ee.migration.validation.ValidationMessages;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.EARProjectMap;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.ModuleMapping;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.UtilityJARMapping;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class EARForwardConsistencyValidator
extends AbstractJ2EEValidator {
    public static final String ID = "EARForwardConsistencyValidator";

    protected void doValidate(IProject project, IProgressMonitor subMonitor) {
        Set hasNatures = this.hasNatures(project, earNatureSet);
        if (hasNatures.isEmpty()) {
            this.reportInformation(ValidationMessages.EARForwardValidator_not_backlevel_ear);
            return;
        }
        for (String natureID : hasNatures) {
            this.reportInformation(NLS.bind((String)ValidationMessages.EARForwardValidator_found_backlevel_ear_nature, (Object)natureID));
        }
        HashSet incompatibleNatures = new HashSet();
        incompatibleNatures.addAll(ejbNatureSet);
        incompatibleNatures.addAll(appClientNatureSet);
        incompatibleNatures.addAll(webNatureSet);
        incompatibleNatures.addAll(rarNatureSet);
        this.reportIncompatibleNatures(project, incompatibleNatures);
        if (!this.didRequiresValidatorsSucceed()) {
            return;
        }
        if (!this.verifyFacetedComponentProject(project, EAR_FACET)) {
            return;
        }
        IFile dotJ2EE = project.getFile(".j2ee");
        if (!dotJ2EE.exists()) {
            boolean foundV6Nature;
            boolean bl = foundV6Nature = !this.hasNatures(project, v6NatureSet).isEmpty();
            if (foundV6Nature) {
                this.reportWarning(ValidationMessages.EARForwardValidator_ear_j2ee_file_missing);
            }
        } else {
            IProjectFacetVersion facetVersion;
            OldJ2EESettings j2eeSetting = new OldJ2EESettings(project);
            int dotJ2EEModuleVersion = j2eeSetting.getModuleVersion();
            String dotJ2EEModuleVersionString = J2EEVersionUtil.convertVersionIntToString((int)dotJ2EEModuleVersion);
            if (dotJ2EEModuleVersionString.equals((facetVersion = this.getFacetVersion(project, EAR_FACET)).getVersionString())) {
                this.reportSuccess(ValidationMessages.EARForwardValidator_ear_versions_consistent);
            } else {
                this.reportWarning(NLS.bind((String)ValidationMessages.EARForwardValidator_ear_versions_inconsistent, (Object[])new Object[]{dotJ2EEModuleVersion, facetVersion.getVersionString()}));
                this.reportWarning(ValidationMessages.J2EEMigrationValidation_remove_obsolete_data);
            }
        }
        try {
            this.reportInformation(ValidationMessages.EARForwardValidator_checking_ear_dependencies);
            IFile dotModuleMaps = project.getFile("META-INF/.modulemaps");
            if (!dotModuleMaps.exists()) {
                this.reportWarning(ValidationMessages.EARForwardValidator_module_maps_missing);
            } else {
                Resource resource = WorkbenchResourceHelperBase.getResource((IFile)dotModuleMaps, (boolean)true);
                if (resource == null || resource.getContents().size() == 0) {
                    this.reportWarning(ValidationMessages.EARForwardValidator_backlevel_model_load_failed);
                } else {
                    EARProjectMap projectMap = (EARProjectMap)resource.getContents().get(0);
                    if (projectMap != null) {
                        this.reportInformation(ValidationMessages.EARForwardValidator_loaded_v6_model);
                        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)project);
                        IVirtualReference[] references = earComponent.getReferences();
                        EList moduleMaps = projectMap.getMappings();
                        int j = 0;
                        int m = moduleMaps.size();
                        while (j < m) {
                            ModuleMapping moduleMapping = (ModuleMapping)moduleMaps.get(j);
                            Module module = moduleMapping.getModule();
                            String facetType = "jst.utility";
                            if (module.isConnectorModule()) {
                                facetType = "jst.connector";
                            } else if (module.isEjbModule()) {
                                facetType = "jst.ejb";
                            } else if (module.isJavaModule()) {
                                facetType = "jst.appclient";
                            } else if (module.isWebModule()) {
                                facetType = "jst.web";
                            }
                            IProject moduleProject = ProjectUtilities.getProject((String)moduleMapping.getProjectName());
                            this.validateDependency(moduleProject, references, facetType);
                            ++j;
                        }
                        EList utilityMaps = projectMap.getUtilityJARMappings();
                        int j2 = 0;
                        int m2 = utilityMaps.size();
                        while (j2 < m2) {
                            UtilityJARMapping utilityMapping = (UtilityJARMapping)utilityMaps.get(j2);
                            String mappedProjectName = utilityMapping.getProjectName();
                            IProject mappedProject = ProjectUtilities.getProject((String)mappedProjectName);
                            this.validateDependency(mappedProject, references, "jst.utility");
                            ++j2;
                        }
                        if (moduleMaps.size() == 0 && utilityMaps.size() == 0) {
                            this.reportSuccess(ValidationMessages.EARForwardValidator_no_v6_mappings);
                        }
                    } else {
                        this.reportWarning(ValidationMessages.EARForwardValidator_check_dependencies_failed);
                    }
                }
            }
        }
        finally {
            this.reportInformation(ValidationMessages.EARForwardValidator_finished_dependency_check);
        }
    }

    protected void validateDependency(IProject dependentProject, IVirtualReference[] references, String facetType) {
        String moduleTypeStr = ValidationMessages.EARForwardValidator_module_type_utility;
        if (facetType == "jst.ejb") {
            moduleTypeStr = ValidationMessages.EARForwardValidator_module_type_ejb;
        } else if (facetType == "jst.appclient") {
            moduleTypeStr = ValidationMessages.EARForwardValidator_module_type_app;
        } else if (facetType == "jst.connector") {
            moduleTypeStr = ValidationMessages.EARForwardValidator_module_type_connector;
        } else if (facetType == "jst.web") {
            moduleTypeStr = ValidationMessages.EARForwardValidator_module_type_web;
        }
        if (dependentProject.isAccessible()) {
            boolean foundReference = false;
            int i = 0;
            while (i < references.length && !foundReference) {
                if (references[i].getReferencedComponent().getProject().equals((Object)dependentProject)) {
                    foundReference = true;
                }
                ++i;
            }
            if (foundReference) {
                this.reportSuccess(NLS.bind((String)ValidationMessages.EARForwardValidator_verified_dependency, (Object[])new Object[]{moduleTypeStr, dependentProject.getName()}));
                boolean foundFacet = false;
                boolean isFacetedProject = false;
                String foundFacetType = facetType;
                try {
                    IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)foundFacetType);
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)dependentProject);
                    boolean bl = isFacetedProject = facetedProject != null;
                    if (facetedProject != null) {
                        if (isFacetedProject) {
                            foundFacet = facetedProject.hasProjectFacet(facet);
                        }
                        if (!foundFacet && facetType == "jst.utility") {
                            foundFacetType = "jst.java";
                            IProjectFacet javaFacet = ProjectFacetsManager.getProjectFacet((String)foundFacetType);
                            foundFacet = facetedProject.hasProjectFacet(javaFacet);
                        }
                    }
                }
                catch (Exception e) {
                    J2EEMigrationPlugin.logError(e);
                }
                if (foundFacet) {
                    this.reportSuccess(NLS.bind((String)ValidationMessages.EARForwardValidator_dependent_proj_faceted, (Object[])new Object[]{moduleTypeStr, dependentProject.getName(), foundFacetType}));
                } else if (isFacetedProject) {
                    this.reportSuccess(NLS.bind((String)ValidationMessages.EARForwardValidator_verified_dependent_faceted, (Object[])new Object[]{moduleTypeStr, dependentProject.getName()}));
                    this.reportError(NLS.bind((String)ValidationMessages.EARForwardValidator_invalid_faceted_type, (Object[])new Object[]{moduleTypeStr, dependentProject.getName(), foundFacetType}));
                } else if (!BinaryProjectVirtualComponent.isBinaryProject((IProject)dependentProject)) {
                    this.reportError(NLS.bind((String)ValidationMessages.EARForwardValidator_dependent_not_faceted, (Object[])new Object[]{moduleTypeStr, dependentProject.getName()}));
                }
            } else if (ComponentCore.createComponent((IProject)dependentProject) != null) {
                this.reportError(NLS.bind((String)ValidationMessages.EARForwardValidator_component_missing_dependent, (Object[])new Object[]{moduleTypeStr, dependentProject.getName()}));
                this.reportError(ValidationMessages.J2EEMigrationValidation_add_dependency);
            } else {
                this.reportError(NLS.bind((String)ValidationMessages.EARForwardValidator_dependent_not_component_proj, (Object[])new Object[]{moduleTypeStr, dependentProject.getName()}));
                this.reportError(ValidationMessages.J2EEMigrationValidation_add_dependency);
            }
        } else if (!dependentProject.exists()) {
            this.reportWarning(NLS.bind((String)ValidationMessages.EARForwardValidator_dependent_proj_non_existant, (Object[])new Object[]{moduleTypeStr, dependentProject.getName()}));
        } else {
            this.reportWarning(NLS.bind((String)ValidationMessages.EARForwardValidator_dependent_proj_closed, (Object[])new Object[]{moduleTypeStr, dependentProject.getName()}));
        }
    }

    public String getName() {
        return "EAR Forward Consistency";
    }
}

