/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.validation;

import com.ibm.etools.j2ee.migration.validation.AbstractJ2EEValidator;
import com.ibm.etools.j2ee.migration.validation.ValidationMessages;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class EARConsistencyValidator
extends AbstractJ2EEValidator {
    public static final String ID = "EARConsistencyValidator";

    protected void doValidate(IProject project, IProgressMonitor subMonitor) {
        if (!this.checkForFacetedComponentProject(project, EAR_FACET, ValidationMessages.EARConsistencyValidator_not_ear_project)) {
            IVirtualComponent component;
            IVirtualFile vDDFile;
            if (this.canLoadComponent(project) && !this.canLoadFacets(project) && (vDDFile = (component = ComponentCore.createComponent((IProject)project)).getRootFolder().getFile("META-INF/application.xml")).exists()) {
                this.reportError(NLS.bind((String)ValidationMessages.EARConsistencyValidator_contains_dd_file, (Object)vDDFile.getUnderlyingFile().getProjectRelativePath()));
            }
            return;
        }
        HashSet<IProjectFacet> incompatibleFacets = new HashSet<IProjectFacet>();
        incompatibleFacets.add(EJB_FACET);
        incompatibleFacets.add(STATICWEB_FACET);
        incompatibleFacets.add(JCA_FACET);
        incompatibleFacets.add(APPCLIENT_FACET);
        incompatibleFacets.add(WEB_FACET);
        incompatibleFacets.add(UTILITY_FACET);
        this.reportIncompatibleFacets(project, incompatibleFacets);
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        String ddVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
        int j2eeVersion = J2EEVersionUtil.convertVersionStringToInt((String)ddVersion);
        if (j2eeVersion < 50) {
            IVirtualFile vDDFile = component.getRootFolder().getFile("META-INF/application.xml");
            if (vDDFile.exists()) {
                this.reportInformation(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_found_file, (Object)vDDFile.getUnderlyingFile().getProjectRelativePath()));
            } else {
                this.reportError(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_not_properly_mapped, (Object)vDDFile.getRuntimePath()));
                return;
            }
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object mObj = provider.getModelObject();
        boolean modelLoaded = false;
        if (mObj != null && provider.getModelObject((IPath)new Path("META-INF/application.xml")) != null) {
            modelLoaded = true;
        }
        if (!modelLoaded) {
            this.reportError(ValidationMessages.EARConsistencyValidator_xml_model_load_failed);
        } else {
            this.reportSuccess(ValidationMessages.EARConsistencyValidator_xml_model_load_success);
            IProjectFacetVersion earFacetVersion = this.getFacetVersion(project, EAR_FACET);
            this.verifyCorrectVersion(earFacetVersion, ddVersion);
        }
    }

    private void verifyCorrectVersion(IProjectFacetVersion facetVersion, String ddStrVersion) {
        if (facetVersion.getVersionString().equals(ddStrVersion)) {
            this.reportSuccess(NLS.bind((String)ValidationMessages.EARConsistencyValidator_versions_consistent, (Object)ddStrVersion));
        } else {
            int ddIntVersion = J2EEVersionUtil.convertVersionStringToInt((String)ddStrVersion);
            int facetIntVersion = J2EEVersionUtil.convertVersionStringToInt((String)facetVersion.getVersionString());
            if (ddIntVersion == 14 && facetIntVersion >= 14) {
                this.reportSuccess(ValidationMessages.EARConsistencyValidator_valid_versions);
            } else {
                this.reportError(NLS.bind((String)ValidationMessages.EARConsistencyValidator_versions_not_consistent, (Object[])new Object[]{facetVersion.getVersionString(), ddStrVersion}));
            }
        }
    }

    public String getName() {
        return "EAR consistency";
    }
}

