/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.validation;

import com.ibm.etools.j2ee.migration.internal.OldJ2EESettings;
import com.ibm.etools.j2ee.migration.validation.AbstractJ2EEValidator;
import com.ibm.etools.j2ee.migration.validation.ValidationMessages;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class ConnectorForwardConsistencyValidator
extends AbstractJ2EEValidator {
    public static final String ID = "ConnectorForwardConsistencyValidator";

    protected void doValidate(IProject project, IProgressMonitor subMonitor) {
        Set hasNatures = this.hasNatures(project, rarNatureSet);
        if (hasNatures.isEmpty()) {
            this.reportInformation(ValidationMessages.ConnectorForwardValidator_not_backlevel_connector);
            return;
        }
        for (String natureID : hasNatures) {
            this.reportInformation(NLS.bind((String)ValidationMessages.ConnectorForwardValidator_found_backlevel_connector_nature, (Object)natureID));
        }
        HashSet incompatibleNatures = new HashSet();
        incompatibleNatures.addAll(earNatureSet);
        incompatibleNatures.addAll(appClientNatureSet);
        incompatibleNatures.addAll(webNatureSet);
        incompatibleNatures.addAll(ejbNatureSet);
        this.reportIncompatibleNatures(project, incompatibleNatures);
        if (!this.didRequiresValidatorsSucceed()) {
            return;
        }
        if (!this.verifyFacetedComponentProject(project, JCA_FACET)) {
            return;
        }
        IFile dotJ2EE = project.getFile(".j2ee");
        if (!dotJ2EE.exists()) {
            boolean foundV6Nature;
            boolean bl = foundV6Nature = !this.hasNatures(project, v6NatureSet).isEmpty();
            if (foundV6Nature) {
                this.reportWarning(ValidationMessages.ConnectorForwardValidator_connector_j2ee_file_missing);
            }
        } else {
            IProjectFacetVersion facetVersion;
            OldJ2EESettings j2eeSetting = new OldJ2EESettings(project);
            int dotJ2EEModuleVersion = j2eeSetting.getModuleVersion();
            String dotJ2EEModuleVersionString = J2EEVersionUtil.convertVersionIntToString((int)dotJ2EEModuleVersion);
            if (dotJ2EEModuleVersionString.equals((facetVersion = this.getFacetVersion(project, JCA_FACET)).getVersionString())) {
                this.reportSuccess(ValidationMessages.ConnectorForwardValidator_connector_versions_consistent);
            } else {
                this.reportWarning(NLS.bind((String)ValidationMessages.ConnectorForwardValidator_connector_version_inconsistency, (Object[])new Object[]{dotJ2EEModuleVersion, facetVersion.getVersionString()}));
                this.reportWarning(ValidationMessages.J2EEMigrationValidation_remove_obsolete_data);
            }
        }
    }

    public String getName() {
        return "Connector Forward Consistency";
    }
}

