/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.validation;

import com.ibm.etools.common.migration.validation.framework.AbstractMigrationValidator;
import com.ibm.etools.j2ee.migration.validation.ValidationMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.util.IModuleConstants;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ComponentConsistencyValidator
extends AbstractMigrationValidator {
    public static final String ID = "ComponentConsistencyValidator";

    public static boolean hasModuleCoreSettingsFile(IProject project) throws CoreException {
        IFile componentFile = project.getFile((IPath)IModuleConstants.COMPONENT_FILE_PATH);
        return componentFile.exists();
    }

    protected void doValidate(IProject project, IProgressMonitor subMonitor) {
        try {
            boolean hasComponentNature = this.hasNature(project, "org.eclipse.wst.common.modulecore.ModuleCoreNature");
            this.reportInformation(NLS.bind((String)ValidationMessages.ComponentConsistencyValidator_nature_exists, (Object[])new Object[]{"org.eclipse.wst.common.modulecore.ModuleCoreNature", hasComponentNature}));
            IFile componentFile = project.getFile((IPath)IModuleConstants.COMPONENT_FILE_PATH);
            boolean hasComponentFile = componentFile.exists();
            this.reportInformation(NLS.bind((String)ValidationMessages.ComponentConsistencyValidator_file_exists, (Object[])new Object[]{componentFile.getProjectRelativePath(), hasComponentFile}));
            boolean isValidComponent = false;
            if (hasComponentNature == hasComponentFile) {
                if (hasComponentNature) {
                    isValidComponent = true;
                    this.reportSuccess(ValidationMessages.ComponentConsistencyValidator_both_exist);
                } else {
                    this.reportSuccess(ValidationMessages.ComponentConsistencyValidator_neither_exist);
                }
            } else {
                if (hasComponentNature) {
                    this.reportError(NLS.bind((String)ValidationMessages.ComponentConsistencyValidator_file_missing, (Object[])new Object[]{"org.eclipse.wst.common.modulecore.ModuleCoreNature", componentFile.getProjectRelativePath()}));
                } else {
                    this.reportError(NLS.bind((String)ValidationMessages.ComponentConsistencyValidator_nature_missing, (Object[])new Object[]{componentFile.getProjectRelativePath(), "org.eclipse.wst.common.modulecore.ModuleCoreNature"}));
                }
                return;
            }
            if (isValidComponent) {
                IVirtualComponent virtualComponent = ComponentCore.createComponent((IProject)project);
                if (virtualComponent != null) {
                    this.reportSuccess(ValidationMessages.ComponentConsistencyValidator_loaded_component_model_success);
                } else {
                    this.reportError(ValidationMessages.ComponentConsistencyValidator_loaded_component_model_failed);
                }
            } else {
                this.reportInformation(ValidationMessages.J2EEMigrationValidation_not_component_project);
            }
        }
        finally {
            subMonitor.done();
        }
    }

    protected void validateReferencedComponents(IProject project) {
        IVirtualComponent thisComponent = ComponentCore.createComponent((IProject)project);
        StructureEdit core = null;
        try {
            WorkbenchComponent component;
            core = StructureEdit.getStructureEditForRead((IProject)project);
            if (core != null && core.getComponent() != null && (component = core.getComponent()) != null) {
                EList referencedComponents = component.getReferencedComponents();
                for (ReferencedComponent referencedComponent : referencedComponents) {
                    boolean isClassPathURI;
                    IVirtualReference vReference;
                    if (referencedComponent == null || (vReference = StructureEdit.createVirtualReference((IVirtualComponent)thisComponent, (ReferencedComponent)referencedComponent)) == null) continue;
                    vReference.setArchiveName(referencedComponent.getArchiveName());
                    if (vReference.getReferencedComponent() != null) {
                        if (vReference.getReferencedComponent().exists()) {
                            this.reportInformation(NLS.bind((String)ValidationMessages.ComponentConsistencyValidator_ref_component_found, (Object)vReference.getReferencedComponent()));
                            continue;
                        }
                        this.reportError(NLS.bind((String)ValidationMessages.ComponentConsistencyValidator_ref_component_not_found, (Object)vReference.getReferencedComponent()));
                        continue;
                    }
                    URI uri = referencedComponent.getHandle();
                    if (uri == null || (isClassPathURI = ModuleURIUtil.isClassPathURI((URI)uri))) continue;
                    try {
                        ModuleURIUtil.ensureValidFullyQualifiedModuleURI((URI)uri);
                        String projectName = uri.segment(1);
                        if (projectName == null || projectName.length() == 0) continue;
                        IProject aProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        if (!aProject.isOpen()) {
                            this.reportError(NLS.bind((String)ValidationMessages.ComponentConsistencyValidator_ref_proj_closed, (Object)aProject.getName()));
                            continue;
                        }
                        if (aProject.exists()) continue;
                        this.reportError(NLS.bind((String)ValidationMessages.ComponentConsistencyValidator_ref_proj_not_found, (Object)aProject.getName()));
                    }
                    catch (UnresolveableURIException unresolveableURIException) {}
                }
            }
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
    }

    public String getName() {
        return "Component Consistency";
    }
}

