/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.validation;

import com.ibm.etools.j2ee.internal.project.BinaryProjectVirtualComponent;
import com.ibm.etools.j2ee.migration.internal.OldJ2EESettings;
import com.ibm.etools.j2ee.migration.validation.AbstractJ2EEValidator;
import com.ibm.etools.j2ee.migration.validation.ValidationMessages;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class AppClientForwardValidator
extends AbstractJ2EEValidator {
    public static final String ID = "AppClientForwardValidator";

    protected void doValidate(IProject project, IProgressMonitor subMonitor) {
        Set hasNatures = this.hasNatures(project, appClientNatureSet);
        if (hasNatures.isEmpty()) {
            this.reportInformation(ValidationMessages.AppClientForwardValidator_not_backlevel_compat);
            return;
        }
        for (String natureID : hasNatures) {
            this.reportInformation(NLS.bind((String)ValidationMessages.AppClientForwardValidator_found_backlevel_nature, (Object)natureID));
        }
        HashSet incompatibleNatures = new HashSet();
        incompatibleNatures.addAll(earNatureSet);
        incompatibleNatures.addAll(ejbNatureSet);
        incompatibleNatures.addAll(webNatureSet);
        incompatibleNatures.addAll(rarNatureSet);
        this.reportIncompatibleNatures(project, incompatibleNatures);
        if (!this.didRequiresValidatorsSucceed()) {
            return;
        }
        if (BinaryProjectVirtualComponent.isBinaryProject((IProject)project)) {
            return;
        }
        if (!this.verifyFacetedComponentProject(project, APPCLIENT_FACET)) {
            return;
        }
        IFile dotJ2EE = project.getFile(".j2ee");
        if (!dotJ2EE.exists()) {
            boolean foundV6Nature;
            boolean bl = foundV6Nature = !this.hasNatures(project, v6NatureSet).isEmpty();
            if (foundV6Nature) {
                this.reportWarning(ValidationMessages.AppClientForwardValidator_app_missing_j2ee_file);
            }
        } else {
            IProjectFacetVersion facetVersion;
            OldJ2EESettings j2eeSetting = new OldJ2EESettings(project);
            int dotJ2EEModuleVersion = j2eeSetting.getModuleVersion();
            String dotJ2EEModuleVersionString = J2EEVersionUtil.convertVersionIntToString((int)dotJ2EEModuleVersion);
            if (dotJ2EEModuleVersionString.equals((facetVersion = this.getFacetVersion(project, APPCLIENT_FACET)).getVersionString())) {
                this.reportSuccess(ValidationMessages.AppClientForwardValidator_app_levels_consistent);
            } else {
                this.reportWarning(NLS.bind((String)ValidationMessages.AppClientForwardValidator_app_levels_inconsistent, (Object[])new Object[]{dotJ2EEModuleVersion, facetVersion.getVersionString()}));
                this.reportWarning(ValidationMessages.J2EEMigrationValidation_remove_obsolete_data);
            }
        }
    }

    public String getName() {
        return "Application Client Forward Consistency";
    }
}

