/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.validation;

import com.ibm.etools.common.migration.validation.framework.AbstractMigrationValidator;
import com.ibm.etools.j2ee.internal.project.BinaryProjectVirtualComponent;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import com.ibm.etools.j2ee.migration.validation.ValidationMessages;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public abstract class AbstractJ2EEValidator
extends AbstractMigrationValidator {
    public static IProjectFacet EJB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
    public static final IProjectFacetVersion EJB_11 = EJB_FACET.getVersion("1.1");
    public static final IProjectFacetVersion EJB_20 = EJB_FACET.getVersion("2.0");
    public static final IProjectFacetVersion EJB_21 = EJB_FACET.getVersion("2.1");
    public static IProjectFacet WEB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    public static final IProjectFacetVersion WEB_22 = WEB_FACET.getVersion("2.2");
    public static final IProjectFacetVersion WEB_23 = WEB_FACET.getVersion("2.3");
    public static final IProjectFacetVersion WEB_24 = WEB_FACET.getVersion("2.4");
    public static IProjectFacet STATICWEB_FACET = ProjectFacetsManager.getProjectFacet((String)"wst.web");
    public static final IProjectFacetVersion STATICWEB_10 = STATICWEB_FACET.getVersion("1.0");
    public static IProjectFacet JCA_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.connector");
    public static final IProjectFacetVersion JCA_10 = JCA_FACET.getVersion("1.0");
    public static final IProjectFacetVersion JCA_15 = JCA_FACET.getVersion("1.5");
    public static IProjectFacet EAR_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
    public static final IProjectFacetVersion EAR_12 = EAR_FACET.getVersion("1.2");
    public static final IProjectFacetVersion EAR_13 = EAR_FACET.getVersion("1.3");
    public static final IProjectFacetVersion EAR_14 = EAR_FACET.getVersion("1.4");
    public static IProjectFacet APPCLIENT_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
    public static final IProjectFacetVersion APPCLIENT_12 = APPCLIENT_FACET.getVersion("1.2");
    public static final IProjectFacetVersion APPCLIENT_13 = APPCLIENT_FACET.getVersion("1.3");
    public static final IProjectFacetVersion APPCLIENT_14 = APPCLIENT_FACET.getVersion("1.4");
    public static IProjectFacet UTILITY_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
    public static final IProjectFacetVersion UTILITY_10 = UTILITY_FACET.getVersion("1.0");
    public static Set earNatureSet = new HashSet();
    public static Set appClientNatureSet = new HashSet();
    public static Set ejbNatureSet = new HashSet();
    public static Set webNatureSet = new HashSet();
    public static Set rarNatureSet = new HashSet();
    public static Set v6NatureSet = new HashSet();
    public static Set staticWebSet = new HashSet();

    static {
        earNatureSet.add("com.ibm.wtp.j2ee.EARNature");
        earNatureSet.add("com.ibm.etools.j2ee.EAR13Nature");
        earNatureSet.add("com.ibm.etools.j2ee.EARNature");
        appClientNatureSet.add("com.ibm.wtp.j2ee.ApplicationClientNature");
        appClientNatureSet.add("com.ibm.etools.j2ee.ApplicationClient_J2EE13_Nature");
        appClientNatureSet.add("com.ibm.etools.j2ee.ApplicationClientNature");
        ejbNatureSet.add("com.ibm.wtp.ejb.EJBNature");
        ejbNatureSet.add("com.ibm.etools.j2ee.EJB2_0Nature");
        ejbNatureSet.add("com.ibm.etools.j2ee.EJBNature");
        webNatureSet.add("com.ibm.wtp.web.WebNature");
        webNatureSet.add("com.ibm.etools.j2ee.WebNature");
        rarNatureSet.add("com.ibm.wtp.jca.ConnectorNature");
        rarNatureSet.add("com.ibm.etools.j2ee.ConnectorNature");
        v6NatureSet.add("com.ibm.wtp.j2ee.EARNature");
        v6NatureSet.add("com.ibm.wtp.j2ee.ApplicationClientNature");
        v6NatureSet.add("com.ibm.wtp.ejb.EJBNature");
        v6NatureSet.add("com.ibm.wtp.web.WebNature");
        v6NatureSet.add("com.ibm.wtp.jca.ConnectorNature");
        staticWebSet.add("com.ibm.wtp.web.StaticWebNature");
        staticWebSet.add("com.ibm.etools.j2ee.StaticWebNature");
    }

    public void reportIncompatibleFacets(IProject project, Set incompatibleFacets) {
        IFacetedProject facetedProject;
        this.reportInformation(ValidationMessages.J2EEMigrationValidation_check_facets);
        if (this.canLoadFacets(project) && (facetedProject = this.loadFacets(project)) != null) {
            for (IProjectFacet facet : incompatibleFacets) {
                IProjectFacetVersion version = facetedProject.getInstalledVersion(facet);
                if (version != null) {
                    this.reportError(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_imcompat_facet, (Object)version));
                    continue;
                }
                this.reportSuccess(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_facet_not_present, (Object)facet));
            }
        }
        this.reportInformation(ValidationMessages.J2EEMigrationValidation_finished_facet_check);
    }

    public IProjectFacetVersion getFacetVersion(IProject project, IProjectFacet facet) {
        IFacetedProject facetedProject;
        if (this.canLoadFacets(project) && (facetedProject = this.loadFacets(project)) != null) {
            return facetedProject.getInstalledVersion(facet);
        }
        return null;
    }

    public IFacetedProject loadFacets(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            return facetedProject;
        }
        catch (CoreException e) {
            J2EEMigrationPlugin.logError(e);
            this.reportError(ValidationMessages.J2EEMigrationValidation_failed_facet_model_load);
            this.reportError((Exception)((Object)e));
            return null;
        }
    }

    public boolean canLoadFacets(IProject project) {
        boolean hasNature = this.hasNature(project, "org.eclipse.wst.common.project.facet.core.nature");
        if (!hasNature) {
            return false;
        }
        return this.getSuccessfulMigratorIDs().contains("FacetConsistencyValidator");
    }

    public boolean canLoadComponent(IProject project) {
        boolean hasNature = this.hasNature(project, "org.eclipse.wst.common.modulecore.ModuleCoreNature");
        if (!hasNature) {
            return false;
        }
        return this.getSuccessfulMigratorIDs().contains("ComponentConsistencyValidator");
    }

    protected boolean verifyFacetedComponentProject(IProject project, IProjectFacet facet) {
        if (!this.canLoadFacets(project)) {
            this.reportError(ValidationMessages.J2EEMigrationValidation_not_faceted_project);
            this.reportError(ValidationMessages.J2EEMigrationValidation_reopen_workspace);
            return false;
        }
        if (!this.canLoadComponent(project)) {
            this.reportError(ValidationMessages.J2EEMigrationValidation_not_component_project);
            return false;
        }
        IProjectFacetVersion facetVersion = this.getFacetVersion(project, facet);
        if (facetVersion == null) {
            this.reportError(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_required_facet_missing, (Object)facet));
            return false;
        }
        this.reportInformation(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_contains_facet, (Object)facetVersion));
        return true;
    }

    protected boolean checkForFacetedComponentProject(IProject project, IProjectFacet facet, String messageIfNotInterested) {
        if (!this.canLoadFacets(project)) {
            this.reportInformation(messageIfNotInterested);
            return false;
        }
        if (!this.canLoadComponent(project)) {
            IProjectFacetVersion facetVersion = this.getFacetVersion(project, facet);
            if (facetVersion != null) {
                this.reportError(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_not_recognized_component_proj, (Object)facetVersion));
            } else {
                this.reportInformation(messageIfNotInterested);
            }
            return false;
        }
        IProjectFacetVersion facetVersion = this.getFacetVersion(project, facet);
        if (facetVersion == null) {
            this.reportInformation(messageIfNotInterested);
            return false;
        }
        this.reportInformation(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_contains_facet, (Object)facetVersion));
        return true;
    }

    protected void verifyReferencedProjectContainsAnyFacet(IProject project, Set validFacets) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            this.reportError(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_failed_component_model_load, (Object)project.getName()));
        } else {
            this.reportSuccess(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_successful_component_model_load, (Object)project.getName()));
        }
        if (!this.canLoadFacets(project)) {
            if (!BinaryProjectVirtualComponent.isBinaryProject((IProject)project)) {
                this.reportError(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_failed_facet_load, (Object)project.getName()));
            }
        } else {
            boolean success = false;
            for (IProjectFacet facet : validFacets) {
                IProjectFacetVersion facetVersion = this.getFacetVersion(project, facet);
                if (facetVersion != null) {
                    this.reportSuccess(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_successful_facet_load, (Object[])new Object[]{facetVersion, project.getName()}));
                    success = true;
                    continue;
                }
                this.reportInformation(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_nonexisting_facet, (Object[])new Object[]{facet, project.getName()}));
            }
            if (!success) {
                StringBuffer buff = new StringBuffer();
                buff.append(NLS.bind((String)ValidationMessages.J2EEMigrationValidation_facets_not_contained, (Object)project.getName()));
                for (IProjectFacet facet : validFacets) {
                    buff.append(facet.toString());
                    buff.append(" ");
                }
                this.reportError(buff.toString());
            }
        }
    }
}

