/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.propertytester;

import com.ibm.etools.j2ee.ILibModule;
import com.ibm.etools.j2ee.migration.internal.OldWebSettings;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.EARProjectMap;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.ModuleMappingImpl;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.UtilityJARMapping;

public class UtilityProjectPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IProject) {
            IProject project = (IProject)receiver;
            return this.projectIsUtil(project);
        }
        return false;
    }

    private boolean projectIsUtil(IProject project) {
        HashSet utilities;
        HashMap moduleMaps = J2EEMigrationPlugin.getDefault().getModuleMaps();
        if (moduleMaps == null) {
            this.loadMaps(project);
        }
        return (utilities = J2EEMigrationPlugin.getDefault().getUtilityMaps()).contains(project.getName());
    }

    private void loadMaps(IProject project) {
        HashMap projects = this.getProjectsInWorkbench(project);
        HashMap<IProject, EarProjectModules> earModules = new HashMap<IProject, EarProjectModules>();
        HashSet<String> utilities = new HashSet<String>();
        for (IProject proj : projects.keySet()) {
            boolean isEar = (Boolean)projects.get(proj);
            if (isEar) {
                Object obj;
                IFile file = proj.getFile("META-INF/.modulemaps".toString());
                if (!file.exists()) continue;
                Resource resource = null;
                try {
                    resource = WorkbenchResourceHelperBase.getResource((IFile)file, (boolean)true);
                }
                catch (Exception e) {
                    J2EEMigrationPlugin.logError(e);
                }
                if (resource == null || resource.getContents().size() == 0 || (obj = resource.getContents().get(0)) == null) continue;
                EARProjectMap projectMap = (EARProjectMap)obj;
                EarProjectModules modules = new EarProjectModules();
                EList moduleMaps = projectMap.getMappings();
                for (ModuleMappingImpl moduleMapping : moduleMaps) {
                    modules.getModuleProjects().put(moduleMapping.getProjectName(), moduleMapping);
                }
                EList utilityMaps = projectMap.getUtilityJARMappings();
                for (UtilityJARMapping jarMapping : utilityMaps) {
                    modules.getUtilityProjects().put(jarMapping.getProjectName(), jarMapping.getUri());
                    utilities.add(jarMapping.getProjectName());
                }
                earModules.put(proj, modules);
                continue;
            }
            IFile dotWebSettings = proj.getFile(".websettings");
            if (!dotWebSettings.exists()) continue;
            OldWebSettings webSettings = new OldWebSettings(proj);
            ILibModule[] libModules = webSettings.getLibModules();
            int i = 0;
            while (i < libModules.length) {
                utilities.add(libModules[i].getProject().getName());
                ++i;
            }
        }
        J2EEMigrationPlugin.getDefault().setModuleMaps(earModules);
        J2EEMigrationPlugin.getDefault().setUtilityMaps(utilities);
    }

    private HashMap getProjectsInWorkbench(IProject project) {
        List<IProject> allProjects = Arrays.asList(project.getWorkspace().getRoot().getProjects());
        HashMap<IProject, Boolean> projects = new HashMap<IProject, Boolean>();
        int i = 0;
        while (i < allProjects.size()) {
            IProject p = allProjects.get(i);
            if (p.exists() && p.isOpen()) {
                if (this.isEarProject(p)) {
                    projects.put(p, Boolean.TRUE);
                } else if (this.isWebProject(p)) {
                    projects.put(p, Boolean.FALSE);
                }
            }
            ++i;
        }
        return projects;
    }

    private boolean isEarProject(IProject project) {
        return this.hasNature(project, "com.ibm.wtp.j2ee.EARNature") || this.hasNature(project, "com.ibm.etools.j2ee.EARNature") || this.hasNature(project, "com.ibm.etools.j2ee.EAR13Nature") || this.hasNature(project, "org.eclipse.jst.j2ee.EARNature");
    }

    private boolean isWebProject(IProject project) {
        return this.hasNature(project, "org.eclipse.jst.j2ee.web.WebNature") || this.hasNature(project, "com.ibm.wtp.web.WebNature") || this.hasNature(project, "com.ibm.etools.j2ee.WebNature");
    }

    private boolean hasNature(IProject project, String natureId) {
        if (project == null || !project.isAccessible()) {
            return false;
        }
        try {
            return project.hasNature(natureId);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public class EarProjectModules {
        private HashMap utilityMap = new HashMap();
        private HashMap moduleMap = new HashMap();

        public HashMap getUtilityProjects() {
            return this.utilityMap;
        }

        public HashMap getModuleProjects() {
            return this.moduleMap;
        }
    }
}

