/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.plugin;

import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import com.ibm.etools.common.migration.framework.IMigrationEvent;
import com.ibm.etools.common.migration.framework.IMigrationListener;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class J2EEMigrationPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.ibm.etools.j2ee.migration";
    private static J2EEMigrationPlugin plugin;
    private IMigrationListener migrationListener;
    private HashMap moduleMaps;
    private HashSet utilityMaps;

    public J2EEMigrationPlugin() {
        plugin = this;
        this.migrationListener = new IMigrationListener(){

            public void handleEvent(IMigrationEvent event) {
                if (event.getType() == 3) {
                    J2EEMigrationPlugin.getDefault().setModuleMaps(null);
                    J2EEMigrationPlugin.getDefault().setUtilityMaps(null);
                }
                if (event.getType() == 2) {
                    J2EEMigrationPlugin.getDefault().setModuleMaps(null);
                    J2EEMigrationPlugin.getDefault().setUtilityMaps(null);
                }
            }
        };
        MigrationPlugin.getMigrationFramework().addMigrationListener(this.migrationListener);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        MigrationPlugin.getMigrationFramework().removeMigrationListener(this.migrationListener);
        plugin = null;
        super.stop(context);
    }

    public HashMap getModuleMaps() {
        return this.moduleMaps;
    }

    public void setModuleMaps(HashMap moduleMaps) {
        this.moduleMaps = moduleMaps;
    }

    public HashSet getUtilityMaps() {
        return this.utilityMaps;
    }

    public void setUtilityMaps(HashSet utilityMaps) {
        this.utilityMaps = utilityMaps;
    }

    public static J2EEMigrationPlugin getDefault() {
        return plugin;
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return J2EEMigrationPlugin.createStatus(severity, message, null);
    }

    public static void logWarning(String message) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(J2EEMigrationPlugin.createStatus(2, message));
    }

    public static void logError(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(J2EEMigrationPlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(exception.getStatus());
    }

    public static void logInfo(String message) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(J2EEMigrationPlugin.createStatus(1, message));
    }

    public static void logError(String message) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(J2EEMigrationPlugin.createStatus(4, message));
    }
}

