/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.internal.SpecificationMigrator;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.J2EEStatus;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wscommon.DescriptionType;
import org.eclipse.jst.j2ee.webservice.wscommon.InitParam;
import org.eclipse.jst.j2ee.webservice.wscommon.SOAPHeader;
import org.eclipse.jst.j2ee.webservice.wscommon.WscommonFactory;
import org.eclipse.jst.j2ee.webservice.wsdd.Handler;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLPort;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;

public class WebServicesSpecificationMigrator
extends SpecificationMigrator {
    protected IProject project;
    private static final J2EEStatus WEBSERVICES_OK_STATUS = new J2EEStatus(0, J2EEMigrationUIResourceHandler.WebServicesSpecificationMigrator_UI_0);
    private static final J2EEStatus NO_WEBSERVICES_STATUS = new J2EEStatus(0, J2EEMigrationUIResourceHandler.WebServicesSpecificationMigrator_UI_1);

    public WebServicesSpecificationMigrator(String aVersion, boolean complex) {
        super(aVersion, complex);
    }

    public WebServicesSpecificationMigrator(IProject project, String aVersion, boolean complex) {
        super(null, aVersion, complex);
        this.project = project;
    }

    protected J2EEStatus migrateWebServiceResourceTo14IfExists() {
        block9: {
            WSDDArtifactEdit edit = null;
            try {
                WsddResource resource;
                edit = WSDDArtifactEdit.getWSDDArtifactEditForRead((IProject)this.project);
                if (edit == null || (resource = edit.getWsddXmiResource()) == null) break block9;
                resource.setVersionID(14);
                if (resource.getContents().isEmpty()) break block9;
                EObject rootObject = resource.getRootObject();
                resource.getContents().remove((Object)rootObject);
                resource.getContents().add((Object)rootObject);
                try {
                    this.migrateStatelessSessionBeans(resource);
                    this.migrateDescriptions(resource);
                    this.migrateQNames(resource);
                    resource.saveIfNecessary();
                    J2EEStatus j2EEStatus = WEBSERVICES_OK_STATUS;
                    return j2EEStatus;
                }
                catch (Exception e) {
                    try {
                        J2EEMigrationPlugin.logError(e);
                    }
                    catch (IllegalArgumentException e2) {
                        J2EEMigrationPlugin.logError(e2);
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        return NO_WEBSERVICES_STATUS;
    }

    private void migrateStatelessSessionBeans(WsddResource resource) {
        EJBArtifactEdit artifactEdit = null;
        try {
            artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.project);
            if (artifactEdit != null) {
                WebServices ws = resource.getWebServices();
                EList wsds = ws.getWebServiceDescriptions();
                int i = 0;
                while (i < wsds.size()) {
                    WebServiceDescription wsd = (WebServiceDescription)wsds.get(i);
                    EList pcs = wsd.getPortComponents();
                    int j = 0;
                    while (j < pcs.size()) {
                        PortComponent pc = (PortComponent)pcs.get(j);
                        ServiceImplBean sBean = pc.getServiceImplBean();
                        if (sBean != null) {
                            EJBJar jar;
                            EnterpriseBean bean;
                            String ejbName = sBean.getEEJBLink().getEjbLink();
                            String seiName = pc.getServiceEndpointInterface();
                            if (ejbName != null && seiName != null && (bean = (jar = artifactEdit.getEJBJar()).getEnterpriseBeanNamed(ejbName)) != null) {
                                ((Session)bean).setServiceEndpointName(seiName);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void migrateDescriptions(WsddResource resource) {
        WebServices ws = resource.getWebServices();
        EList wsds = ws.getWebServiceDescriptions();
        int i = 0;
        while (i < wsds.size()) {
            WebServiceDescription wsd = (WebServiceDescription)wsds.get(i);
            EList portComponents = wsd.getPortComponents();
            int j = 0;
            while (j < portComponents.size()) {
                PortComponent pc = (PortComponent)portComponents.get(j);
                EList handlers = pc.getHandlers();
                int k = 0;
                while (k < handlers.size()) {
                    Handler handler = (Handler)handlers.get(k);
                    EList initParams = handler.getInitParams();
                    int l = 0;
                    while (l < initParams.size()) {
                        InitParam initParam = (InitParam)initParams.get(l);
                        String description = initParam.getDescription();
                        DescriptionType descType = WscommonFactory.eINSTANCE.createDescriptionType();
                        descType.setValue(description);
                        initParam.getDescriptionTypes().add((Object)descType);
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void migrateQNames(WsddResource resource) {
        WebServices ws = resource.getWebServices();
        EList wsds = ws.getWebServiceDescriptions();
        int i = 0;
        while (i < wsds.size()) {
            WebServiceDescription desc = (WebServiceDescription)wsds.get(i);
            EList pcs = desc.getPortComponents();
            int j = 0;
            while (j < pcs.size()) {
                PortComponent pc = (PortComponent)pcs.get(j);
                WSDLPort wsdlPort = pc.getWsdlPort();
                String prefix = "pfx";
                String namespaceURI = wsdlPort.getNamespaceURI();
                String localPart = wsdlPort.getLocalPart();
                wsdlPort.setValues(prefix, namespaceURI, localPart);
                EList handlers = pc.getHandlers();
                int k = 0;
                while (k < handlers.size()) {
                    Handler handler = (Handler)handlers.get(k);
                    EList soapHeaders = handler.getSoapHeaders();
                    int l = 0;
                    while (l < soapHeaders.size()) {
                        SOAPHeader sp = (SOAPHeader)soapHeaders.get(l);
                        namespaceURI = sp.getNamespaceURI();
                        localPart = sp.getLocalPart();
                        sp.setValues(prefix, namespaceURI, localPart);
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

